<?php

/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if (! defined('ABSPATH')) {
    exit;
}

if ($upsells) : ?>

    <section class="up-sells upsells products">

        <div class="products-head">
            <div class="head-title">
                <?php
                $heading = apply_filters('woocommerce_product_upsells_products_heading', __('You may also like&hellip;', 'woocommerce'));

                if ($heading) :
                ?>
                    <h2><?php echo esc_html($heading); ?></h2>
                <?php endif; ?>
            </div>
            <div id="single-product-upsells-products-custom-nav" class="custom-nav"></div>
        </div>

        <?php woocommerce_product_loop_start(); ?>
        <div id="single-product-upsells-products" class="products-wrapper owl-carousel owl-theme">
            <?php foreach ($upsells as $upsell) : ?>

                <?php
                $post_object = get_post($upsell->get_id());

                setup_postdata($GLOBALS['post'] = &$post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

                wc_get_template_part('content', 'product');
                ?>

            <?php endforeach; ?>
        </div>
        <script>
            jQuery(`#single-product-upsells-products`).owlCarousel({
                items: 4,
                margin: 15,
                rtl: <?= (int) is_rtl(); ?>,
                lazyLoad: 1,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 3,
                    },
                    1024: {
                        items: 4,
                    },
                    1440: {
                        items: 4
                    }
                },
                nav: 1,
                navContainer: '#single-product-upsells-products-custom-nav',
                navText: [
                    '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
                    '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
                ],
                dots: 0,
                autoplay: 1,
                autoplayTimeout: 10000,
            });
        </script>
        <?php woocommerce_product_loop_end(); ?>

    </section>

<?php
endif;

wp_reset_postdata();
