<?php

/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://woocommerce.com/document/template-structure/
 * @package    WooCommerce\Templates
 * @version    1.6.4
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

global $product;

echo '<div class="product-title-con">';

if (get_theme_mod('single-product-layout', 'one') == 'one'):
	the_title('<h1 class="product_title entry-title"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>', '</h1>');

	if (wc_product_sku_enabled() && ($product->get_sku() || $product->is_type('variable'))) : ?>
		<span class="sku_wrapper"><span class="sku"><?php echo ($sku = $product->get_sku()) ? $sku : esc_html__('N/A', 'woocommerce'); ?></span></span>

	<?php
	endif;
endif;

if (get_theme_mod('single-product-layout', 'one') == 'two'):
	?>
	<div class="category-bar">
		<?php echo wc_get_product_category_list($product->get_id(), ', ', '<div class="meta-item posted_in"><label>' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'woocommerce') . '</label> ', '</div>'); ?>
		<div class="share-btn">
			<?php
			if (function_exists('ws_wccm_add_button')):
				echo '<li class="compare" title="' . __('Compare', 'webafra-store') . '">';
				ws_wccm_add_button();
				echo '</li>';
			endif;

			if (function_exists('tinvwl_shortcode_addtowishlist')) {
				echo '<li class="wishlists" title="' . __('Wishlist', 'webafra-store') . '">' . do_shortcode("[ti_wishlists_addtowishlist]") . '</li>';
			}

			echo '<li class="social-sharing" title="' . __('Share', 'webafra-store') . '"><button onclick="postSocialSharingPopup(' . $product->get_id() . ');" title="' . __('Share', 'webafra-store') . '" href="javascript:void(0);"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="18" cy="5" r="3"></circle><circle cx="6" cy="12" r="3"></circle><circle cx="18" cy="19" r="3"></circle><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"></line><line x1="15.41" y1="6.51" x2="8.59" y2="10.49"></line></svg></button></li>';
			?>
		</div>
	</div>

	<div class="title-bar">
		<div class="title"><?php the_title('<h1 class="product_title entry-title">', '</h1>'); ?></div>
		<div class="rating">
			<?= $product->get_average_rating(); ?>
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path fill="#FBBF24" d="M5.74 16c.11-.49-.09-1.19-.44-1.54l-2.43-2.43c-.76-.76-1.06-1.57-.84-2.27.23-.7.94-1.18 2-1.36l3.12-.52c.45-.08 1-.48 1.21-.89l1.72-3.45C10.58 2.55 11.26 2 12 2s1.42.55 1.92 1.54l1.72 3.45c.13.26.4.51.69.68L5.56 18.44c-.14.14-.38.01-.34-.19L5.74 16z" opacity="0.4"></path>
				<path fill="#FBBF24" d="M18.7 14.46c-.36.36-.56 1.05-.44 1.54l.69 3.01c.29 1.25.11 2.19-.51 2.64a1.5 1.5 0 01-.9.27c-.51 0-1.11-.19-1.77-.58l-2.93-1.74c-.46-.27-1.22-.27-1.68 0l-2.93 1.74c-1.11.65-2.06.76-2.67.31-.23-.17-.4-.4-.51-.7L17.21 8.79c.46-.46 1.11-.67 1.74-.56l1.01.17c1.06.18 1.77.66 2 1.36.22.7-.08 1.51-.84 2.27l-2.42 2.43z"></path>
			</svg>
		</div>
	</div>

	<div class="attr-bar">
		<?php
		$pa_brand = null;
		$brand_thumbnail_src = null;
		$pa_brands = wc_get_product_terms($product->get_id(), get_theme_mod('shop-brand-taxonomy', 'pa_brand'));
		if (!empty($pa_brands)) {
			$pa_brand = reset($pa_brands);
		}
		?>
		<?php if (!empty($pa_brand)): ?>
			<div class="meta-item product_brand">
				<label><?= __('Brand', 'webafra-store'); ?>:</label>
				<a title="<?= __('Brand', 'webafra-store'); ?>: <?= $pa_brand->name; ?>" href="<?= get_term_link($pa_brand); ?>"><?= $pa_brand->name; ?></a>
			</div>
		<?php endif; ?>
	</div>
<?php
endif;

echo '</div>';
