<?php

/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if (! defined('ABSPATH')) {
    exit;
}

global $product;
?>
<?php if (get_theme_mod('single-product-layout', 'one') == 'one'): ?>
    <div class="product_meta">
        <?php do_action('woocommerce_product_meta_start'); ?>

        <?php
        $pa_brand = null;
        $brand_thumbnail_src = null;
        $pa_brands = wc_get_product_terms($product->get_id(), get_theme_mod('shop-brand-taxonomy', 'pa_brand'));
        if (!empty($pa_brands)) {
            $pa_brand = reset($pa_brands);

            $brand_thumbnail_src = wc_placeholder_img_src();
            if ($brand_thumbnail_id = get_term_meta($pa_brand->term_id, 'product_attribute_image', true)) {
                if ($brand_thumbnail_image = wp_get_attachment_image_src($brand_thumbnail_id, 'woocommerce_thumbnail')) {
                    $brand_thumbnail_src = $brand_thumbnail_image[0];
                }
            }
        }
        ?>

        <?php if (!empty($pa_brand)): ?>
            <div class="product-brand-con">
                <a title="<?= __('Brand', 'webafra-store'); ?>: <?= $pa_brand->name; ?>" href="<?= get_term_link($pa_brand); ?>">
                    <img <?= ws_image_lazy_load_attr(); ?> alt="<?= __('Brand', 'webafra-store'); ?>: <?= $pa_brand->name; ?>" src="<?= $brand_thumbnail_src; ?>" />
                </a>
            </div>
        <?php endif; ?>

        <div class="product-primaryMeta">
            <?php if (!empty($pa_brand)): ?>
                <div class="meta-item product_brand">
                    <label><i class="fa-light fa-tag"></i><?= __('Brand', 'webafra-store'); ?>:</label>
                    <a title="<?= __('Brand', 'webafra-store'); ?>: <?= $pa_brand->name; ?>" href="<?= get_term_link($pa_brand); ?>"><?= $pa_brand->name; ?></a>
                </div>
            <?php endif; ?>

            <?php echo wc_get_product_category_list($product->get_id(), ', ', '<div class="meta-item posted_in"><label><i class="fa-light fa-store"></i>' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'woocommerce') . '</label> ', '</div>'); ?>

            <?php echo wc_get_product_tag_list($product->get_id(), ', ', '<div class="meta-item tagged_as"><label><i class="fa-light fa-tags"></i>' . _n('Tag:', 'Tags:', count($product->get_tag_ids()), 'woocommerce') . '</label> ', '</div>'); ?>
        </div>

        <?php do_action('woocommerce_product_meta_end'); ?>
    </div>
<?php endif; ?>