<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (! defined('ABSPATH')) {
    exit;
}

do_action('woocommerce_before_account_navigation');

$user_data = get_userdata(get_current_user_id());
?>

<nav class="woocommerce-MyAccount-navigation" aria-label="<?php esc_html_e('Account pages', 'woocommerce'); ?>">
    <section class="navigation-userPanel">
        <header class="navigation-userPanel-header">
            <div class="userPanel-user-displayName">
                <?= $user_data->display_name; ?>
            </div>
            <div class="userPanel-user-wlcMsg">
                <?= __('Welcome', 'webafra-store'); ?>
            </div>
        </header>

        <div class="navigation-userPanel-avatar">
            <?php if ($current_user_avatar = get_avatar($user_data, 128)): ?>
                <?php if (get_option('avatar_default', 'mystery') == 'blank'): ?>
                    <img <?= ws_image_lazy_load_attr(); ?> width="128" height="128" alt="<?= $user_data->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                <?php else: ?>
                    <?= $current_user_avatar; ?>
                <?php endif; ?>
            <?php else: ?>
                <img <?= ws_image_lazy_load_attr(); ?> width="128" height="128" alt="<?= $user_data->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
            <?php endif; ?>
        </div>

        <div class="navigation-userPanel-userInfo">
            <div class="userInfo-col">
                <label class="userInfo-name"><?= __('Your membership date', 'webafra-store'); ?></label>
                <div class="userInfo-value"><?= wp_date('Y/m/d', strtotime($user_data->user_registered)); ?></div>
            </div>
            <div class="userInfo-col">
                <label class="userInfo-name"><?= __('Today', 'webafra-store'); ?></label>
                <div class="userInfo-value"><?= wp_date('Y/m/d'); ?></div>
            </div>
        </div>

        <div class="navigation-userPanel-logout">
            <a href="<?= wc_logout_url(); ?>" title="<?= __('Logout', 'webafra-store'); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18.36 6.64a9 9 0 1 1-12.73 0"></path>
                    <line x1="12" y1="2" x2="12" y2="12"></line>
                </svg>
                <span><?= __('Logout', 'webafra-store'); ?></span>
            </a>
        </div>
    </section>

    <ul>
        <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
            <li class="<?php echo wc_get_account_menu_item_classes($endpoint); ?>">
                <a title="<?= esc_html($label); ?>" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" <?php echo wc_is_current_account_menu_item($endpoint) ? 'aria-current="page"' : ''; ?>>

                    <?php if ($endpoint == 'dashboard') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10" />
                            <path d="M16.2 7.8l-2 6.3-6.4 2.1 2-6.3z" />
                        </svg>
                    <?php endif; ?>

                    <?php if ($endpoint == 'orders') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M6 2L3 6v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2V6l-3-4H6zM3.8 6h16.4M16 10a4 4 0 1 1-8 0" />
                        </svg>
                    <?php endif; ?>

                    <?php if ($endpoint == 'downloads') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 15v4c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2v-4M17 9l-5 5-5-5M12 12.8V2.5" />
                        </svg>
                    <?php endif; ?>

                    <?php if ($endpoint == 'edit-address') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="10" r="3" />
                            <path d="M12 21.7C17.3 17 20 13 20 10a8 8 0 1 0-16 0c0 3 2.7 6.9 8 11.7z" />
                        </svg>
                    <?php endif; ?>

                    <?php if ($endpoint == 'edit-account') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M20 14.66V20a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.34"></path>
                            <polygon points="18 2 22 6 12 16 8 16 8 12 18 2"></polygon>
                        </svg>
                    <?php endif; ?>

                    <?php if ($endpoint == 'wishlist') : ?>
                        <i class="fa-light fa-heart"></i>
                    <?php endif; ?>

                    <?php if ($endpoint == 'tracking') : ?>
                        <i class="fa-light fa-truck-fast"></i>
                    <?php endif; ?>

                    <?php if ($endpoint == 'customer-logout') : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M18.36 6.64a9 9 0 1 1-12.73 0"></path>
                            <line x1="12" y1="2" x2="12" y2="12"></line>
                        </svg>
                    <?php endif; ?>

                    <?php echo esc_html($label); ?>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
</nav>

<?php do_action('woocommerce_after_account_navigation'); ?>