<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing'  => __('Billing address', 'woocommerce'),
            'shipping' => __('Shipping address', 'woocommerce'),
        ),
        $customer_id
    );
} else {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing' => __('Billing address', 'woocommerce'),
        ),
        $customer_id
    );
}

$oldcol = 1;
$col    = 1;
?>

<p>
    <?php echo apply_filters('woocommerce_my_account_my_address_description', esc_html__('The following addresses will be used on the checkout page by default.', 'woocommerce')); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
    ?>
</p>

<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
    <div class="u-columns woocommerce-Addresses col2-set addresses">
    <?php endif; ?>

    <?php foreach ($get_addresses as $name => $address_title) : ?>
        <?php
        $address = wc_get_account_formatted_address($name);
        $col     = $col * -1;
        $oldcol  = $oldcol * -1;
        ?>

        <div class="u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> woocommerce-Address">
            <header class="woocommerce-Address-title title">
                <h2><?php echo esc_html($address_title); ?></h2>
            </header>
            <address>
                <div class="address-details">
                    <?php
                    echo $address ? wp_kses_post($address) : esc_html_e('You have not set up this type of address yet.', 'woocommerce');

                    /**
                     * Used to output content after core address fields.
                     *
                     * @param string $name Address type.
                     * @since 8.7.0
                     */
                    do_action('woocommerce_my_account_after_my_address', $name);
                    ?>
                </div>

                <a href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>" class="edit">
                    <?php if ($address) : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M20 14.66V20a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.34"></path>
                            <polygon points="18 2 22 6 12 16 8 16 8 12 18 2"></polygon>
                        </svg>
                        <?= esc_html__('Edit', 'woocommerce'); ?>
                    <?php else : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" y1="8" x2="12" y2="16"></line>
                            <line x1="8" y1="12" x2="16" y2="12"></line>
                        </svg>
                        <?= esc_html__('Add', 'woocommerce'); ?>
                    <?php endif; ?>
                </a>
            </address>
        </div>

    <?php endforeach; ?>

    <?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
    </div>
<?php
    endif;
