<?php

/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined('ABSPATH') || exit;

global $wp;

$permalink_structure = get_option('permalink_structure');

$is_dashboard = ((!empty($permalink_structure) && count(explode('/', $wp->request)) == 1) || (empty($permalink_structure) && count(explode('/', $wp->query_vars)) == 1)) ? 1 : 0;

$user_data = get_userdata(get_current_user_id()); ?>

<div class="container">
    <div class="woocommerce-MyAccount-wrapper">
        <?php
        /**
         * My Account navigation.
         *
         * @since 2.6.0
         */
        do_action('woocommerce_account_navigation'); ?>

        <div class="woocommerce-MyAccount-content-wrapper">
            <?php if ($is_dashboard): ?>
                <section class="myAccount-stats">
                    <div class="stat-block">
                        <div class="block-right">
                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"></circle>
                                <polyline points="12 6 12 12 16 14"></polyline>
                            </svg>
                        </div>
                        <div class="block-left">
                            <label class="block-left-label"><?= __('Your membership date', 'webafra-store'); ?></label>
                            <div class="block-left-value"><?= wp_date('Y/m/d', strtotime($user_data->user_registered)); ?></div>
                        </div>
                    </div>
                    <div class="stat-block green">
                        <div class="block-right">
                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M6 2L3 6v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2V6l-3-4H6zM3.8 6h16.4M16 10a4 4 0 1 1-8 0" />
                            </svg>
                        </div>
                        <div class="block-left">
                            <label class="block-left-label"><?= __('Total orders', 'webafra-store'); ?></label>
                            <div class="block-left-value"><?= wc_get_customer_total_spent($user_data->ID); ?></div>
                        </div>
                    </div>
                    <div class="stat-block purple">
                        <div class="block-right">
                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M6 2L3 6v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2V6l-3-4H6zM3.8 6h16.4M16 10a4 4 0 1 1-8 0" />
                            </svg>
                        </div>
                        <div class="block-left">
                            <label class="block-left-label"><?= __('Total payment', 'webafra-store'); ?></label>
                            <div class="block-left-value"><?= wc_get_customer_order_count($user_data->ID); ?></div>
                        </div>
                    </div>
                    <div class="stat-block red">
                        <div class="block-right">
                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                            </svg>
                        </div>
                        <div class="block-left">
                            <label class="block-left-label"><?= __('Your comments', 'webafra-store'); ?></label>
                            <div class="block-left-value"><?= get_comments(['user_id' => $user_data->ID, 'count' => true]); ?></div>
                        </div>
                    </div>
                </section>

                <section class="myAccount-userDetails">
                    <div class="userDetails-securityNotice">
                        <div class="securityNotice-text">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#b77d1b" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <polygon points="7.86 2 16.14 2 22 7.86 22 16.14 16.14 22 7.86 22 2 16.14 2 7.86 7.86 2"></polygon>
                                <line x1="12" y1="8" x2="12" y2="12"></line>
                                <line x1="12" y1="16" x2="12.01" y2="16"></line>
                            </svg>
                            <span><?= __('To increase the security of your account and prevent misuse, please confirm your identity', 'webafra-store'); ?>.</span>
                        </div>

                        <a title="<?= __('Account Information', 'webafra-store'); ?>" href="<?= get_site_url(); ?>/my-account/edit-account/">
                            <span><?= __('Account Information', 'webafra-store'); ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M15 18l-6-6 6-6" />
                            </svg>
                        </a>
                    </div>

                    <div class="userDetails-info">
                        <div class="info-block">
                            <div class="block-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                            </div>
                            <div class="block-value"><?= $user_data->user_login; ?></div>
                        </div>
                        <div class="info-block">
                            <div class="block-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="8.5" cy="7" r="4"></circle>
                                    <polyline points="17 11 19 13 23 9"></polyline>
                                </svg>
                            </div>
                            <div class="block-value"><?= !empty($user_data->display_name) ? $user_data->display_name : '-'; ?></div>
                        </div>
                        <div class="info-block">
                            <div class="block-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="4"></circle>
                                    <path d="M16 8v5a3 3 0 0 0 6 0v-1a10 10 0 1 0-3.92 7.94"></path>
                                </svg>
                            </div>
                            <div class="block-value"><?= $user_data->user_email; ?></div>
                        </div>
                        <div class="info-block">
                            <div class="block-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="5" y="2" width="14" height="20" rx="2" ry="2"></rect>
                                    <line x1="12" y1="18" x2="12.01" y2="18"></line>
                                </svg>
                            </div>
                            <div class="block-value"><?= !empty(get_user_meta($user_data->ID, 'mobile_number', true)) ? esc_attr(get_user_meta($user_data->ID, 'mobile_number', true)) : '-'; ?></div>
                        </div>
                    </div>
                </section>

                <section class="myAccount-orderStats">
                    <div class="orderStats-col orderStats-orderStatus">
                        <header class="orderStats-header">
                            <h3><?= __('My orders', 'webafra-store'); ?></h3>
                            <a title="<?= __('See all', 'webafra-store'); ?>" href="<?= get_site_url(); ?>/my-account/orders/"><?= __('See all', 'webafra-store'); ?></a>
                        </header>

                        <?php foreach (
                            [
                                [
                                    'image' => 'pending-order.svg',
                                    'label' => __('Waiting', 'webafra-store'),
                                    'status' => 'pending',
                                ],
                                [
                                    'image' => 'processing-order.svg',
                                    'label' => __('Processing', 'webafra-store'),
                                    'status' => 'processing',
                                ],
                                [
                                    'image' => 'delivered-order.svg',
                                    'label' => __('Completed', 'webafra-store'),
                                    'status' => 'completed',
                                ],
                                [
                                    'image' => 'cancelled-order.svg',
                                    'label' => __('Cancelled', 'webafra-store'),
                                    'status' => 'cancelled',
                                ],
                            ] as $stat_item
                        ): ?>
                            <div class="orderStatus-item">
                                <img <?= ws_image_lazy_load_attr(); ?> src="<?= get_template_directory_uri(); ?>/assets/images/svgs/<?= $stat_item['image']; ?>" alt="order-<?= $stat_item['status']; ?>">
                                <div class="item-info">
                                    <div class="total"><?= ws_wc_get_current_user_orders_count($stat_item['status']); ?> <?= __('orders', 'webafra-store'); ?></div>
                                    <div class="label"><?= $stat_item['label']; ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="orderStats-col orderStats-chart">
                        <header class="orderStats-header">
                            <h3><?= __('Order report', 'webafra-store'); ?></h3>
                        </header>
                    </div>
                </section>
            <?php endif; ?>

            <div class="woocommerce-MyAccount-content">
                <?php
                /**
                 * My Account content.
                 *
                 * @since 2.6.0
                 */
                do_action('woocommerce_account_content');
                ?>
            </div>
        </div>
    </div>
</div>