<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;

get_header('shop');

$queried_object = get_queried_object();

$object_children = [];

if (!is_shop() && !empty($queried_object->taxonomy)) {
    $object_children = get_terms([
        'taxonomy' => $queried_object->taxonomy,
        'parent' => $queried_object->term_id,
        'depth' => 1,
        'hide_empty' => 0,
    ]);
}
?>
<div class="container">
    <div style="margin-top: 20px;"></div>
    <?php
    /**
     * Hook: woocommerce_before_main_content.
     *
     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
     * @hooked woocommerce_breadcrumb - 20
     * @hooked WC_Structured_Data::generate_website_data() - 30
     */
    do_action('woocommerce_before_main_content');
    ?>

    <?php if (get_theme_mod('archive-sub-categories-location', 'under_sorting') == 'under_breadcrumb'): ?>
        <?php get_template_part('templates/woocommerce/archive-children', null, [
            'object_children' => $object_children,
        ]); ?>
    <?php endif; ?>

    <div class="shop-archive">
        <aside class="shop-sidebar" id="shop-sidebar">
            <div class="shop-sidebar-head">
                <a href="javascript:void(0)" class="shop-sidebar-close" title="<?= __('Close', 'webafra-store'); ?>" aria-label="<?= __('Close', 'webafra-store'); ?>" data-title="<?= __('Close', 'webafra-store'); ?>" rel="nofollow" onclick="shopSideBarToggle();">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </a>
            </div>
            <?php
            /**
             * Hook: woocommerce_sidebar.
             *
             * @hooked woocommerce_get_sidebar - 10
             */
            do_action('woocommerce_sidebar');
            ?>
        </aside>
        <main class="shop-content">
            <?php
            /**
             * Hook: woocommerce_shop_loop_header.
             *
             * @since 8.6.0
             *
             * @hooked woocommerce_product_taxonomy_archive_header - 10
             */
            do_action('woocommerce_shop_loop_header');

            if (woocommerce_product_loop()) {

                /**
                 * Hook: woocommerce_before_shop_loop.
                 *
                 * @hooked woocommerce_output_all_notices - 10
                 * @hooked woocommerce_result_count - 20
                 * @hooked woocommerce_catalog_ordering - 30
                 */

                remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
                remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

                do_action('woocommerce_before_shop_loop'); ?>

                <?php if (get_theme_mod('archive-sub-categories-location', 'under_sorting') == 'under_sorting'): ?>
                    <?php get_template_part('templates/woocommerce/archive-children', null, [
                        'object_children' => $object_children,
                    ]); ?>
                <?php endif; ?>

            <?php
                woocommerce_product_loop_start();

                if (wc_get_loop_prop('total')) {
                    while (have_posts()) {
                        the_post();

                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action('woocommerce_shop_loop');

                        wc_get_template_part('content', 'product');
                    }
                }

                woocommerce_product_loop_end();

                /**
                 * Hook: woocommerce_after_shop_loop.
                 *
                 * @hooked woocommerce_pagination - 10
                 */
                do_action('woocommerce_after_shop_loop');
            } else {
                /**
                 * Hook: woocommerce_no_products_found.
                 *
                 * @hooked wc_no_products_found - 10
                 */
                do_action('woocommerce_no_products_found');
            }
            ?>

            <?php
            /**
             * Hook: woocommerce_archive_description.
             *
             * @hooked woocommerce_taxonomy_archive_description - 10
             * @hooked woocommerce_product_archive_description - 10
             */
            ob_start();
            do_action('woocommerce_archive_description');
            $woocommerce_archive_description = ob_get_clean();
            ?>

            <?php if ($woocommerce_archive_description && !empty($woocommerce_archive_description)): ?>
                <div class="archive-description" id="archive-description">
                    <?= $woocommerce_archive_description; ?>
                    <div class="description-mask" id="archive-descriptionMask">
                        <span class="button" onclick="archiveDescriptionMoreButton();">
                            <span><?= __('More', 'webafra-store'); ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M6 9l6 6 6-6" />
                            </svg>
                        </span>
                    </div>
                </div>
            <?php endif; ?>
        </main>
        <div class="overlay1" id="overlay3"></div>
    </div>
    <?php
    /**
     * Hook: woocommerce_after_main_content.
     *
     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
     */
    do_action('woocommerce_after_main_content');
    ?>
</div>
<?php
get_footer('shop');
