<?php
if (!defined('ABSPATH')) {
    die;
}
?>
<section class="my-account-tracking-result">
    <div class="tracking-porgressbar">
        <?php
        $tracking_progress_width = 'width:10%;';
        if ($order_data['status'] == 'pending') {
            $tracking_progress_width = 'width:10%;';
        } elseif ($order_data['status'] == 'on-hold') {
            $tracking_progress_width = 'width:40%;';
        } elseif ($order_data['status'] == 'processing') {
            $tracking_progress_width = 'width:70%;';
        } elseif ($order_data['status'] == 'completed') {
            $tracking_progress_width = 'width:100%;';
        }
        ?>
        <div class="tracking-progress" style="<?= $tracking_progress_width; ?>"></div>
        <div class="traking-steps">
            <div class="traking-step">
                <div class="traking-icon <?= $order_data['status'] == 'pending' ? 'active' : ''; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="1" x2="12" y2="23"></line>
                        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                    </svg>
                </div>
                <p><?= _x('Pending payment', 'Order status', 'woocommerce'); ?></p>
                <div class="traking-round <?= $order_data['status'] == 'pending' ? 'active' : ''; ?>"></div>
            </div>
            <div class="traking-step">
                <div class="traking-icon <?= $order_data['status'] == 'on-hold' ? 'active' : ''; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                </div>
                <p><?= _x('On hold', 'Order status', 'woocommerce'); ?></p>
                <div class="traking-round <?= $order_data['status'] == 'on-hold' ? 'active' : ''; ?>"></div>
            </div>
            <div class="traking-step">
                <div class="traking-icon <?= $order_data['status'] == 'processing' ? 'active' : ''; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="3"></circle>
                        <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
                    </svg>
                </div>
                <p><?= _x('Processing', 'Order status', 'woocommerce'); ?></p>
                <div class="traking-round <?= $order_data['status'] == 'processing' ? 'active' : ''; ?>"></div>
            </div>
            <div class="traking-step">
                <div class="traking-icon <?= $order_data['status'] == 'completed' ? 'active' : ''; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <p><?= _x('Completed', 'Order status', 'woocommerce'); ?></p>
                <div class="traking-round <?= $order_data['status'] == 'completed' ? 'active' : ''; ?>"></div>
            </div>
        </div>
    </div>
    <div class="my-account-tracking-list">
        <table>
            <tbody>
                <tr>
                    <td><?= __('Order tracking code', 'webafra-store'); ?></td>
                    <td><?= $order_data['id']; ?></td>
                </tr>
                <tr>
                    <td><?= __('Order registration date', 'webafra-store'); ?></td>
                    <td><?= $order_data['date_created']->date('Y-m-d H:i:s'); ?></td>
                </tr>
                <tr>
                    <td><?= __('Order status', 'webafra-store'); ?></td>
                    <td><?= wc_get_order_status_name($order_data['status']); ?></td>
                </tr>
                <tr>
                    <td><?= __('Order update', 'webafra-store'); ?></td>
                    <td><?= $order_data['date_modified']->date('Y-m-d H:i:s'); ?></td>
                </tr>

                <tr>
                    <td><?= __('Product', 'webafra-store'); ?></td>
                    <td>
                        <ul class="products-list">
                            <?= $products; ?>
                        </ul>
                    </td>
                </tr>

                <tr>
                    <td><?= __('Customer name', 'webafra-store'); ?></td>
                    <td><?= $order_customer; ?></td>
                </tr>
                <tr>
                    <td><?= __('Phone number', 'webafra-store'); ?></td>
                    <td><?= $order_data['billing']['phone']; ?></td>
                </tr>
                <tr>
                    <td><?= __('Customer note', 'webafra-store'); ?></td>
                    <td><?= !empty($customer_note) ? $customer_note : __('Not set', 'webafra-store'); ?></td>
                </tr>
                <tr>
                    <td><?= __('Delivery method', 'webafra-store'); ?></td>
                    <td><?= $shipping_method; ?></td>
                </tr>
                <tr>
                    <td><?= __('Payment Method', 'webafra-store'); ?></td>
                    <td><?= $payment_method; ?></td>
                </tr>
                <tr>
                    <td><?= __('The total amount of the order', 'webafra-store'); ?></td>
                    <td><?= $order_data['total']; ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</section>