<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<?php if (is_product_taxonomy() && !empty($args['object_children']) && get_theme_mod('enable-archive-sub-categories', 1)): ?>
    <section class="archive-subCategories">
        <div class="subCategories-heading">
            <h3><?= __('Sub categories', 'webafra-store'); ?></h3>
            <div id="product-archive-sub-categories-nav" class="custom-nav"></div>
        </div>

        <div id="product-archive-sub-categories" class="subCategories-wrapper owl-carousel owl-theme">
            <?php foreach ($args['object_children'] as $children): ?>
                <div class="sub-category">
                    <?php
                    $thumbnail_src = wc_placeholder_img_src();
                    if ($thumbnail_id = get_term_meta($children->term_id, 'thumbnail_id', true)) {
                        if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, 'woocommerce_thumbnail')) {
                            $thumbnail_src = $thumbnail_image[0];
                        }
                    }
                    ?>
                    <a title="<?= $children->name; ?>" href="<?= get_term_link($children); ?>">
                        <?php if (get_theme_mod('enable-archive-sub-categories-thumbnails', 1)): ?>
                            <figure class="thumbnail-<?= get_theme_mod('archive-sub-categories-thumbnails-location', 'right'); ?>">
                                <img <?= ws_image_lazy_load_attr(); ?> alt="<?= $children->name; ?>" src="<?= $thumbnail_src; ?>" />
                                <h2><?= $children->name; ?></h2>
                            </figure>
                        <?php else: ?>
                            <div class="category-name"><?= $children->name; ?></div>
                        <?php endif; ?>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
    <script>
        jQuery('#product-archive-sub-categories').owlCarousel({
            items: 4,
            margin: 20,
            rtl: 1,
            lazyLoad: 1,
            responsive: {
                0: {
                    items: 1
                },
                600: {
                    items: 3
                },
                1000: {
                    items: 4
                }
            },
            nav: 1,
            navContainer: '#product-archive-sub-categories-nav',
            navText: [
                '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
                '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
            ],
            dots: 0,
        });
    </script>
<?php endif; ?>