<?php
if (!defined('ABSPATH')) {
    exit;
}
extract($args);
$related_posts = ws_get_related_posts($post_id);
?>
<?php if (count($related_posts->get_posts())) : ?>
    <div class="related-posts">
        <div class="posts-head">
            <div class="head-title">
                <h2><?= __('Related posts', 'webafra-store'); ?></h2>
            </div>
            <div id="related-posts-custom-nav" class="custom-nav"></div>
        </div>
        <div id="related-posts-carousel" class="posts-wrapper owl-carousel owl-theme">
            <?php foreach ($related_posts->get_posts() as $post) : ?>
                <div class="post-loop">
                    <div class="floating-read-more">
                        <a href="<?= esc_url(get_permalink($post)); ?>" title="<?= get_the_title($post); ?>">
                            <i class="fa-light fa-file-lines"></i>
                            <span><?= __('Read more', 'webafra-store'); ?></span>
                        </a>
                    </div>
                    <div class="post-thumbnail">
                        <div class="thumbnail-img">
                            <?php
                            $thumbnail_src = ws_get_thumbnail_placeholder();
                            if ($thumbnail_id = get_post_thumbnail_id($post->ID)) {
                                if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, ['300','300'])) {
                                    $thumbnail_src = $thumbnail_image[0];
                                }
                            }
                            ?>
                            <a href="<?= esc_url(get_permalink($post)); ?>" title="<?= get_the_title($post); ?>">
                                <img <?= ws_image_lazy_load_attr(); ?> src="<?= $thumbnail_src; ?>" alt="<?= get_the_title($post); ?>" />
                            </a>
                        </div>

                        <div class="post-date">
                            <div class="post-date-day"><?= get_the_date('d', $post); ?></div>
                            <div class="post-date-month"><?= get_the_date('F', $post); ?></div>
                        </div>

                        <?php if ($primary_cat = ws_get_post_primary_cat($post->ID)): ?>
                            <div class="post-cat">
                                <a title="<?= $primary_cat->name; ?>" href="<?= get_term_link($primary_cat); ?>"><?= $primary_cat->name; ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3 class="post-title">
                            <a title="<?= get_the_title($post); ?>" href="<?= esc_url(get_permalink()); ?>" rel="bookmark"><?= get_the_title($post); ?></a>
                        </h3>
                        <?php if (!empty($post->post_content)): ?>
                            <div class="post-desc"><?= ws_get_content_limit($post->post_content, 100, true); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php wp_reset_query(); ?>
        </div>
    </div>
    <script>
        (function($) {
            jQuery(`#related-posts-carousel`).owlCarousel({
                items: 4,
                margin: 15,
                rtl: <?= (int) is_rtl(); ?>,
                lazyLoad: 1,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 3
                    },
                    1024: {
                        items: 4,
                    },
                    1440: {
                        items: 4
                    }
                },
                nav: 1,
                navContainer: '#related-posts-custom-nav',
                navText: [
                    '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
                    '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
                ],
                dots: 0,
                autoplay: 1,
                autoplayTimeout: 10000,
            });
        })(jQuery);
    </script>
<?php endif;
