<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}
?>

<div class="product-footer">
    <div class="product-price">
        <?php if ($price_html = $product->get_price_html()) : ?>
            <span class="price"><?php echo $price_html; ?></span>
        <?php endif; ?>
    </div>

    <div class="product-cartButton">
        <?php if ($settings['show_cart_button'] == 'yes'): ?>
            <?php if ($product->is_purchasable() && $product->is_in_stock()) : ?>
                <a href="<?= esc_url($product->add_to_cart_url()); ?>" data-quantity="1" data-product_id="<?= $product->get_id(); ?>" class="button add_to_cart_button ajax_add_to_cart" aria-label="<?= __('Add to cart', 'webafra-store'); ?>">
                    <i class="cart-icon fa-light fa-cart-plus"></i>
                    <i class="added-icon fa-light fa-cart-circle-check"></i>
                </a>
            <?php else : ?>
                <span></span>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>