<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="post-loop" id="post-<?php the_ID(); ?>">
    <div class="floating-read-more">
        <a href="<?= esc_url(get_permalink()); ?>" title="<?= get_the_title(); ?>">
            <i class="fa-light fa-file-lines"></i>
            <span><?= __('Read more', 'webafra-store'); ?></span>
        </a>
    </div>
    <div class="post-thumbnail">
        <div class="thumbnail-img">
            <?php
            $thumbnail_src = ws_get_thumbnail_placeholder();
            if ($thumbnail_id = get_post_thumbnail_id()) {
                if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, 'medium_large')) {
                    $thumbnail_src = $thumbnail_image[0];
                }
            }
            ?>
            <a href="<?= esc_url(get_permalink($post)); ?>" title="<?= get_the_title(); ?>">
                <img <?= ws_image_lazy_load_attr(); ?> src="<?= $thumbnail_src; ?>" alt="<?= get_the_title(); ?>" />
            </a>
        </div>

        <div class="post-date">
            <div class="post-date-day"><?= get_the_date('d'); ?></div>
            <div class="post-date-month"><?= get_the_date('F'); ?></div>
        </div>

        <?php if ($primary_cat = ws_get_post_primary_cat(get_the_ID())): ?>
            <div class="post-cat">
                <a title="<?= $primary_cat->name; ?>" href="<?= get_term_link($primary_cat); ?>"><?= $primary_cat->name; ?></a>
            </div>
        <?php endif; ?>
    </div>
    <div class="post-content">
        <h3 class="post-title">
            <a title="<?= get_the_title(); ?>" href="<?= esc_url(get_permalink()); ?>" rel="bookmark"><?= get_the_title(); ?></a>
        </h3>
        <?php if (!empty($post->post_content)): ?>
            <div class="post-desc"><?= ws_get_content_limit($post->post_content, 100, true); ?></div>
        <?php endif; ?>
    </div>
</div>