<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="container">
    <header class="header header-two">
        <div class="header-center">
            <div class="header-cols">
                <div class="header-col-right">
                    <?php if ($custom_logo_id = get_theme_mod('custom_logo')): ?>
                        <?php if ($custom_logo = wp_get_attachment_image_src($custom_logo_id, 'medium_large')): ?>
                            <a class="header-logo" href="<?= home_url(); ?>" title="<?= get_bloginfo('name'); ?>">
                                <img <?= ws_image_lazy_load_attr(); ?> width="<?= $custom_logo[1]; ?>" height="<?= $custom_logo[2]; ?>" src="<?= $custom_logo[0]; ?>" alt="<?= get_bloginfo('name'); ?>" />
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <nav class="mega-menu" id="header-two-megamenu">
                        <button class="mega-menu-button">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                                <path stroke="#2E353C" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5" d="M14.167 8.333h1.666c1.667 0 2.5-.833 2.5-2.5V4.167c0-1.667-.833-2.5-2.5-2.5h-1.666c-1.667 0-2.5.833-2.5 2.5v1.666c0 1.667.833 2.5 2.5 2.5zM4.167 18.333h1.666c1.667 0 2.5-.833 2.5-2.5v-1.666c0-1.667-.833-2.5-2.5-2.5H4.167c-1.667 0-2.5.833-2.5 2.5v1.666c0 1.667.833 2.5 2.5 2.5zM5 8.333a3.333 3.333 0 100-6.666 3.333 3.333 0 000 6.666zM15 18.333a3.333 3.333 0 100-6.666 3.333 3.333 0 000 6.666z"></path>
                            </svg>
                            <span>دسته‌بندی</span>
                            <i class="fa-solid fa-angle-down"></i>
                        </button>

                        <div class="mega-menu-dropdown">
                            <ul class="main-category-tabs">
                                <?php $megamenu_categories = ws_get_megamenu_categories(); ?>
                                <?php if (!empty($megamenu_categories)): ?>
                                    <?php foreach ($megamenu_categories as $term_key => $term): ?>
                                        <li <?= $term_key == 0 ? 'class="active"' : ''; ?> id="term-id-<?= $term->term_id; ?>"><?= $term->name; ?></li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                            <div class="main-category-contents">
                                <?php if (!empty($megamenu_categories)): ?>
                                    <?php foreach ($megamenu_categories as $term_key => $term): ?>
                                        <div class="main-category-content<?= $term_key == 0 ? ' active' : ''; ?>" id="term-id-<?= $term->term_id; ?>">
                                            <?php if (!empty(ws_get_product_categories_by_parent($term->term_id))): ?>
                                                <?php foreach (ws_get_product_categories_by_parent($term->term_id) as $term_child): ?>
                                                    <a href="<?= esc_url(get_term_link($term_child)); ?>" title="<?= $term_child->name; ?>">
                                                        <div class="category-thumbnail"><img src="<?= ws_get_term_thumbnail_src($term_child->term_id); ?>" alt="<?= $term_child->name; ?>" /></div>
                                                        <div class="category-details">
                                                            <h3 class="category-title"><?= $term_child->name; ?></h3>
                                                        </div>
                                                    </a>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </nav>
                    <script>
                        jQuery(document).ready(function($) {
                            megamenu_init('header-two-megamenu');
                            megamenu_responsive('header-two-megamenu');
                        });
                    </script>
                </div>
                <div class="header-col-left">
                    <div class="col-left-right">
                        <div class="search-wrapper desktop">
                            <?php if (get_theme_mod('header-search-form', 'theme') == 'theme'): ?>
                                <form role="search" method="get" action="<?= get_bloginfo('url'); ?>" class="header-search">
                                    <input type="search" placeholder="<?php echo _e('Search...', 'webafra-store'); ?>" aria-label="Search" name="s" id="s" />
                                </form>
                            <?php elseif (get_theme_mod('header-search-form', 'theme') == 'shortcode'): ?>
                                <?php if (!empty(get_theme_mod('header-search-form-shortcode', ''))): ?>
                                    <?= do_shortcode(get_theme_mod('header-search-form-shortcode', '')); ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="search-wrapper mobile" id="mobile-nav-toggle" onclick="mobileNavToggle();">
                            <form role="search" method="get" action="<?= get_bloginfo('url'); ?>" class="header-search">
                                <input type="search" placeholder="<?php echo _e('Search...', 'webafra-store'); ?>" aria-label="Search" name="s" id="s" />
                            </form>
                        </div>
                    </div>
                    <div class="col-left-left">
                        <ul>
                            <?php if (is_user_logged_in()): global $current_user; ?>
                                <li class="my-account">
                                    <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                                        <a href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>">
                                            <?php if ($current_user_avatar = get_avatar($current_user->user_email, 32)): ?>
                                                <?php if (get_option('avatar_default', 'mystery') == 'blank'): ?>
                                                    <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                                                <?php else: ?>
                                                    <?= $current_user_avatar; ?>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                                            <?php endif; ?>
                                            <span class="user-displayName"><?= $current_user->display_name; ?></span>
                                            <i class="fal fa-chevron-down" aria-hidden="true"></i>
                                        </a>
                                        <ul class="my-account-dropdown">
                                            <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
                                                <li>
                                                    <a title="<?= esc_html($label); ?>" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>">
                                                        <?php if ($endpoint == 'dashboard') : ?>
                                                            <i class="fa-light fa-gauge"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'orders') : ?>
                                                            <i class="fa-light fa-bags-shopping"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'downloads') : ?>
                                                            <i class="fa-light fa-download"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'edit-address') : ?>
                                                            <i class="fa-light fa-map-location"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'edit-account') : ?>
                                                            <i class="fa-light fa-user-pen"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'wishlist') : ?>
                                                            <i class="fa-light fa-heart"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'tracking') : ?>
                                                            <i class="fa-light fa-truck-fast"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'customer-logout') : ?>
                                                            <i class="fa-light fa-power-off"></i>
                                                        <?php endif; ?>

                                                        <span><?php echo esc_html($label); ?></span>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                                <li class="my-account-mobile" id="my-account-mobile-toggle">
                                    <a href="javascript:void(0);" onclick="sideUserInfoToggle();">
                                        <i class="fa-light fa-user-large"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <a class="login-button" href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>">
                                    <button title="<?= __('Login', 'webafra-store'); ?> | <?= __('Register', 'webafra-store'); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                            <path fill="#033531" d="M15 3.75c.958 0 1.35.002 1.665.052a4.25 4.25 0 013.533 3.533c.05.316.052.707.052 1.665v6c0 .958-.002 1.35-.052 1.665a4.25 4.25 0 01-3.533 3.533c-.316.05-.707.052-1.665.052h-1c-.958 0-1.84-.316-2.55-.85a.75.75 0 00-.9 1.2A5.728 5.728 0 0014 21.75h1.08c.853 0 1.372 0 1.82-.07a5.75 5.75 0 004.78-4.78c.07-.448.07-.967.07-1.82V8.92c0-.853 0-1.372-.07-1.82a5.75 5.75 0 00-4.78-4.78c-.448-.07-.967-.07-1.82-.07H14c-1.294 0-2.49.428-3.45 1.15a.75.75 0 00.9 1.2A4.228 4.228 0 0114 3.75h1z"></path>
                                            <path fill="#033531" d="M13.466 7.412a.75.75 0 00-.932 1.176l1.763 1.398c.704.558 1.186.941 1.513 1.264H3a.75.75 0 000 1.5h12.81c-.327.323-.809.706-1.513 1.264l-1.763 1.398a.75.75 0 00.932 1.176l1.799-1.427c.672-.533 1.227-.973 1.622-1.367.406-.404.742-.852.834-1.425a2.349 2.349 0 000-.738c-.092-.573-.428-1.021-.834-1.425-.395-.394-.95-.834-1.622-1.367l-1.799-1.427z"></path>
                                        </svg>
                                        <span><?= __('Login', 'webafra-store'); ?> | <?= __('Register', 'webafra-store'); ?></span>
                                    </button>
                                </a>
                            <?php endif; ?>
                        </ul>

                        <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                            <div class="mini-cart">
                                <button title="<?= __('Cart', 'webafra-store'); ?>" id="mini-cart-toggle" onclick="sideCartToggle();">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <path fill="#033531" d="M18.19 17.75H7.54c-.99 0-1.94-.42-2.61-1.15A3.573 3.573 0 014 13.9l.83-9.96c.03-.31-.08-.61-.29-.84-.21-.23-.5-.35-.81-.35H2c-.41 0-.75-.34-.75-.75s.34-.75.75-.75h1.74c.73 0 1.42.31 1.91.84.27.3.47.65.58 1.04h12.49c1.01 0 1.94.4 2.62 1.12.67.73 1.01 1.68.93 2.69l-.54 7.5c-.11 1.83-1.71 3.31-3.54 3.31zM6.28 4.62l-.78 9.4c-.05.58.14 1.13.53 1.56.39.43.93.66 1.51.66h10.65c1.04 0 1.98-.88 2.06-1.92l.54-7.5a2.04 2.04 0 00-2.06-2.21H6.28v.01zM16.25 22.75c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm0-2.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM8.25 22.75c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm0-2.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z"></path>
                                        <path fill="#033531" d="M21 8.75H9c-.41 0-.75-.34-.75-.75s.34-.75.75-.75h12c.41 0 .75.34.75.75s-.34.75-.75.75z"></path>
                                    </svg>
                                    <span class="cart-text"><?= __('Cart', 'webafra-store'); ?></span>
                                    <span class="cart-countBadge cart-countBadge-selector"><?= WC()->cart->get_cart_contents_count(); ?></span>
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
</div>