<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="primary-menu-wrapper<?= get_theme_mod('header-nav-menu-full-width', 1) ? ' full-width' : ''; ?><?= get_theme_mod('header-nav-sticky', 1) ? ' sticky-nav' : ''; ?>">
    <div class="container">
        <nav class="primary-menu<?= is_front_page() ? ' px' : ''; ?>">
            <?= wp_nav_menu([
                'theme_location' => 'header-primary',
                'container' => '',
                'echo' => 1,
                'walker' => new MegaMenu_NavWalker
            ]); ?>

            <div class="mobile-nav" id="mobile-nav-toggle" onclick="mobileNavToggle();">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="3" y1="12" x2="21" y2="12"></line>
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <line x1="3" y1="18" x2="21" y2="18"></line>
                </svg>
            </div>

            <ul class="primary-menu-links">
                <?php $header_nav_menu_phone_numbers = get_theme_mod('header-nav-menu-phone-numbers', '02188814075-7'); ?>
                <?php if (!empty($header_nav_menu_phone_numbers)): ?>
                    <li class="phone-numbers">
                        <a title="<?= __('Phone numbers', 'webafra-store'); ?>" href="tel:<?= $header_nav_menu_phone_numbers; ?>">
                            <?= $header_nav_menu_phone_numbers; ?>
                            <i class="fa-light fa-phone"></i>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (get_theme_mod('header-nav-menu-show-tracking-btn', 0) == '1' && in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                    <li class="tracking">
                        <a title="<?= __('Tracking', 'webafra-store'); ?>" href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>tracking">
                            <i class="fa-light fa-truck-fast"></i>
                            <?= __('Order tracking', 'webafra-store'); ?>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (function_exists('wccm_get_compare_list')): ?>
                    <li class="compare">
                        <a title="<?= __('Compare', 'webafra-store'); ?>" href="<?= !empty(get_option('wccm_compare_page')) ? get_permalink(get_option('wccm_compare_page')) : ''; ?>">
                            <i class="fal fa-random" aria-hidden="true"></i>
                            <span class="cart-countBadge compare-badge-selector"><?= count(wccm_get_compare_list()); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (in_array('ti-woocommerce-wishlist/ti-woocommerce-wishlist.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                    <li class="wishlist">
                        <a title="<?= __('Wishlist', 'webafra-store'); ?>" href="<?= get_site_url(); ?>/wishlist">
                            <i class="fa-light fa-heart"></i>
                            <span class="cart-countBadge wishlist_products_counter"><span class="wishlist_products_counter_number">0</span></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                    <li class="cart">
                        <button title="<?= __('Cart', 'webafra-store'); ?>" id="mini-cart-toggle" onclick="sideCartToggle();">
                            <i class="fa-light fa-bag-shopping"></i>
                            <span class="cart-countBadge cart-countBadge-selector"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                        </button>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</div>
<div class="overlay-blur"></div>