<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="container">
    <header class="header">
        <div class="header-center">
            <div class="header-cols">
                <div class="header-col-right">
                    <?php if ($custom_logo_id = get_theme_mod('custom_logo')): ?>
                        <?php if ($custom_logo = wp_get_attachment_image_src($custom_logo_id, 'medium_large')): ?>
                            <a class="header-logo" href="<?= home_url(); ?>" title="<?= get_bloginfo('name'); ?>">
                                <img <?= ws_image_lazy_load_attr(); ?> width="<?= $custom_logo[1]; ?>" height="<?= $custom_logo[2]; ?>" src="<?= $custom_logo[0]; ?>" alt="<?= get_bloginfo('name'); ?>" />
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="header-col-left">
                    <div class="col-left-right">
                        <div class="search-wrapper">
                            <?php if (get_theme_mod('header-search-form', 'theme') == 'theme'): ?>
                                <form role="search" method="get" action="<?= get_bloginfo('url'); ?>" class="header-search">
                                    <input type="search" placeholder="<?php echo _e('Search...', 'webafra-store'); ?>" aria-label="Search" name="s" id="s" />
                                </form>
                            <?php elseif (get_theme_mod('header-search-form', 'theme') == 'shortcode'): ?>
                                <?php if (!empty(get_theme_mod('header-search-form-shortcode', ''))): ?>
                                    <?= do_shortcode(get_theme_mod('header-search-form-shortcode', '')); ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-left-left">
                        <ul>
                            <?php if (is_user_logged_in()): global $current_user; ?>
                                <li class="my-account">
                                    <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                                        <a href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>">
                                            <?php if ($current_user_avatar = get_avatar($current_user->user_email, 32)): ?>
                                                <?php if (get_option('avatar_default', 'mystery') == 'blank'): ?>
                                                    <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                                                <?php else: ?>
                                                    <?= $current_user_avatar; ?>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                                            <?php endif; ?>
                                            <span class="user-displayName"><?= $current_user->display_name; ?></span>
                                            <i class="fal fa-chevron-down" aria-hidden="true"></i>
                                        </a>
                                        <ul class="my-account-dropdown">
                                            <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
                                                <li>
                                                    <a title="<?= esc_html($label); ?>" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>">
                                                        <?php if ($endpoint == 'dashboard') : ?>
                                                            <i class="fa-light fa-gauge"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'orders') : ?>
                                                            <i class="fa-light fa-bags-shopping"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'downloads') : ?>
                                                            <i class="fa-light fa-download"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'edit-address') : ?>
                                                            <i class="fa-light fa-map-location"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'edit-account') : ?>
                                                            <i class="fa-light fa-user-pen"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'wishlist') : ?>
                                                            <i class="fa-light fa-heart"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'tracking') : ?>
                                                            <i class="fa-light fa-truck-fast"></i>
                                                        <?php endif; ?>

                                                        <?php if ($endpoint == 'customer-logout') : ?>
                                                            <i class="fa-light fa-power-off"></i>
                                                        <?php endif; ?>

                                                        <span><?php echo esc_html($label); ?></span>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                                <li class="my-account-mobile" id="my-account-mobile-toggle">
                                    <a href="javascript:void(0);" onclick="sideUserInfoToggle();">
                                        <i class="fa-light fa-user-large"></i>
                                    </a>
                                </li>
                            <?php else: ?>

                                <li class="user-account login">
                                    <button id="side-login-toggle" title="<?= __('Login', 'webafra-store'); ?>" onclick="sideLoginToggle();">
                                        <i class="fa-light fa-user"></i>
                                        <span><?= __('Login', 'webafra-store'); ?></span>
                                    </button>
                                </li>
                                <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                                    <?php if (get_option('users_can_register') == 1): ?>
                                        <li class="user-account register">
                                            <a title="<?= __('Register', 'webafra-store'); ?>" href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>">
                                                <i class="fa-light fa-user-plus"></i>
                                                <span><?= __('Register', 'webafra-store'); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </header>
</div>