<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<?php if (get_theme_mod('enable-mobile-megamenu', 0)): ?>
    <div class="mobile-megamenu" id="mobile-megamenu">
        <?php
        $megamenu_query = [
            'taxonomy' => 'product_cat',
            'hide_empty' => 0,
            'number' => 0,
            'parent' => 0,
        ];

        $megamenu_parents = new WP_Term_Query($megamenu_query);
        ?>
        <nav class="mega-menu-footer" id="ws-mega-menu-footer">
            <div class="mega-menu-dropdown">
                <ul class="main-category-tabs">
                    <?php if (!empty($megamenu_parents->get_terms())): ?>
                        <?php foreach ($megamenu_parents->get_terms() as $term_key => $term): ?>
                            <li <?= $term_key == 0 ? 'class="active"' : ''; ?> id="term-id-<?= $term->term_id; ?>"><?= $term->name; ?></li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
                <div class="main-category-contents">
                    <?php if (!empty($megamenu_parents->get_terms())): ?>
                        <?php foreach ($megamenu_parents->get_terms() as $term_key => $term): ?>
                            <div class="main-category-content<?= $term_key == 0 ? ' active' : ''; ?>" id="term-id-<?= $term->term_id; ?>">
                                <?php
                                $query = [
                                    'taxonomy' => 'product_cat',
                                    'hide_empty' => 0,
                                    'number' => 0,
                                    'parent' => $term->term_id,
                                ];

                                $children = new WP_Term_Query($query);
                                ?>
                                <?php if (!empty($children->get_terms())): ?>
                                    <?php foreach ($children->get_terms() as $term_child): ?>
                                        <a href="<?= esc_url(get_term_link($term_child)); ?>" title="<?= $term_child->name; ?>">
                                            <?php
                                            $thumbnail_src = ws_get_thumbnail_placeholder();
                                            if ($thumbnail_id = get_term_meta($term_child->term_id, 'thumbnail_id', true)) {
                                                if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, 'woocommerce_thumbnail')) {
                                                    $thumbnail_src = $thumbnail_image[0];
                                                }
                                            }
                                            ?>
                                            <div class="category-thumbnail"><img src="<?= $thumbnail_src; ?>" alt="<?= $term_child->name; ?>" /></div>
                                            <div class="category-details">
                                                <h3 class="category-title"><?= $term_child->name; ?></h3>
                                            </div>
                                        </a>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <script>
                        jQuery(document).ready(function($) {
                            megamenu_init('ws-mega-menu-footer');
                        });
                    </script>
                </div>
            </div>
        </nav>
    </div>
<?php endif; ?>

<?php if (!is_user_logged_in()): ?>
    <div class="side-dialog side-login" id="side-login">
        <div class="dialog-head">
            <button class="dialog-close" title="<?= __('Close', 'webafra-store'); ?>" aria-label="<?= __('Close', 'webafra-store'); ?>" data-title="<?= __('Close', 'webafra-store'); ?>" rel="nofollow" onclick="sideLoginToggle();">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
            <div class="dialog-title">
                <i class="fal fa-user-circle" aria-hidden="true"></i>
                <span><?= __('Login into account', 'webafra-store'); ?></span>
            </div>
        </div>
        <div class="dialog-login-form-con">
            <form method="post" action="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>" class="wc-auth-login">
                <p class="form-row form-row-wide">
                    <label for="username-dialog"><?php esc_html_e('Username or email address', 'woocommerce'); ?>&nbsp;<span class="required" aria-hidden="true">*</span><span class="screen-reader-text"><?php esc_html_e('Required', 'woocommerce'); ?></span></label>
                    <input type="text" class="input-text" name="username-dialog" id="username-dialog" value="<?php echo (! empty($_POST['username'])) ? esc_attr($_POST['username']) : ''; ?>" required aria-required="true" /><?php //@codingStandardsIgnoreLine 
                                                                                                                                                                                                                                ?>
                </p>
                <p class="form-row form-row-wide">
                    <label for="password-dialog"><?php esc_html_e('Password', 'woocommerce'); ?>&nbsp;<span class="required" aria-hidden="true">*</span><span class="screen-reader-text"><?php esc_html_e('Required', 'woocommerce'); ?></span></label>
                    <input class="input-text" type="password" name="password-dialog" id="password-dialog" required aria-required="true" />
                </p>
                <p class="wc-auth-actions">
                    <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
                    <button type="submit" class="button button-large button-primary wc-auth-login-button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="login" value="<?php esc_attr_e('Login', 'woocommerce'); ?>"><?php esc_html_e('Login', 'woocommerce'); ?></button>
                </p>
            </form>
        </div>
    </div>
<?php else: global $current_user; ?>
    <div class="side-dialog side-user-info" id="side-user-info">
        <div class="dialog-head">
            <button class="dialog-close" title="<?= __('Close', 'webafra-store'); ?>" aria-label="<?= __('Close', 'webafra-store'); ?>" data-title="<?= __('Close', 'webafra-store'); ?>" rel="nofollow" onclick="sideUserInfoToggle();">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        </div>
        <div class="dialog-user-info-con">
            <div class="user-avatar">
                <?php if ($current_user_avatar = get_avatar($current_user->user_email, 32)): ?>
                    <?php if (get_option('avatar_default', 'mystery') == 'blank'): ?>
                        <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                    <?php else: ?>
                        <?= $current_user_avatar; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <img <?= ws_image_lazy_load_attr(); ?> width="32" height="32" alt="<?= $current_user->display_name; ?>" src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                <?php endif; ?>
            </div>
            <div class="user-displayName"><?= $current_user->display_name; ?></div>
            <?php if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                <ul class="my-account-list">
                    <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
                        <li>
                            <a title="<?= esc_html($label); ?>" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>">
                                <?php if ($endpoint == 'dashboard') : ?>
                                    <i class="fa-light fa-gauge"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'orders') : ?>
                                    <i class="fa-light fa-bags-shopping"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'downloads') : ?>
                                    <i class="fa-light fa-download"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'edit-address') : ?>
                                    <i class="fa-light fa-map-location"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'edit-account') : ?>
                                    <i class="fa-light fa-user-pen"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'wishlist') : ?>
                                    <i class="fa-light fa-heart"></i>
                                <?php endif; ?>

                                <?php if ($endpoint == 'customer-logout') : ?>
                                    <i class="fa-light fa-power-off"></i>
                                <?php endif; ?>

                                <span><?php echo esc_html($label); ?></span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php if (class_exists('WooCommerce')): ?>
    <div class="side-dialog side-cart" id="side-cart">
        <div class="dialog-head">
            <button class="dialog-close" title="<?= __('Close', 'webafra-store'); ?>" aria-label="<?= __('Close', 'webafra-store'); ?>" data-title="<?= __('Close', 'webafra-store'); ?>" rel="nofollow" onclick="sideCartToggle();">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
            <div class="dialog-title">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 2L3 6v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2V6l-3-4H6zM3.8 6h16.4M16 10a4 4 0 1 1-8 0" />
                </svg>
                <span><?= __('Cart', 'webafra-store'); ?></span>
            </div>
        </div>
        <div class="mini-cart">
            <div class="widget_shopping_cart_content">
                <?php woocommerce_mini_cart(); ?>
            </div>
        </div>
        <i class="fal fa-bags-shopping side-icon" aria-hidden="true"></i>
    </div>
<?php endif; ?>

<div class="side-dialog side-primaryMenu" id="side-primaryMenu">
    <div class="dialog-head">
        <button class="dialog-close" title="<?= __('Close', 'webafra-store'); ?>" aria-label="<?= __('Close', 'webafra-store'); ?>" data-title="<?= __('Close', 'webafra-store'); ?>" rel="nofollow" onclick="mobileNavToggle();">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <line x1="18" y1="6" x2="6" y2="18"></line>
                <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
        </button>
    </div>

    <div class="side-primaryMenuContent">
        <div class="content-search">
            <?php if (get_theme_mod('sidemenu-search-form', 'theme') == 'theme'): ?>
                <form role="search" method="get" action="<?= get_bloginfo('url'); ?>" class="header-search">
                    <input type="search" class="search-input" placeholder="<?php echo _e('Search...', 'webafra-store'); ?>" aria-label="Search" name="s" id="s" />
                </form>
            <?php elseif (get_theme_mod('sidemenu-search-form', 'theme') == 'shortcode'): ?>
                <?php if (!empty(get_theme_mod('sidemenu-search-form-shortcode', ''))): ?>
                    <?= do_shortcode(get_theme_mod('sidemenu-search-form-shortcode', '')); ?>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="overlay1" id="overlay1"></div>
<div class="overlay1" id="overlay2"></div>
<div class="overlay1" id="overlay4"></div>
<div class="overlay1" id="overlay5"></div>

<?php if (get_theme_mod('footer-mobile', 1)): ?>
    <div class="mobile-footer">
        <ul>
            <li class="home">
                <a title="<?= __('Home', 'webafra-store'); ?>" href="<?= get_home_url(); ?>">
                    <div class="item-icon">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 18.75C11.59 18.75 11.25 18.41 11.25 18V15C11.25 14.59 11.59 14.25 12 14.25C12.41 14.25 12.75 14.59 12.75 15V18C12.75 18.41 12.41 18.75 12 18.75Z" fill="#CBCBCB"></path>
                            <path d="M17.6009 22.5601H6.40094C4.58094 22.5601 2.92094 21.1601 2.62094 19.3701L1.29094 11.4001C1.07094 10.1601 1.68094 8.57007 2.67094 7.78007L9.60094 2.23007C10.9409 1.15007 13.0509 1.16007 14.4009 2.24007L21.3309 7.78007C22.3109 8.57007 22.9109 10.1601 22.7109 11.4001L21.3809 19.3601C21.0809 21.1301 19.3809 22.5601 17.6009 22.5601ZM11.9909 2.93007C11.4609 2.93007 10.9309 3.09007 10.5409 3.40007L3.61094 8.96007C3.05094 9.41007 2.65094 10.4501 2.77094 11.1601L4.10094 19.1201C4.28094 20.1701 5.33094 21.0601 6.40094 21.0601H17.6009C18.6709 21.0601 19.7209 20.1701 19.9009 19.1101L21.2309 11.1501C21.3409 10.4501 20.9409 9.39007 20.3909 8.95007L13.4609 3.41007C13.0609 3.09007 12.5209 2.93007 11.9909 2.93007Z" fill="#CBCBCB"></path>
                        </svg>
                    </div>
                    <div class="item-text"><?= __('Home', 'webafra-store'); ?></div>
                </a>
            </li>

            <?php if (get_theme_mod('enable-mobile-megamenu', 0)): ?>
                <li>
                    <button href="javascript:void(0);" onclick="openMobileMegaMenu();">
                        <div class="item-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14 5H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M14 8H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M21 11.5C21 16.75 16.75 21 11.5 21C6.25 21 2 16.75 2 11.5C2 6.25 6.25 2 11.5 2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M22 22L20 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </div>
                        <div class="item-text"><?= __('Categories', 'webafra-store'); ?></div>
                    </button>
                </li>
            <?php else: ?>
                <?php if (class_exists('WooCommerce') && (is_shop() || is_product_taxonomy())): ?>
                    <li id="shop-sideBarToggle">
                        <a href="javascript:void(0);" onclick="shopSideBarToggle();">
                            <div class="item-icon">
                                <i class="fa-light fa-filter"></i>
                            </div>
                            <div class="item-text"><?= __('Filters', 'webafra-store'); ?></div>
                        </a>
                    </li>
                <?php else: ?>
                    <li>
                        <button href="javascript:void(0);" onclick="scrollToTop();">
                            <div class="item-icon">
                                <i class="fa-light fa-arrow-up"></i>
                            </div>
                            <div class="item-text"><?= __('Go to Top', 'webafra-store'); ?></div>
                        </button>
                    </li>
                <?php endif; ?>
            <?php endif; ?>

            <li class="cart">
                <a title="<?= __('Cart', 'webafra-store'); ?>" href="<?= get_home_url(); ?>/cart">
                    <div class="item-icon">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.25 22.5C17.2165 22.5 18 21.7165 18 20.75C18 19.7835 17.2165 19 16.25 19C15.2835 19 14.5 19.7835 14.5 20.75C14.5 21.7165 15.2835 22.5 16.25 22.5Z" fill="white"></path>
                            <path d="M8.25 22.5C9.2165 22.5 10 21.7165 10 20.75C10 19.7835 9.2165 19 8.25 19C7.2835 19 6.5 19.7835 6.5 20.75C6.5 21.7165 7.2835 22.5 8.25 22.5Z" fill="white"></path>
                            <path d="M4.84 3.94L4.64 6.39C4.6 6.86 4.97 7.25 5.44 7.25H20.75C21.17 7.25 21.52 6.93 21.55 6.51C21.68 4.74 20.33 3.3 18.56 3.3H6.27C6.17 2.86 5.97 2.44 5.66 2.09C5.16 1.56 4.46 1.25 3.74 1.25H2C1.59 1.25 1.25 1.59 1.25 2C1.25 2.41 1.59 2.75 2 2.75H3.74C4.05 2.75 4.34 2.88 4.55 3.1C4.76 3.33 4.86 3.63 4.84 3.94Z" fill="white"></path>
                            <path d="M20.5101 8.75H5.17005C4.75005 8.75 4.41005 9.07 4.37005 9.48L4.01005 13.83C3.87005 15.54 5.21005 17 6.92005 17H18.0401C19.5401 17 20.8601 15.77 20.9701 14.27L21.3001 9.6C21.3401 9.14 20.9801 8.75 20.5101 8.75Z" fill="white"></path>
                        </svg>
                    </div>
                    <div class="item-text"><?= __('Cart', 'webafra-store'); ?></div>
                </a>
            </li>

            <li class="account">
                <?php if (!get_current_user_id()): ?>
                    <a title="<?= __('Login', 'webafra-store'); ?>" href="<?= get_home_url(); ?>/my-account">
                        <div class="item-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="white" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 3.75001C15.9577 3.75001 16.3492 3.75234 16.6648 3.80233C18.4834 4.09036 19.9096 5.51662 20.1977 7.33516C20.2477 7.65083 20.25 8.04234 20.25 9.00001V15C20.25 15.9577 20.2477 16.3492 20.1977 16.6649C19.9096 18.4834 18.4834 19.9097 16.6648 20.1977C16.3492 20.2477 15.9577 20.25 15 20.25H14C13.0424 20.25 12.1607 19.9342 11.4504 19.4007C11.1192 19.1519 10.6491 19.2188 10.4003 19.5499C10.1516 19.8811 10.2184 20.3513 10.5496 20.6C11.5106 21.3219 12.7064 21.75 14 21.75L15.0809 21.75C15.9329 21.7501 16.4518 21.7501 16.8995 21.6792C19.3599 21.2895 21.2895 19.3599 21.6792 16.8995C21.7501 16.4518 21.7501 15.9328 21.75 15.0808V8.91921C21.7501 8.06718 21.7501 7.54819 21.6792 7.10051C21.2895 4.64013 19.3599 2.71049 16.8995 2.3208C16.4518 2.2499 15.9329 2.24994 15.0809 2.25L14 2.25001C12.7064 2.25001 11.5106 2.67807 10.5496 3.39997C10.2184 3.64874 10.1516 4.11889 10.4003 4.45008C10.6491 4.78127 11.1192 4.84808 11.4504 4.59932C12.1607 4.06583 13.0424 3.75001 14 3.75001H15Z" fill="#CBCBCB"></path>
                                <path d="M13.466 7.41233C13.1414 7.15498 12.6697 7.20947 12.4123 7.53404C12.155 7.85861 12.2095 8.33034 12.534 8.58769L14.297 9.98554C15.001 10.5438 15.483 10.9274 15.8105 11.25L3 11.25C2.58579 11.25 2.25 11.5858 2.25 12C2.25 12.4142 2.58579 12.75 3 12.75L15.8105 12.75C15.483 13.0727 15.001 13.4563 14.297 14.0145L12.534 15.4123C12.2095 15.6697 12.155 16.1414 12.4123 16.466C12.6697 16.7905 13.1414 16.845 13.466 16.5877L15.2648 15.1614C15.9373 14.6283 16.4922 14.1883 16.8875 13.7945C17.2932 13.3904 17.6294 12.9419 17.7208 12.3687C17.7402 12.2466 17.75 12.1234 17.75 12C17.75 11.8766 17.7402 11.7534 17.7208 11.6313C17.6294 11.0582 17.2932 10.6096 16.8875 10.2055C16.4922 9.81173 15.9373 9.37176 15.2648 8.83858L13.466 7.41233Z" fill="#CBCBCB"></path>
                            </svg>
                        </div>
                        <div class="item-text"><?= __('Login', 'webafra-store'); ?></div>
                    </a>
                <?php else: ?>
                    <a title="<?= __('Profile', 'webafra-store'); ?>" href="<?= get_home_url(); ?>/my-account">
                        <div class="item-icon">
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 12.75C8.83 12.75 6.25 10.17 6.25 7C6.25 3.83 8.83 1.25 12 1.25C15.17 1.25 17.75 3.83 17.75 7C17.75 10.17 15.17 12.75 12 12.75ZM12 2.75C9.66 2.75 7.75 4.66 7.75 7C7.75 9.34 9.66 11.25 12 11.25C14.34 11.25 16.25 9.34 16.25 7C16.25 4.66 14.34 2.75 12 2.75Z" fill="#CBCBCB"></path>
                                <path d="M20.5901 22.75C20.1801 22.75 19.8401 22.41 19.8401 22C19.8401 18.55 16.3202 15.75 12.0002 15.75C7.68015 15.75 4.16016 18.55 4.16016 22C4.16016 22.41 3.82016 22.75 3.41016 22.75C3.00016 22.75 2.66016 22.41 2.66016 22C2.66016 17.73 6.85015 14.25 12.0002 14.25C17.1502 14.25 21.3401 17.73 21.3401 22C21.3401 22.41 21.0001 22.75 20.5901 22.75Z" fill="#CBCBCB"></path>
                            </svg>
                        </div>
                        <div class="item-text"><?= __('Profile', 'webafra-store'); ?></div>
                    </a>
                <?php endif; ?>
            </li>
        </ul>
    </div>
<?php endif; ?>

<?php if ($footer_script = get_theme_mod('footer-script', '')): ?>
    <?= $footer_script; ?>
<?php endif; ?>

<?php if (get_theme_mod('enable-site-loading', 1)): ?>
    <script>
        jQuery(window).load(function() {
            jQuery('#site-loading').fadeOut(500);
        });
    </script>
<?php endif; ?>