<?php if (get_theme_mod('footer-mobile', 1)): ?>
    <div class="mobile-footer">
        <ul>
            <?php if (get_theme_mod('enable-mobile-megamenu', 0)): ?>
                <li>
                    <button href="javascript:void(0);" onclick="openMobileMegaMenu();">
                        <div class="item-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14 5H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M14 8H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M21 11.5C21 16.75 16.75 21 11.5 21C6.25 21 2 16.75 2 11.5C2 6.25 6.25 2 11.5 2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M22 22L20 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </div>
                        <div class="item-text"><?= __('Categories', 'webafra-store'); ?></div>
                    </button>
                </li>
            <?php else: ?>
                <?php if (class_exists('WooCommerce') && (is_shop() || is_product_taxonomy())): ?>
                    <li id="shop-sideBarToggle">
                        <a href="javascript:void(0);" onclick="shopSideBarToggle();">
                            <div class="item-icon">
                                <i class="fa-light fa-filter"></i>
                            </div>
                            <div class="item-text"><?= __('Filters', 'webafra-store'); ?></div>
                        </a>
                    </li>
                <?php else: ?>
                    <li>
                        <button href="javascript:void(0);" onclick="scrollToTop();">
                            <div class="item-icon">
                                <i class="fa-light fa-arrow-up"></i>
                            </div>
                            <div class="item-text"><?= __('Go to Top', 'webafra-store'); ?></div>
                        </button>
                    </li>
                <?php endif; ?>
            <?php endif; ?>

            <?php if (in_array('ti-woocommerce-wishlist/ti-woocommerce-wishlist.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
                <li class="wishlist">
                    <a title="<?= __('Wishlist', 'webafra-store'); ?>" href="<?= get_site_url(); ?>/wishlist">
                        <div class="item-icon">
                            <i class="fa-light fa-heart"></i>
                            <span class="cart-countBadge wishlist_products_counter"><span class="wishlist_products_counter_number">0</span></span>
                        </div>
                        <div class="item-text"><?= __('Wishlist', 'webafra-store'); ?></div>
                    </a>
                </li>
            <?php endif; ?>

            <li class="home">
                <a title="<?= __('Home', 'webafra-store'); ?>" href="<?= get_home_url(); ?>">
                    <div class="item-icon">
                        <i class="fa-light fa-house"></i>
                    </div>
                    <div class="item-text"><?= __('Home', 'webafra-store'); ?></div>
                </a>
            </li>

            <?php if (class_exists('WooCommerce')): ?>
                <?php if (function_exists('wccm_get_compare_list')): ?>
                    <li class="compare">
                        <a title="<?= __('Compare', 'webafra-store'); ?>" href="<?= !empty(get_option('wccm_compare_page')) ? get_permalink(get_option('wccm_compare_page')) : ''; ?>">
                            <div class="item-icon">
                                <i class="fal fa-random" aria-hidden="true"></i>
                                <span class="cart-countBadge compare-badge-selector"><?= count(wccm_get_compare_list()); ?></span>
                            </div>
                            <div class="item-text"><?= __('Compare', 'webafra-store'); ?></div>
                        </a>
                    </li>
                <?php endif; ?>

                <li class="cart">
                    <button title="<?= __('Cart', 'webafra-store'); ?>" id="mini-cart-toggle" onclick="sideCartToggle();">
                        <div class="item-icon">
                            <i class="fa-light fa-bag-shopping"></i>
                            <span class="cart-countBadge cart-countBadge-selector"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                        </div>
                        <div class="item-text"><?= __('Cart', 'webafra-store'); ?></div>
                    </button>
                </li>
            <?php endif; ?>
        </ul>
    </div>
<?php endif; ?>