<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<li id="comment-<?php comment_ID(); ?>" <?php comment_class($this->has_children ? 'parent' : ''); ?>>
    <div class="comment-metadata">
        <?php if (0 != $args['avatar_size']) : ?>
            <div class="metadata-item comment-avatar">
                <a href="<?php echo get_comment_author_url(); ?>">
                    <?php if ($user_avatar = get_avatar($comment, $args['avatar_size'])): ?>
                        <?php if (get_option('avatar_default', 'mystery') == 'blank'): ?>
                            <img alt="<?= get_comment_author($comment); ?>" <?= ws_image_lazy_load_attr(); ?> src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                        <?php else: ?>
                            <?= $user_avatar; ?>
                        <?php endif; ?>
                    <?php else: ?>
                        <img alt="<?= get_comment_author($comment); ?>" <?= ws_image_lazy_load_attr(); ?> src="<?= get_template_directory_uri(); ?>/assets/images/avatar-placeholder.png" />
                    <?php endif; ?>
                </a>
            </div>
        <?php endif; ?>

        <div class="metadata-item comment-author"><?= get_comment_author_link(); ?></div>

        <div class="metadata-item comment-date">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                <line x1="16" y1="2" x2="16" y2="6"></line>
                <line x1="8" y1="2" x2="8" y2="6"></line>
                <line x1="3" y1="10" x2="21" y2="10"></line>
            </svg>
            <a class="datetime" href="<?php echo esc_url(get_comment_link($comment->comment_ID, $args)); ?>">
                <time datetime="<?php comment_time('c'); ?>"><?php printf(_x('%1$s at %2$s', '1: date, 2: time', 'webafra-store'), get_comment_date(), get_comment_time()); ?></time>
            </a>
        </div>
    </div>
    <div class="comment-body">
        <div class="comment-content">
            <?php if ('0' == $comment->comment_approved) : ?>
                <p class="comment-awaiting-moderation label label-info"><?php _e('Your comment is awaiting moderation.', 'webafra-store'); ?></p>
            <?php endif; ?>
            <?php comment_text(); ?>
        </div>
        <ul class="list-inline">
            <?php edit_comment_link(__('Edit', 'webafra-store'), '<li class="edit-link">', '</li>'); ?>
            <?php
            comment_reply_link(array_merge($args, [
                'add_below' => 'comment',
                'depth'     => $depth,
                'max_depth' => $args['max_depth'],
                'before'    => '<li class="reply-link">',
                'after'     => '</li>'
            ]));
            ?>
        </ul>
    </div>
</li>