<?php
if (!defined('ABSPATH')) {
    exit;
}

extract($args);

$brand_thumbnail_src = wc_placeholder_img_src();
if ($brand_thumbnail_id = get_term_meta($brand->term_id, 'product_attribute_image', true)) {
    if ($brand_thumbnail_image = wp_get_attachment_image_src($brand_thumbnail_id, 'woocommerce_thumbnail')) {
        $brand_thumbnail_src = $brand_thumbnail_image[0];
    }
}

?>
<div class="brand-item<?= ($brand->term_id == $current_brand_id) ? ' is-active' : ''; ?>">
    <a title="<?= $brand->name; ?>" href="<?php echo esc_attr(get_term_link($brand, $taxonomy)); ?>">
        <img <?= ws_image_lazy_load_attr(); ?> src="<?= $brand_thumbnail_src; ?>" alt="<?= $brand->name; ?>" class="brand-logo">
        <h3><?= $brand->name; ?></h3>
    </a>
</div>