<?php
if (!defined('ABSPATH') && !is_admin()) {
    exit;
}

extract($args);
?>

<table class="widefat fixed" cellspacing="0">
    <tbody>

        <tr>
            <th scope="col">
                <label for="ws-theme-settings-hidden-title"><?= __('Hidden title', 'webafra-store'); ?></label>
            </th>
            <td>
                <input type="checkbox" id="ws-theme-settings-hidden-title" name="ws-theme-settings-hidden-title" value="1" class="regular-text" <?= (get_post_meta($post->ID, '_ws_theme_settings_hidden_title', true) == '1' ? ' checked' : ''); ?>>
            </td>
        </tr>

        <tr>
            <th scope="col">
                <label for="ws-theme-settings-disable-sidebar"><?= __('Disable sidebar', 'webafra-store'); ?></label>
            </th>
            <td>
                <input type="checkbox" id="ws-theme-settings-disable-sidebar" name="ws-theme-settings-disable-sidebar" value="1" class="regular-text" <?= (get_post_meta($post->ID, ' _ws_theme_settings_disable_sidebar', true) == '1' ? ' checked' : ''); ?>>
            </td>
        </tr>

        <tr>
            <th scope="col">
                <label for="ws-post-schema-form"><?= __('Schema', 'webafra-store'); ?></label>
            </th>
            <td>
                <textarea style="direction:ltr;min-height:100px;width:100%;" id="ws-post-schema-form" name="ws-post-schema-form"><?= get_post_meta($post->ID, '_ws_post_schema', true); ?></textarea>
            </td>
        </tr>

        <tr>
            <th scope="col">
                <label for="ws-post-meta-keywords"><?= __('Meta keywords', 'webafra-store'); ?></label>
            </th>
            <td>
                <textarea style="min-height:100px;width:100%;" id="ws-post-meta-keywords" name="ws-post-meta-keywords"><?= get_post_meta($post->ID, '_ws_post_meta_keywords', true); ?></textarea>
            </td>
        </tr>

        <?php if ($post->post_type == 'product'): ?>
            <?php $woo_product_offerslider_timer = get_post_meta($post->ID, '_woo_product_offerslider_timer', true); ?>
            <tr>
                <th scope="col">
                    <label for="ws-product-offer-finishing-at"><?= __('Offer finishing at', 'webafra-store'); ?></label>
                </th>
                <td>
                    <input data-jdp type="text" id="ws-product-offer-finishing-at" name="ws-product-offer-finishing-at" value="<?= !empty($woo_product_offerslider_timer) ? jdate('Y-m-d', $woo_product_offerslider_timer, '', 'Asia/Tehran', 'en') : ''; ?>" autocomplete="off">
                    <script>
                        jalaliDatepicker.startWatch({
                            zIndex: 999999,
                            separatorChars: {
                                date: '-'
                            }
                        });
                    </script>
                </td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>