<?php get_header(); ?>

<div class="container">
    <div style="margin-top: 20px;">
        <?php ws_theme_breadcrumb(); ?>
    </div>
    <article class="blog-single<?= get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true) ? ' no-sidebar' : ''; ?>">
        <main class="blog-singleMain">
            <?php while (have_posts()): the_post(); ?>
                <div class="post-body">
                    <header class="post-header">
                        <?php $theme_settings_hidden_title = get_post_meta(get_the_ID(), '_ws_theme_settings_hidden_title', true); ?>
                        <?php if (empty($theme_settings_hidden_title) || $theme_settings_hidden_title == '0'): ?>
                            <h1 class="entry-title"><?= get_the_title(); ?></h1>
                        <?php endif; ?>
                        <ul class="post-meta">
                            <?php if (has_category()): ?>
                                <li>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <rect x="3" y="3" width="7" height="7"></rect>
                                        <rect x="14" y="3" width="7" height="7"></rect>
                                        <rect x="14" y="14" width="7" height="7"></rect>
                                        <rect x="3" y="14" width="7" height="7"></rect>
                                    </svg>
                                    <span><?php the_category(', ') ?></span>
                                </li>
                            <?php endif; ?>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                    <line x1="16" y1="2" x2="16" y2="6"></line>
                                    <line x1="8" y1="2" x2="8" y2="6"></line>
                                    <line x1="3" y1="10" x2="21" y2="10"></line>
                                </svg>
                                <time datetime="<?= the_date('d-m-Y'); ?>"><?= get_the_date(); ?></time>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <span><?php the_author_posts_link(); ?></span>
                            </li>
                        </ul>
                    </header>

                    <div class="post-content">
                        <?php the_content(); ?>
                    </div>

                    <div class="posts-nav">
                        <?php if ($previous_post = get_previous_post(true)) : ?>
                            <a class="post-adjacent adjacent-prev" href="<?= esc_url(get_permalink($previous_post)); ?>" title="<?= get_the_title($previous_post); ?>">
                                <div class="post-thumbnail">
                                    <?php
                                    $thumbnail_src = ws_get_thumbnail_placeholder();
                                    if ($thumbnail_id = get_post_thumbnail_id($previous_post->ID)) {
                                        if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, ['300', '300'])) {
                                            $thumbnail_src = $thumbnail_image[0];
                                        }
                                    }
                                    ?>
                                    <img <?= ws_image_lazy_load_attr(); ?> src="<?= $thumbnail_src; ?>" alt="<?= get_the_title($previous_post); ?>" />
                                </div>
                                <div class="post-detail">
                                    <span class="adjacent-title"><?= __('Previous post', 'webafra-store'); ?></span>
                                    <h4><?= get_the_title($previous_post); ?></h4>
                                </div>
                            </a>
                        <?php else : ?>
                            <span></span>
                        <?php endif; ?>

                        <?php if ($next_post = get_next_post(true)) : ?>
                            <a class="post-adjacent adjacent-next" href="<?= esc_url(get_permalink($next_post)); ?>" title="<?= get_the_title($next_post); ?>">
                                <div class="post-detail">
                                    <span class="adjacent-title"><?= __('Next post', 'webafra-store'); ?></span>
                                    <h4><?= get_the_title($next_post); ?></h4>
                                </div>
                                <div class="post-thumbnail">
                                    <?php
                                    $thumbnail_src = ws_get_thumbnail_placeholder();
                                    if ($thumbnail_id = get_post_thumbnail_id($next_post->ID)) {
                                        if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, ['300', '300'])) {
                                            $thumbnail_src = $thumbnail_image[0];
                                        }
                                    }
                                    ?>
                                    <img <?= ws_image_lazy_load_attr(); ?> src="<?= $thumbnail_src; ?>" alt="<?= get_the_title($next_post); ?>" />
                                </div>
                            </a>
                        <?php else : ?>
                            <span></span>
                        <?php endif; ?>
                    </div>

                    <div class="post-details">
                        <?php if ($tags = get_the_terms(get_the_ID(), 'post_tag')) : ?>
                            <div class="categories tags">
                                <i class="fa-light fa-tags"></i>
                                <?= __('Tags', 'webafra-store'); ?>
                                <?php foreach ($tags as $tag) : ?>
                                    <a href="<?= get_term_link($tag, 'post_tag'); ?>" title="<?= $tag->name; ?>" rel="tag"><?= $tag->name; ?></a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>

                        <div class="categories-share">
                            <?php if ($categories = get_the_terms(get_the_ID(), 'category')) : ?>
                                <div class="categories">
                                    <i class="fa-light fa-folder-open"></i>
                                    <?= __('Categories', 'webafra-store'); ?>
                                    <?php foreach ($categories as $category) : ?>
                                        <a href="<?= get_term_link($category, 'category'); ?>" title="<?= $category->name; ?>" rel="category tag"><?= $category->name; ?></a>
                                    <?php endforeach; ?>
                                </div>
                            <?php else: ?>
                                <div></div>
                            <?php endif; ?>

                            <div class="post-share">
                                <button onclick="postSocialSharingPopup('<?= get_the_ID(); ?>');" title="<?= __('Share', 'webafra-store'); ?>" href="javascript:void(0);">
                                    <i class="fa-light fa-share-nodes"></i>
                                    <?= __('Share', 'webafra-store'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <?php get_template_part('templates/single-post/related-posts', null, [
                    'post_id' => get_the_ID()
                ]); ?>

                <?php if (comments_open() || get_comments_number()) : ?>
                    <?php comments_template(); ?>
                <?php endif; ?>

                <?php get_template_part('templates/share-popup', null, [
                    'post_id' => get_the_ID(),
                ]); ?>
            <?php endwhile; ?>
        </main>

        <?php if (!get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true)): ?>
            <aside class="blog-singleSidebar">
                <div class="sidebar-sticky">
                    <?php dynamic_sidebar('blog-single'); ?>
                </div>
            </aside>
        <?php endif; ?>
    </article>
</div>

<?php get_footer(); ?>