<?php get_header(); ?>

<div class="container">

    <main class="blog-archive search-page">
        <?php ws_theme_breadcrumb(); ?>
        <header class="archive-heading">
            <h1><?= get_the_archive_title(); ?></h1>
        </header>
        <?php if (have_posts()): ?>
            <div class="archive-posts">
                <?php while (have_posts()): the_post(); ?>
                    <?php get_template_part('templates/post-loop/archive'); ?>
                <?php endwhile; ?>
            </div>

            <?php if (ws_current_query_max_pages_count() > 1): ?>
                <div class="pagination-wrapper blog-pagination-wrapper" id="pagination-wrapper">
                    <nav class="woocommerce-pagination-theme" aria-label="<?php esc_attr_e('Blog Pagination', 'webafra-store'); ?>">
                        <?php ws_pagination(); ?>
                    </nav>
                </div>

                <div class="pagination-showButton" id="pagination-showButton">
                    <button onclick="showPagination();">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <span><?= __('Show more', 'webafra-store'); ?></span>
                    </button>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="theme-alert">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"></circle>
                    <line x1="12" y1="16" x2="12" y2="12"></line>
                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                </svg>
                <p><?= __('No result', 'webafra-store'); ?>!</p>
            </div>
        <?php endif; ?>
    </main>

</div>

<?php get_footer(); ?>