<?php get_header(); ?>

<div class="container">
    <div style="margin-top: 20px;">
        <?php ws_theme_breadcrumb(); ?>
    </div>
    <article class="blog-single<?= get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true) ? ' no-sidebar' : ''; ?>">
        <main class="blog-singleMain">
            <?php while (have_posts()): the_post(); ?>
                <div class="post-body">
                    <?php $theme_settings_hidden_title = get_post_meta(get_the_ID(), '_ws_theme_settings_hidden_title', true); ?>
                    <?php if (empty($theme_settings_hidden_title) || $theme_settings_hidden_title == '0'): ?>
                        <header class="post-header">
                            <h1 class="entry-title"><?= get_the_title(); ?></h1>
                        </header>
                    <?php endif; ?>

                    <div class="post-content">
                        <?php the_content(); ?>
                    </div>
                </div>

                <?php if (comments_open() || get_comments_number()) : ?>
                    <?php comments_template(); ?>
                <?php endif; ?>
            <?php endwhile; ?>
        </main>

        <?php if (!get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true)): ?>
            <aside class="blog-singleSidebar">
                <div class="sidebar-sticky">
                    <?php dynamic_sidebar('blog-single'); ?>
                </div>
            </aside>
        <?php endif; ?>
    </article>
</div>

<?php get_footer(); ?>