<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Woocommerce
{
    public static $ins = null;

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }

        return self::$ins;
    }

    public function __construct()
    {
        add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');

        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('widgets_init', [$this, 'register_sidebars']);

        add_action('woocommerce_before_shop_loop', [$this, 'before_order_con'], 19);

        $this->single_product_hooks();
        $this->single_product_loop_hooks();

        add_filter('woocommerce_layered_nav_count', function ($text, $count) {
            return '<span class="count">' . absint($count) . '</span>';
        }, 20, 2);

        add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
            $wc_cart = WC()->cart;

            $contents_count = $wc_cart->get_cart_contents_count();

            $fragments['.cart-countBadge-selector'] = '<span class="cart-countBadge cart-countBadge-selector">' . $contents_count . '</span>';

            return $fragments;
        }, 99);

        add_action('woocommerce_product_query', [$this, 'shop_filter_query']);

        add_action('init', function () {
            add_rewrite_endpoint('tracking', EP_ROOT | EP_PAGES);
        });

        add_filter('query_vars', function ($vars) {
            $vars[] = 'tracking';

            return $vars;
        }, 0);

        add_filter('woocommerce_account_menu_items', function ($items) {
            $logout = $items['customer-logout'];
            unset($items['customer-logout']);

            $items['tracking'] = __('Order tracking', 'webafra-store');

            $items['customer-logout'] = $logout;
            return $items;
        });

        add_action('woocommerce_account_tracking_endpoint', [$this, 'my_account_tracking_page']);

        add_action('wc_ajax_ws_toggle_add_product_compare', [$this, 'toggle_add_product_compare']);
        add_action('wc_ajax_nopriv_ws_toggle_add_product_compare', [$this, 'toggle_add_product_compare']);

        add_filter('woocommerce_single_product_carousel_options',  function ($options) {
            $options['directionNav'] = true;
            return $options;
        });

        if (function_exists('yoast_breadcrumb')) {
            add_filter('wpseo_breadcrumb_links', function ($links) {
                if (is_woocommerce() && is_product()) {
                    // Remove shop page
                    $links = array_filter($links, fn($link) => $link['url'] != wc_get_page_permalink('shop'));
                }

                return $links;
            });
        }

        add_filter('woocommerce_format_price_range', [$this, 'custom_format_price_range'], 10, 3);
    }

    public function enqueue_scripts()
    {
        if (!wp_script_is('wc-cart-fragments')) {
            wp_enqueue_script('wc-cart-fragments');
        }
    }

    public function toggle_add_product_compare()
    {
        header('Content-Type: application/json; charset=utf-8');

        if (!function_exists('ws_wccm_add_button')) {
            exit;
        }

        if (!wp_verify_nonce($_POST['nonce'], 'ws-ajax-nonce')) {
            echo wp_json_encode([
                'status' => 'error',
                'msg' => __('Invalid request', 'webafra-store'),
            ]);
            exit;
        }

        if (empty($_POST['product_id'])) {
            echo wp_json_encode([
                'status' => 'error',
            ]);
            exit;
        }

        $list = wccm_get_compare_list();

        if (in_array($_POST['product_id'], $list)) {
            wccm_remove_product_from_compare_list($_POST['product_id']);

            echo wp_json_encode([
                'status' => 'ok',
                'added' => '0',
                'msg' => __('Removed', 'webafra-store'),
                'count' => count(wccm_get_compare_list()),
            ]);
            exit;
        }

        wccm_add_product_to_compare_list($_POST['product_id']);

        echo wp_json_encode([
            'status' => 'ok',
            'added' => '1',
            'msg' => __('Added', 'webafra-store'),
            'count' => count(wccm_get_compare_list()),
        ]);
        exit;
    }

    public function my_account_tracking_page()
    {
        $order_number = '';
        $error = null;
        $order = null;

        if (isset($_POST['myaccount_order_tracking_submit'])) {
            $verify_nonce = wp_verify_nonce($_POST['_wpnonce'], 'myaccount_order_tracking');
            if ($verify_nonce === 1) {
                if (isset($_POST['order_number']) && is_numeric($_POST['order_number'])) {
                    $order_number = $_POST['order_number'];
                    $order = wc_get_order((int) $order_number);

                    if ($order) {
                        if ($order->get_user_id() != get_current_user_id()) {
                            $error = '<div class="woocommerce-error" style="margin:0;margin-top:15px;">' . __('No result !', 'webafra-store') . '</div>';
                        }
                    } else {
                        $error = '<div class="woocommerce-error" style="margin:0;margin-top:15px;">' . __('No result !', 'webafra-store') . '</div>';
                    }
                } else {
                    $error = '<div class="woocommerce-error" style="margin:0;margin-top:15px;">' . __('Invalid code! tracking code must be numeric.', 'webafra-store') . '</div>';
                }
            }
        }

        include_once get_template_directory() . '/templates/woocommerce/myaccount-tracking.php';

        if (is_null($error) && !is_null($order)) {
            $order_data = $order->get_data();
            $order_customer = $order_data['billing']['first_name'] . ' ' . $order_data['billing']['last_name'];
            $customer_note = $order->get_customer_note();
            $payment_method = $order->get_payment_method_title();
            $shipping_method = $order->get_shipping_method();
            $products = [];

            if (count($order->get_items())) {
                foreach ($order->get_items() as $item) {
                    $product_id = $item['product_id'];
                    $product_link = get_permalink($product_id);
                    $product_title = get_the_title($product_id);
                    $products[] = "<li><a href='{$product_link}'>{$product_title}</a></li>";
                }
                $products = implode("\n", $products);
            }

            include_once get_template_directory() . '/templates/woocommerce/myaccount-tracking-result.php';
        }
    }

    public function register_sidebars()
    {
        $sidebars = [
            'shop-raw' => [
                'name' => __('Shop (Raw)', 'webafra-store'),
                'id' => 'shop-raw',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget raw %2$s">',
                'after_widget' => '</section>',
                'before_title' => '',
                'after_title' => '',
            ],
            'shop' => [
                'name' => __('Shop', 'webafra-store'),
                'id' => 'shop',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<div class="widget-title"><h3 class="title-content">',
                'after_title' => '</h3></div>',
            ],
            'brand-raw' => [
                'name' => __('Brand (Raw)', 'webafra-store'),
                'id' => 'brand-raw',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget raw %2$s">',
                'after_widget' => '</section>',
                'before_title' => '',
                'after_title' => '',
            ],
            'brand' => [
                'name' => __('Brand archive', 'webafra-store'),
                'id' => 'brand',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<div class="widget-title"><h3 class="title-content">',
                'after_title' => '</h3></div>',
            ],
            'brands-page' => [
                'name' => __('Brands page', 'webafra-store'),
                'id' => 'brands-page',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<div class="widget-title"><h3 class="title-content">',
                'after_title' => '</h3></div>',
            ],
        ];

        foreach ($sidebars as $sidebar) {
            register_sidebar([
                'name' => $sidebar['name'],
                'id' => $sidebar['id'],
                'description' => $sidebar['description'],
                'before_widget' => $sidebar['before_widget'],
                'after_widget' => $sidebar['after_widget'],
                'before_title' => $sidebar['before_title'],
                'after_title' => $sidebar['after_title']
            ]);
        }
    }

    public function single_product_loop_hooks()
    {
        remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
        remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);

        add_action('woocommerce_before_shop_loop_item_title', function () {
            echo '<div class="product-thumbnail">';
        }, 5);

        add_action('woocommerce_before_shop_loop_item_title', function () {
            if (get_theme_mod('single-product-layout', 'one') == 'one') {
                echo '<div class="icon-toggles">';
                if (class_exists('YITH_Woocompare_Frontend')):
                    echo do_shortcode("[yith_compare_button]");
                endif;

                if (function_exists('ws_wccm_add_button')):
                    ws_wccm_add_button();
                endif;

                if (function_exists('tinvwl_shortcode_addtowishlist')):
                    echo '<div class="add-to-wishlist">';
                    echo do_shortcode("[ti_wishlists_addtowishlist loop=yes]");
                    echo '</div>';
                endif;
                echo '</div>';

                if (function_exists('woo_variation_swatches')) {
                    global $product;
                    echo ws_wc_display_product_loop_color_attributes($product, 'pa_color');
                }
            }

            echo '</div>';
            echo '<div class="product-details">';
        }, 20);

        add_action('woocommerce_after_shop_loop_item', function () {
            global $product;
?>
            <div class="product-footer">
                <?php if (get_theme_mod('shop-product-loop-layout', 'one') == 'two'): ?>
                    <div class="product-rating">
                        <span><?= $product->get_average_rating(); ?></span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 16">
                            <path fill="#EEC200" d="M6.701 1.654a1.64 1.64 0 012.979 0l1.053 2.197c.242.505.71.855 1.25.936l2.354.352c1.362.204 1.906 1.928.92 2.918l-1.703 1.71c-.391.393-.57.96-.478 1.514l.403 2.415c.232 1.398-1.192 2.464-2.41 1.804l-2.106-1.14a1.618 1.618 0 00-1.545 0L5.312 15.5c-1.218.66-2.642-.406-2.41-1.803l.403-2.416a1.743 1.743 0 00-.478-1.514l-1.704-1.71c-.985-.99-.441-2.714.92-2.918l2.355-.352c.541-.081 1.009-.431 1.25-.936l1.053-2.197z"></path>
                        </svg>
                    </div>
                <?php endif; ?>

                <div class="product-price">
                    <?php if ($price_html = $product->get_price_html()) : ?>
                        <span class="price"><?php echo $price_html; ?></span>
                    <?php endif; ?>
                </div>

                <?php if (get_theme_mod('shop-product-loop-layout', 'one') == 'one'): ?>
                    <div class="product-cartButton">
                        <?php if ($product->is_purchasable() && $product->is_in_stock()) : ?>
                            <a href="<?= esc_url($product->add_to_cart_url()); ?>" data-quantity="1" data-product_id="<?= $product->get_id(); ?>" class="button add_to_cart_button ajax_add_to_cart" aria-label="<?= __('Add to cart', 'webafra-store'); ?>">
                                <i class="cart-icon fa-light fa-cart-plus"></i>
                                <i class="added-icon fa-light fa-cart-circle-check"></i>
                            </a>
                        <?php else : ?>
                            <span></span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php
        }, 20);

        add_action('woocommerce_after_shop_loop_item', function () {
            echo '</div>';
        }, 30);

        add_action('woocommerce_shop_loop_item_title', function () {
            $heading_tag = 'h3';

            $archive_cat = get_queried_object();

            if (!is_null($archive_cat)) {
                if (isset($archive_cat->parent)) {
                    if ($archive_cat->parent) {
                        $heading_tag = 'h2';
                    }
                }
            }

            echo '<' . $heading_tag . ' class="' . esc_attr(apply_filters('woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title')) . '">' . get_the_title() . '</' . $heading_tag . '>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        }, 10);
    }

    public function single_product_hooks()
    {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);

        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 10);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 30);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 40);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 50);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 55);

        add_action('woocommerce_single_product_summary', function () {
            echo '<div class="product-summary-con">';
        }, 2);

        add_action('woocommerce_single_product_summary', function () {
            echo '</div>';
        }, 70);

        add_action('woocommerce_single_product_summary', function () {
            global $product;

            echo '<div class="product-summery-con">';
            echo '<div class="product-features">';
            echo '<strong class="features-title">' . __('Product features', 'webafra-store') . ':<a href="#information-tabs"><i class="fa-duotone fa-eye"></i>مشخصات کامل</a></strong>';

            $attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');

            if (!empty($attributes)) {
                echo '<ul id="single-product-features" class="features-list' . (count($attributes) > 3 ? ' limited' : ' unlimited') . '">';

                foreach ($attributes as $attribute) {
                    $values = array();

                    if ($attribute->is_taxonomy()) {
                        $attribute_taxonomy = $attribute->get_taxonomy_object();
                        $attribute_values   = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                        foreach ($attribute_values as $attribute_value) {
                            $value_name = esc_html($attribute_value->name);

                            if ($attribute_taxonomy->attribute_public) {
                                $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                            } else {
                                $values[] = $value_name;
                            }
                        }
                    } else {
                        $values = $attribute->get_options();

                        foreach ($values as &$value) {
                            $value = make_clickable(esc_html($value));
                        }
                    }

                    if (get_theme_mod('single-product-layout', 'one') == 'one') {
                        echo '<li><div class="label"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg><label>' . wc_attribute_label($attribute->get_name()) . ':</label></div>' . wpautop(wptexturize(implode(', ', $values))) . '</li>';
                    } else {
                        echo '<li><div class="label"><label>' . wc_attribute_label($attribute->get_name()) . ':</label></div>' . wpautop(wptexturize(implode(', ', $values))) . '</li>';
                    }
                }

                echo '</ul>';

                if (count($attributes) > 3) {
                    echo '<div id="features-showmore" class="features-showmore" onclick="featureShowMore(this);"><span class="more"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>' . __('Show more', 'webafra-store') . '</span><span class="less"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="5" y1="12" x2="19" y2="12"></line></svg>' . __('Show less', 'webafra-store') . '</span></div>';
                }
            }

            if (get_theme_mod('enable-single-product-contact-button', '1')) {
                $single_product_contact_button_text = get_theme_mod('single-product-contact-button-text', __('One call to buy', 'webafra-store') . ' 021123456789');
                $single_product_contact_button_url = get_theme_mod('single-product-contact-button-url', '#');

                echo '<a class="single-product-contact-button" href="' . $single_product_contact_button_url . '" target="_blank" title="' . $single_product_contact_button_text . '"><i aria-hidden="true" class="fab fa-whatsapp"></i>' . $single_product_contact_button_text . '</a>';
            }

            echo '</div>';
            echo '<div class="price-con">';
        }, 8);

        add_action('woocommerce_single_product_summary', function () {
            echo '</div>';
            echo '</div>';
        }, 65);

        add_action('woocommerce_single_product_summary', function () {
            global $product;
            $sale_price_dates_to = get_post_meta($product->get_id(), get_theme_mod('shop-product-offer-end-date-key', '_woo_product_offerslider_timer'), true);
            if (!empty($sale_price_dates_to)): ?>
                <div class="single-count-down">
                    <ul class="countDown-timer" id="single_product_display_timer_<?= $product->get_id(); ?>"></ul>

                    <i class="fa-light fa-alarm-clock"></i>
                </div>
                <script>
                    var countDownDate = new Date('<?= date('Y-m-d', $sale_price_dates_to); ?>').getTime();

                    var timer_int = setInterval(function() {
                        var now = new Date().getTime();
                        var distance = countDownDate - now;
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                        var html = '';

                        if (distance < 0) {
                            clearInterval(timer_int);
                            html = `<span class="finished"><?= __('Offer is finished', 'webafra-store'); ?>!</span>`;

                        } else {
                            html = `<li class="time">${seconds}</li><li class="separator">:</li><li class="time">${minutes}</li><li class="separator">:</li><li class="time">${hours}</li><li class="separator">:</li><li class="time">${days}</li>`;
                        }

                        jQuery(`#single_product_display_timer_<?= $product->get_id(); ?>`).html(html);
                    }, 1000);
                </script>
<?php endif;
        }, 35);

        add_action('woocommerce_before_single_product_summary', function () {
            echo '<div class="woo-flash-con">';
        }, 9);

        add_action('woocommerce_before_single_product_summary', function () {
            echo '</div>';
        }, 11);

        add_action('woocommerce_before_single_product_summary', function () {
            global $product;

            echo '<ul class="product-userActions' . ($product->is_on_sale() ? ' on-sale' : '') . '">';

            if (get_theme_mod('single-product-layout', 'one') == 'one') {
                if (class_exists('YITH_Woocompare_Frontend')):
                    echo '<li class="compare" title="' . __('Compare', 'webafra-store') . '">' . do_shortcode("[yith_compare_button]") . '</li>';
                endif;

                if (function_exists('ws_wccm_add_button')):
                    echo '<li class="compare" title="' . __('Compare', 'webafra-store') . '">';
                    ws_wccm_add_button();
                    echo '</li>';
                endif;

                if (function_exists('tinvwl_shortcode_addtowishlist')) {
                    echo '<li class="wishlists" title="' . __('Wishlist', 'webafra-store') . '">' . do_shortcode("[ti_wishlists_addtowishlist]") . '</li>';
                }

                echo '<li class="social-sharing" title="' . __('Share', 'webafra-store') . '"><button onclick="postSocialSharingPopup(' . $product->get_id() . ');" title="' . __('Share', 'webafra-store') . '" href="javascript:void(0);"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="18" cy="5" r="3"></circle><circle cx="6" cy="12" r="3"></circle><circle cx="18" cy="19" r="3"></circle><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"></line><line x1="15.41" y1="6.51" x2="8.59" y2="10.49"></line></svg></button></li>';
            }
            echo '</ul>';
        }, 11);

        add_filter('woocommerce_product_tabs', function ($tabs) {

            global $product;

            if ($product) {
                $pa_brands = wc_get_product_terms($product->get_id(), get_theme_mod('shop-brand-taxonomy', 'pa_brand'));

                if (!empty($pa_brands)) {
                    $pa_brand = reset($pa_brands);

                    $brand_thumbnail_src = wc_placeholder_img_src();
                    if ($brand_thumbnail_id = get_term_meta($pa_brand->term_id, 'product_attribute_image', true)) {
                        if ($brand_thumbnail_image = wp_get_attachment_image_src($brand_thumbnail_id, 'woocommerce_thumbnail')) {
                            $brand_thumbnail_src = $brand_thumbnail_image[0];
                        }
                    }

                    $tabs['product_brand'] = [
                        'title' => __('Product brand', 'webafra-store'),
                        'priority' => 25,
                        'callback' => function () use ($pa_brand, $brand_thumbnail_src) {
                            echo '<a title="' . $pa_brand->name . '" href="' . get_term_link($pa_brand) . '" class="brand-logo"><img ' . ws_image_lazy_load_attr() . ' alt="' . $pa_brand->name . '" src="' . $brand_thumbnail_src . '"/></a>';
                            echo '<h2 class="brand-title"><a title="' . $pa_brand->name . '" href="' . get_term_link($pa_brand) . '">' . $pa_brand->name . '</a></h2>';
                            echo '<p class="brand-description">' . $pa_brand->description . '</p>';
                        }
                    ];
                }
            }

            return $tabs;
        });

        if (get_theme_mod('single-product-layout', 'one') == 'two') {
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 40);
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);

            function wc_remove_all_quantity_fields($return, $product)
            {
                return true;
            }
            add_filter('woocommerce_is_sold_individually', 'wc_remove_all_quantity_fields', 10, 2);

            remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
            remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

            add_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 20);
            add_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 10);
        }
    }

    public function before_order_con()
    {
        echo '<div class="shop-headFilters">';

        echo '<div class="filters-right">';

        echo '<a href="javascript:void(0);"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="4" y1="21" x2="4" y2="14"></line><line x1="4" y1="10" x2="4" y2="3"></line><line x1="12" y1="21" x2="12" y2="12"></line><line x1="12" y1="8" x2="12" y2="3"></line><line x1="20" y1="21" x2="20" y2="16"></line><line x1="20" y1="12" x2="20" y2="3"></line><line x1="1" y1="14" x2="7" y2="14"></line><line x1="9" y1="8" x2="15" y2="8"></line><line x1="17" y1="16" x2="23" y2="16"></line></svg></a>';

        echo '<ul>';

        if (isset($_GET['orderby'])) {
            $orderby = $_GET['orderby'];
        } elseif (is_search()) {
            $orderby = 'relevance';
        } else {
            $orderby = get_option('woocommerce_default_catalog_orderby');
        }

        $catalog_orderby_options = [
            'menu_order' => __('Default', 'webafra-store'),
            'popularity' => __('Popularity', 'webafra-store'),
            'rating' => __('Rating', 'webafra-store'),
            'date' => __('Latest', 'webafra-store'),
            'price' => __('Low price', 'webafra-store'),
            'price-desc' => __('High price', 'webafra-store'),
        ];

        if (is_search()) {
            $catalog_orderby_options['relevance'] = __('Relevance', 'webafra-store');

            unset($catalog_orderby_options['menu_order']);
        }

        foreach ($catalog_orderby_options as $option_key => $option) {
            echo '<li class="order-item order-rating' . ($orderby == $option_key ? ' is-active' : '') . '">';
            echo '<a rel="nofollow" href="' . ws_wc_order_get_link($option_key) . '">' . $option . '</a>';
            echo '</li>';
        }

        echo '</ul>';

        echo '</div>';

        echo '<div class="ordering">';

        echo '<div class="ordering-resultCount">';
        woocommerce_result_count();
        echo '</div>';

        echo '<div class="ordering-catalog">';
        woocommerce_catalog_ordering();
        echo '</div>';

        echo '</div>';

        echo '</div>';
    }

    public function shop_filter_query($q)
    {
        if ((is_woocommerce() && is_archive()) || is_shop()) {
            $current_stock_status = isset($_GET['stock_status']) ? explode(',', $_GET['stock_status']) : [];
            $product_brand = isset($_GET['product_brand']) ? explode(',', $_GET['product_brand']) : [];

            if (in_array('onsale', $current_stock_status)) {
                $product_ids_on_sale = wc_get_product_ids_on_sale();
                $q->set('post__in', $product_ids_on_sale);
            }

            if (in_array('instock', $current_stock_status)) {
                $query_array = [
                    'relation' => 'AND',
                    [
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    ]
                ];

                $q->set('meta_query', $query_array);
            }

            if (!empty($product_brand)) {
                $tax_query = [
                    'relation' => 'AND',
                    [
                        'taxonomy' => get_theme_mod('shop-brand-taxonomy', 'pa_brand'),
                        'field' => 'term_id',
                        'terms' => $product_brand,
                    ]
                ];

                $q->set('tax_query', $tax_query);
            }
        }
    }

    public function custom_format_price_range($price)
    {
        $price = str_replace('&ndash;', '<span class="separator">&ndash;</span>', $price);
        return $price;
    }
}

if (class_exists('WooCommerce')) {
    Webafra_Store_Woocommerce::ins();
}
