<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Onsale_Stock_Widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct('webafra_store_onsale_stock', __('Theme: Stock status', 'webafra-store'), [
            'description' => __('Filter stock and on-sale products', 'webafra-store')
        ]);
    }

    function get_link($status)
    {
        $base_link = ws_wc_shop_page_link(true);
        $link = remove_query_arg('stock_status', $base_link);
        $current_stock_status = isset($_GET['stock_status']) ? explode(',', $_GET['stock_status']) : [];
        $option_is_set = in_array($status, $current_stock_status);

        if (!in_array($status, $current_stock_status)) {
            $current_stock_status[] = $status;
        }

        foreach ($current_stock_status as $key => $value) {
            if ($option_is_set && $value === $status) {
                unset($current_stock_status[$key]);
            }
        }

        if ($current_stock_status) {
            asort($current_stock_status);
            $link = add_query_arg('stock_status', implode(',', $current_stock_status), $link);
        }

        $link = str_replace('%2C', ',', $link);
        return $link;
    }

    public function widget($args, $instance)
    {
        if (is_shop() || is_product_taxonomy()) {

            $title = apply_filters('widget_title', $instance['title']);
            $show_instock = isset($instance['show_instock']) ? $instance['show_instock'] : '';
            $show_onsale  = isset($instance['show_onsale']) ? $instance['show_onsale'] : '';

            echo $args['before_widget'];

            if (!empty($title)) {
                echo $args['before_title'] . $title . $args['after_title'];
            }

            $current_stock_status = isset($_GET['stock_status']) ? explode(',', $_GET['stock_status']) : []; ?>

            <ul class="sale-stock-filter">
                <?php if ($show_onsale) { ?>
                    <?php $this->get_link('onsale'); ?>
                    <li class="filter-item filter-onsale<?php echo in_array('onsale', $current_stock_status) ? ' is-active' : ''; ?>">
                        <a rel="nofollow" href="<?php echo esc_attr($this->get_link('onsale')); ?>">
                            <?php _e('On sale', 'webafra-store'); ?>
                        </a>
                    </li>
                <?php } ?>

                <?php if ($show_instock) { ?>
                    <?php $this->get_link('instock'); ?>
                    <li class="filter-item filter-instock<?php echo in_array('instock', $current_stock_status) ? ' is-active' : ''; ?>">
                        <a rel="nofollow" href="<?php echo esc_attr($this->get_link('instock')); ?>">
                            <?php _e('In Stock', 'webafra-store'); ?>
                        </a>
                    </li>
                <?php } ?>
            </ul>
        <?php
            echo $args['after_widget'];
        }
    }

    public function form($instance)
    {
        $title        = isset($instance['title']) ? esc_attr($instance['title']) : __('Stock status', 'webafra-store');
        $show_onsale  = isset($instance['show_onsale']) ? $instance['show_onsale'] : '';
        $show_instock = isset($instance['show_instock']) ? $instance['show_instock'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'webafra-store'); ?>:</label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('show_onsale'); ?>">
                <input type="checkbox" id="<?php echo $this->get_field_id('show_onsale'); ?>" value="true" name="<?php echo $this->get_field_name('show_onsale'); ?>" <?php checked($show_onsale, 'true'); ?> />
                <?php _e('Show On Sale', 'webafra-store') ?>
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('show_instock'); ?>">
                <input type="checkbox" id="<?php echo $this->get_field_id('show_instock'); ?>" value="true" name="<?php echo $this->get_field_name('show_instock'); ?>" <?php checked($show_instock, 'true'); ?> />
                <?php _e('Show In Stock', 'webafra-store') ?>
            </label>
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = [];

        $instance['title']        = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['show_onsale']  = sanitize_text_field($new_instance['show_onsale']);
        $instance['show_instock'] = sanitize_text_field($new_instance['show_instock']);

        return $instance;
    }
}

add_action('widgets_init', function () {
    register_widget('Webafra_Store_Onsale_Stock_Widget');
});
