<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Brand_Filter_v2_Widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct('webafra_store_brand_filter_v2', __('Theme: Brand filter', 'webafra-store') . ' (v2)', [
            'description' => __('Product brand filter', 'webafra-store')
        ]);
    }

    public function widget($args, $instance)
    {
        $taxonomy = get_theme_mod('shop-brand-taxonomy', 'pa_brand');

        $brands = get_terms([
            'taxonomy' => $taxonomy,
            'depth' => 1,
            'hide_empty' => true
        ]);

        if (!empty($brands)) {
            $title = apply_filters('widget_title', $instance['title']);
            $show_brand_logo = isset($instance['show_brand_logo']) ? $instance['show_brand_logo'] : '';

            echo $args['before_widget'];

            if (!empty($title)) {
                echo $args['before_title'] . $title . $args['after_title'];
            }

            $current_brand_id = 0;

            if ($queried_object = get_queried_object()) {
                if ((!empty($queried_object->taxonomy) && $queried_object->taxonomy == $taxonomy)) {
                    $current_brand_id = $queried_object->term_id;
                }
            }
?>
            <ul class="brand-filter">
                <?php
                foreach ($brands as $brand) {
                    $brand = get_term($brand); ?>
                    <li class="filter-item<?= ($brand->term_id == $current_brand_id) ? ' is-active' : ''; ?>">
                        <a rel="nofollow" title="<?= $brand->name; ?>" href="<?php echo esc_attr(get_term_link($brand, $taxonomy)); ?>">
                            <?php if (!empty($show_brand_logo)) {
                                $brand_thumbnail_src = wc_placeholder_img_src();
                                if ($brand_thumbnail_id = get_term_meta($brand->term_id, 'product_attribute_image', true)) {
                                    if ($brand_thumbnail_image = wp_get_attachment_image_src($brand_thumbnail_id, 'woocommerce_thumbnail')) {
                                        $brand_thumbnail_src = $brand_thumbnail_image[0];
                                    }
                                }
                                echo '<img ' . ws_image_lazy_load_attr() . ' src="' . $brand_thumbnail_src . '" alt="' . $brand->name . '" class="filter-brand-logo">';
                            }
                            echo $brand->name;
                            ?>
                        </a>
                    </li>
                <?php } ?>
            </ul>
        <?php echo $args['after_widget'];
        }
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Brand filter', 'webafra-store');
        $show_brand_logo = isset($instance['show_brand_logo']) ? $instance['show_brand_logo'] : ''; ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'webafra-store'); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('show_brand_logo'); ?>">
                <input type="checkbox" id="<?php echo $this->get_field_id('show_brand_logo'); ?>" value="true" name="<?php echo $this->get_field_name('show_brand_logo'); ?>" <?php checked($show_brand_logo, 'true'); ?> />
                <?php _e('Show brand logo', 'webafra-store') ?>
            </label>
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = [];

        $instance['title'] = (! empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['show_brand_logo'] = sanitize_text_field($new_instance['show_brand_logo']);

        return $instance;
    }
}

add_action('widgets_init', function () {
    register_widget('Webafra_Store_Brand_Filter_v2_Widget');
});
