<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store
{
    public static $ins = null;

    public $theme_version = null;

    public $template_directory = null;

    public $template_directory_uri = null;

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }

        return self::$ins;
    }

    public function __construct()
    {
        $this->theme_version = wp_get_theme()->get('Version');

        $this->template_directory = get_template_directory();

        $this->template_directory_uri = get_template_directory_uri();

        add_action('after_setup_theme', [$this, 'theme_support']);

        add_action('after_setup_theme', [$this, 'thumbnails_support']);

        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('customize_preview_init', [$this, 'customize_live_preview']);

        add_action('customize_save_after', [$this, 'create_inline_css_file']);

        add_action('widgets_init', [$this, 'register_sidebars']);

        add_action('init', [$this, 'register_menus']);

        add_action('wp_footer', [$this, 'footer_base'], 99);

        add_filter('intermediate_image_sizes_advanced', [$this, 'remove_default_thumbnail_sizes']);

        add_filter('get_the_archive_title_prefix', function ($prefix) {
            $prefix = '';
            return $prefix;
        });

        add_filter('body_class', [$this, 'body_classes']);

        add_filter('wp_list_categories', [$this, 'add_span_to_count_for_list_categories']);

        $this->classic_widgets();

        if (get_theme_mod('disable-wp-sitemap', 1)) {
            add_filter('wp_sitemaps_enabled', '__return_false');
        }

        add_action('wp', [$this, 'wpseo_json_ld_output']);
    }

    public function theme_support()
    {
        add_theme_support('title-tag');

        add_theme_support('custom-logo');

        add_theme_support('html5', [
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption'
        ]);
    }

    public function thumbnails_support()
    {
        add_theme_support('post-thumbnails');

        add_image_size('public-blog-thumbnail', 534, 300, true);
    }

    public function remove_default_thumbnail_sizes($sizes)
    {
        // unset($sizes['thumbnail']);
        // unset($sizes['medium']);
        // unset($sizes['medium_large']);
        // unset($sizes['large']);
        unset($sizes['1536x1536']);
        unset($sizes['2048x2048']);

        return $sizes;
    }

    public function enqueue_scripts()
    {
        wp_enqueue_style('fontawesome.all.min', $this->template_directory_uri . '/assets/fontawesome/css/all.css', [], '6.6.0');

        wp_enqueue_style('theme-fonts.min', $this->template_directory_uri . '/assets/css/fonts.min.css', [], $this->theme_version);
        wp_enqueue_style('theme.min', $this->template_directory_uri . '/assets/css/theme.min.css', [], $this->theme_version);
        wp_enqueue_style('theme-inline', $this->template_directory_uri . '/assets/css/inline.css', [], time());

        wp_enqueue_script('theme.min', $this->template_directory_uri . '/assets/js/theme.min.js', ['jquery'], $this->theme_version, [
            'in_footer' => 1
        ]);

        // wp_enqueue_style('webafra-store-swiper-bundle.min', $this->template_directory_uri . '/assets/libs/swiperjs/swiper-bundle.min.css', [], '11.1.15');
        // wp_enqueue_script('webafra-store-swiper-bundle.min', $this->template_directory_uri . '/assets/libs/swiperjs/swiper-bundle.min.js', [], '11.1.15', [
        //     'in_footer' => 0
        // ]);

        wp_localize_script('theme.min', 'ws_ajax_var', [
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ws-ajax-nonce')
        ]);

        if (class_exists('WooCommerce')) {
            wp_enqueue_script('woo.min', $this->template_directory_uri . '/assets/js/woo.min.js', ['jquery'], $this->theme_version, [
                'in_footer' => 1
            ]);
        }

        if (comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }

        wp_enqueue_script('wc-cart-fragments');
    }

    public function inline_css()
    {
        $inline_css = [];

        $inline_css[] = ':root{';

        $body_font_family = get_theme_mod('theme-font-family', 'dana');

        if (!empty($body_font_family)) {
            $inline_css[] = "--ws-body-font-family:{$body_font_family};";
        }

        $theme_color_primary = get_theme_mod('theme-color-primary', '#36CDDF');

        if (!empty($theme_color_primary)) {
            $inline_css[] = "--ws-primary:{$theme_color_primary};";
        }

        $theme_color_secondary = get_theme_mod('theme-color-secondary', '#FE504F');

        if (!empty($theme_color_secondary)) {
            $inline_css[] = "--ws-secondary:{$theme_color_secondary};";
        }

        $inline_css[] = '}';

        $theme_color_primary_menu = get_theme_mod('theme-color-primary-menu', '#36CDDF');

        if (!empty($theme_color_primary_menu)) {
            $inline_css[] = ".primary-menu,.primary-menu-wrapper.full-width{background-color:$theme_color_primary_menu;}";
        }

        $theme_color_primary_menu_hover = get_theme_mod('theme-color-primary-menu-hover', '#1EABBB');

        if (!empty($theme_color_primary_menu_hover)) {
            $inline_css[] = ".primary-menu ul.menu>li.current-menu-item>a,.primary-menu ul.menu>li:hover>a{border-top-color:$theme_color_primary_menu_hover;}";
        }

        $theme_color_body = get_theme_mod('theme-color-body', '#F6F6F6');

        if (!empty($theme_color_body)) {
            $inline_css[] = "body{background-color:$theme_color_body;}";
        }

        $theme_color_text = get_theme_mod('theme-color-text', '#464646');

        if (!empty($theme_color_text)) {
            $inline_css[] = "body{color:$theme_color_text;}";
        }

        $theme_color_header = get_theme_mod('theme-color-header', '#F6F6F6');

        if (!empty($theme_color_header)) {
            $inline_css[] = ".header-wrapper{background-color:$theme_color_header;}";
        }

        $theme_color_footer_service = get_theme_mod('theme-color-footer-service', '#929292');

        if (!empty($theme_color_footer_service)) {
            $inline_css[] = ".footer-services{background-color:$theme_color_footer_service;}";
        }

        $theme_color_copyright = get_theme_mod('theme-color-copyright', '#929292');

        if (!empty($theme_color_copyright)) {
            $inline_css[] = ".footer .footer-copyright{background-color:$theme_color_copyright;}";
        }

        $theme_color_footer = get_theme_mod('theme-color-footer', '#F6F6F6');

        if (!empty($theme_color_footer)) {
            $inline_css[] = ".footer .footer-main{background-color:$theme_color_footer;}";
        }

        $single_product_contact_button_text_color = get_theme_mod('single-product-contact-button-text-color', '#ffffff');

        if (!empty($single_product_contact_button_text_color)) {
            $inline_css[] = ".single-product-contact-button{color:$single_product_contact_button_text_color;}";
        }

        $single_product_contact_button_color = get_theme_mod('single-product-contact-button-color', '#36CDDF');

        if (!empty($single_product_contact_button_color)) {
            $inline_css[] = ".single-product-contact-button{background-color:$single_product_contact_button_color;}";
        }

        $footer_mobile_background_color = get_theme_mod('footer-mobile-background-color', '#ffffff');

        if (!empty($footer_mobile_background_color)) {
            $inline_css[] = ".mobile-footer{background-color:$footer_mobile_background_color;}";
        }

        $footer_mobile_background = get_theme_mod('footer-mobile-color', '#555555');

        if (!empty($footer_mobile_background)) {
            $inline_css[] = ".mobile-footer ul li a,.mobile-footer ul li button,.mobile-footer ul li a .item-icon,.mobile-footer ul li button .item-icon{color:$footer_mobile_background;}";
            $inline_css[] = ".mobile-footer ul li a .item-icon svg,.mobile-footer ul li button .item-icon svg{stroke:$footer_mobile_background;}";
        }

        $header_announcement_background_color = get_theme_mod('header-announcement-background-color', '#273238');

        if (!empty($header_announcement_background_color)) {
            $inline_css[] = ".header-announcement{background-color:$header_announcement_background_color;}";
        }

        $header_search_form_max_width = get_theme_mod('header-search-form-max-width', '600');

        if (!empty($header_search_form_max_width)) {
            $inline_css[] = ".header .header-cols .header-col-left .col-left-right .search-wrapper{max-width:{$header_search_form_max_width}px;}";
        }

        if (get_theme_mod('header-announcement-enable', 1)) {
            if ($header_announcement_background_image = get_theme_mod('header-announcement-background-image', '')) {
                if (!empty($header_announcement_background_image)) {
                    $inline_css[] = ".header-announcement{background-image:url('$header_announcement_background_image');}";
                }
            }

            if ($header_announcement_background_size = get_theme_mod('header-announcement-background-size', 'cover')) {
                if (!empty($header_announcement_background_size)) {
                    $inline_css[] = ".header-announcement{background-size:$header_announcement_background_size;}";
                }
            }
        }

        return $inline_css;
    }

    public function customize_live_preview_enqueue_scripts()
    {
        wp_dequeue_style('theme-inline');

        wp_register_style('ws-theme-inline', false);
        wp_add_inline_style('ws-theme-inline', implode("\n", $this->inline_css()));
        wp_enqueue_style('ws-theme-inline');
    }

    public function customize_live_preview()
    {
        add_action('wp_enqueue_scripts', [$this, 'customize_live_preview_enqueue_scripts']);
    }

    public function create_inline_css_file()
    {
        $inline_css_file_dir = $this->template_directory . '/assets/css/inline.css';
        $inline_css_file = fopen($inline_css_file_dir, "w");
        $inline_css_str = implode('', $this->inline_css());

        fwrite($inline_css_file, $inline_css_str);
        fclose($inline_css_file);
    }

    public function register_sidebars()
    {
        $sidebars = [
            'blog' => [
                'name' => __('Blog', 'webafra-store'),
                'id' => 'blog',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
                'after_widget' => '</div></section>',
                'before_title' => '<div class="widget-title"><h3 class="title-content">',
                'after_title' => '</h3></div><div class="widget-content">',
            ],
            'blog-single' => [
                'name' => __('Blog single', 'webafra-store'),
                'id' => 'blog-single',
                'description' => __('Add widgets here', 'webafra-store'),
                'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
                'after_widget' => '</div></section>',
                'before_title' => '<div class="widget-title"><h3 class="title-content">',
                'after_title' => '</h3></div><div class="widget-content">',
            ],
        ];

        foreach ($sidebars as $sidebar) {
            register_sidebar([
                'name' => $sidebar['name'],
                'id' => $sidebar['id'],
                'description' => $sidebar['description'],
                'before_widget' => $sidebar['before_widget'],
                'after_widget' => $sidebar['after_widget'],
                'before_title' => $sidebar['before_title'],
                'after_title' => $sidebar['after_title']
            ]);
        }
    }

    public function register_menus()
    {
        register_nav_menus([
            'header-top' => __('Header top', 'webafra-store'),
            'header-primary' => __('Header primary', 'webafra-store'),
            'footer-menu-right' => __('Footer menu (right)', 'webafra-store'),
            'footer-menu-left' => __('Footer menu (left)', 'webafra-store'),
        ]);
    }

    public function classic_widgets()
    {
        // Disables the block editor from managing widgets in the Gutenberg plugin.
        add_filter('gutenberg_use_widgets_block_editor', '__return_false');
        // Disables the block editor from managing widgets.
        add_filter('use_widgets_block_editor', '__return_false');
    }

    public function footer_base()
    {
        get_template_part('templates/footer-base');
    }

    public function body_classes($classes)
    {
        if (get_theme_mod('header-nav-sticky', 1)) {
            $classes[] = 'header-nav-sticky';
        }

        $classes[] = 'theme-' . get_theme_mod('theme-container', 'container');

        return $classes;
    }

    public function add_span_to_count_for_list_categories($links)
    {
        return str_replace(['(', ')'], ['<span class="count">', '</span>'], $links);
    }

    public function wpseo_json_ld_output()
    {
        $can_render = 0;

        if (is_page()) {
            $can_render = 1;
        }

        if (is_singular('product')) {
            $can_render = 1;
        }

        if (is_tax('product_cat')) {
            $can_render = 1;
        }

        if (is_tax('product_tag')) {
            $can_render = 1;
        }

        if (!$can_render) {
            add_filter('wpseo_json_ld_output', '__return_false');
        }
    }
}

Webafra_Store::ins();
