<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Theme_Customize
{
    public static $ins = null;

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }

        return self::$ins;
    }

    public function __construct()
    {
        add_action('customize_register', [$this, 'customize_register']);
    }

    public function sections(): array
    {
        return [
            'webafra-store-main' => [
                'title' => __('Theme: Main', 'webafra-store'),
                'priority' => 1
            ],
            'webafra-store-typography' => [
                'title' => __('Theme: Typography', 'webafra-store'),
                'priority' => 2
            ],
            'webafra-store-colors' => [
                'title' => __('Theme: Colors', 'webafra-store'),
                'priority' => 3
            ],
            'webafra-store-shop' => [
                'title' => __('Theme: Shop', 'webafra-store'),
                'priority' => 4
            ],
            'webafra-store-single-product' => [
                'title' => __('Theme: Single product', 'webafra-store'),
                'priority' => 5
            ],
            'webafra-store-header' => [
                'title' => __('Theme: Header', 'webafra-store'),
                'priority' => 6
            ],
            'webafra-store-footer' => [
                'title' => __('Theme: Footer', 'webafra-store'),
                'priority' => 7
            ],
            'webafra-store-socials' => [
                'title' => __('Theme: Socials', 'webafra-store'),
                'priority' => 8
            ],
        ];
    }

    public function settings(): array
    {
        $socials_items_default = ws_get_socials_items_default();
        $footer_services_items_default = ws_get_footer_services_items_default();

        return [
            // Main:
            'enable-site-loading' => [
                'label' => __('Enable site loading', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-main',
            ],
            'site-loading-header' => [
                'label' => __('Site loading header', 'webafra-store'),
                'default' => 'spinning_icon',
                'type' => 'select',
                'choices' => [
                    'spinning_icon' => __('Spinning icon', 'webafra-store'),
                    'logo' => __('Logo', 'webafra-store'),
                ],
                'section' => 'webafra-store-main',
            ],
            'site-loading-text' => [
                'label' => __('Site loading text', 'webafra-store'),
                'default' => '',
                'type' => 'text',
                'section' => 'webafra-store-main'
            ],
            'theme-breadcrumb' => [
                'label' => __('Theme breadcrumb', 'webafra-store'),
                'default' => 'theme',
                'type' => 'select',
                'choices' => [
                    'theme' => __('Theme', 'webafra-store'),
                    'yoast' => __('Yoast', 'webafra-store'),
                ],
                'section' => 'webafra-store-main',
            ],
            'theme-container' => [
                'label' => __('Container', 'webafra-store'),
                'default' => 'container',
                'type' => 'select',
                'choices' => [
                    'container' => __('Container', 'webafra-store'),
                    'container-fluid' => __('Container (Fluid)', 'webafra-store'),
                    'full-width' => __('Full width', 'webafra-store'),
                ],
                'section' => 'webafra-store-main',
            ],
            'disable-wp-sitemap' => [
                'label' => __('Disable wp sitemap', 'webafra-store'),
                'default' => 0,
                'type' => 'checkbox',
                'section' => 'webafra-store-main',
            ],

            // Typography:
            'theme-font-family' => [
                'label' => __('Font family', 'webafra-store'),
                'default' => 'dana',
                'type' => 'select',
                'choices' => [
                    'dana' => 'Dana',
                    'dana-fanum' => 'Dana (fanum)',
                    'Kalameh' => 'Kalameh',
                    'IRANSansX' => 'IRANSansX',
                ],
                'section' => 'webafra-store-typography',
            ],

            // Colors:
            'theme-color-primary' => [
                'label' => __('Primary', 'webafra-store'),
                'default' => '#36CDDF',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-secondary' => [
                'label' => __('Secondary', 'webafra-store'),
                'default' => '#FE504F',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-primary-menu' => [
                'label' => __('Primary menu', 'webafra-store'),
                'default' => '#36CDDF',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-primary-menu-hover' => [
                'label' => __('Primary menu link (hover & active)', 'webafra-store'),
                'default' => '#1EABBB',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-body' => [
                'label' => __('Body', 'webafra-store'),
                'default' => '#F6F6F6',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-text' => [
                'label' => __('Text', 'webafra-store'),
                'default' => '#464646',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-header' => [
                'label' => __('Header', 'webafra-store'),
                'default' => '#F6F6F6',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-footer-service' => [
                'label' => __('Footer service', 'webafra-store'),
                'default' => '#929292',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-footer' => [
                'label' => __('Footer', 'webafra-store'),
                'default' => '#FFFFFF',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'theme-color-copyright' => [
                'label' => __('Copyright', 'webafra-store'),
                'default' => '#929292',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'single-product-contact-button-text-color' => [
                'label' => __('Single product contact button text', 'webafra-store'),
                'default' => '#ffffff',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'single-product-contact-button-color' => [
                'label' => __('Single product contact button', 'webafra-store'),
                'default' => '#36CDDF',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'footer-mobile-background-color' => [
                'label' => __('Footer mobile background', 'webafra-store'),
                'default' => '#ffffff',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'footer-mobile-color' => [
                'label' => __('Footer mobile', 'webafra-store'),
                'default' => '#555555',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],
            'header-announcement-background-color' => [
                'label' => __('Announcement background', 'webafra-store'),
                'default' => '#273238',
                'type' => 'color',
                'section' => 'webafra-store-colors',
            ],

            // Shop:
            'shop-product-loop-layout' => [
                'label' => __('Product layout', 'webafra-store'),
                'default' => 'one',
                'type' => 'select',
                'choices' => [
                    'one' => __('One', 'webafra-store'),
                    'two' => __('Two', 'webafra-store'),
                ],
                'section' => 'webafra-store-shop',
            ],
            'shop-address' => [
                'label' => __('Address', 'webafra-store'),
                'default' => ws_get_shop_address_default(),
                'type' => 'textarea',
                'section' => 'webafra-store-shop'
            ],
            'shop-phone-numbers' => [
                'label' => __('Phone numbers', 'webafra-store'),
                'default' => ws_get_shop_phone_numbers_default(),
                'type' => 'textarea',
                'section' => 'webafra-store-shop'
            ],
            'shop-brand-taxonomy' => [
                'label' => __('Brand taxonomy', 'webafra-store'),
                'default' => 'pa_brand',
                'type' => 'text',
                'section' => 'webafra-store-shop'
            ],
            'shop-product-offer-end-date-key' => [
                'label' => __('Product offer end date key', 'webafra-store'),
                'default' => '_woo_product_offerslider_timer', // _sale_price_dates_to
                'type' => 'text',
                'section' => 'webafra-store-shop'
            ],
            'enable-archive-sub-categories' => [
                'label' => __('Enable sub categories on archive page', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-shop',
            ],
            'archive-sub-categories-location' => [
                'label' => __('Sub categories location', 'webafra-store'),
                'default' => 'under_sorting',
                'type' => 'select',
                'choices' => [
                    'under_breadcrumb' => __('Under breadcrumb', 'webafra-store'),
                    'under_sorting' => __('Under sorting', 'webafra-store'),
                ],
                'section' => 'webafra-store-shop',
            ],
            'enable-archive-sub-categories-thumbnails' => [
                'label' => __('Enable sub categories thumbnails', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-shop',
            ],
            'archive-sub-categories-thumbnails-location' => [
                'label' => __('Sub categories thumbnail location', 'webafra-store'),
                'default' => 'right',
                'type' => 'select',
                'choices' => [
                    'right' => __('Right', 'webafra-store'),
                    'top' => __('Top', 'webafra-store'),
                ],
                'section' => 'webafra-store-shop',
            ],
            'show-price-discount-percentage' => [
                'label' => __('Show sale price discount percentage', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-shop',
            ],
            'show-cart-page-cross-sell' => [
                'label' => __('Show cross sell in cart page', 'webafra-store'),
                'default' => 0,
                'type' => 'checkbox',
                'section' => 'webafra-store-shop',
            ],

            // Single product:
            'single-product-layout' => [
                'label' => __('Layout', 'webafra-store'),
                'default' => 'one',
                'type' => 'select',
                'choices' => [
                    'one' => __('One', 'webafra-store'),
                    'two' => __('Two', 'webafra-store'),
                ],
                'section' => 'webafra-store-single-product',
            ],
            'enable-single-product-contact-button' => [
                'label' => __('Enable contact button', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-single-product',
            ],
            'single-product-contact-button-text' => [
                'label' => __('Contact button text', 'webafra-store'),
                'default' => __('One call to buy', 'webafra-store') . ' 021123456789',
                'type' => 'text',
                'section' => 'webafra-store-single-product',
            ],
            'single-product-contact-button-url' => [
                'label' => __('Contact button url', 'webafra-store'),
                'default' => '#',
                'type' => 'url',
                'section' => 'webafra-store-single-product',
            ],
            'single-product-info' => [
                'label' => __('Info', 'webafra-store'),
                'default' => __('All the products of this store are original and branded and are offered with a money back guarantee. The text displayed in all products can be changed from the skin settings section', 'webafra-store'),
                'type' => 'textarea',
                'section' => 'webafra-store-single-product'
            ],

            // Header:
            'header-top-enable' => [
                'label' => __('Enable top header', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],

            'header-announcement-enable' => [
                'label' => __('Enable announcement', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-show-text-icon' => [
                'label' => __('Show announcement text icon', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-text' => [
                'label' => __('Announcement text', 'webafra-store'),
                'default' => __('Enter the text of your announcement', 'webafra-store'),
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-text-align' => [
                'label' => __('Announcement text align', 'webafra-store'),
                'default' => 'right',
                'type' => 'select',
                'choices' => [
                    'right' => __('Right', 'webafra-store'),
                    'center' => __('Center', 'webafra-store'),
                    'left' => __('Left', 'webafra-store'),
                ],
                'section' => 'webafra-store-header',
            ],
            'header-announcement-more-text' => [
                'label' => __('Announcement more text', 'webafra-store'),
                'default' => __('Read more', 'webafra-store'),
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-more-link' => [
                'label' => __('Announcement more link', 'webafra-store'),
                'default' => '',
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-closeable' => [
                'label' => __('Closeable announcement', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-background-image' => [
                'label' => __('Announcement background image', 'webafra-store'),
                'default' => '',
                'type' => 'image',
                'section' => 'webafra-store-header',
            ],
            'header-announcement-background-size' => [
                'label' => __('Announcement background size', 'webafra-store'),
                'default' => 'cover',
                'type' => 'select',
                'choices' => [
                    'auto' => __('Auto', 'webafra-store'),
                    'contain' => __('Contain', 'webafra-store'),
                    'cover' => __('Cover', 'webafra-store'),
                ],
                'section' => 'webafra-store-header',
            ],

            'header-theme' => [
                'label' => __('Theme', 'webafra-store'),
                'default' => 'one',
                'type' => 'select',
                'choices' => [
                    'one' => __('One', 'webafra-store'),
                    'two' => __('Two', 'webafra-store'),
                ],
                'section' => 'webafra-store-header',
            ],
            'header-search-form' => [
                'label' => __('Search form', 'webafra-store'),
                'default' => 'theme',
                'type' => 'select',
                'choices' => [
                    'theme' => __('Theme', 'webafra-store'),
                    'shortcode' => __('Shortcode', 'webafra-store'),
                ],
                'section' => 'webafra-store-header',
            ],
            'header-search-form-shortcode' => [
                'label' => __('Search form shortcode', 'webafra-store'),
                'default' => '',
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'header-search-form-max-width' => [
                'label' => __('Search form max width', 'webafra-store'),
                'description' => __('in PX', 'webafra-store'),
                'default' => '600',
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'sidemenu-logo' => [
                'label' => __('Sidemenu logo', 'webafra-store'),
                'default' => '',
                'type' => 'image',
                'section' => 'webafra-store-header',
            ],
            'sidemenu-search-form' => [
                'label' => __('Sidemenu search form', 'webafra-store'),
                'default' => 'theme',
                'type' => 'select',
                'choices' => [
                    'theme' => __('Theme', 'webafra-store'),
                    'shortcode' => __('Shortcode', 'webafra-store'),
                ],
                'section' => 'webafra-store-header',
            ],
            'sidemenu-search-form-shortcode' => [
                'label' => __('Sidemenu search form shortcode', 'webafra-store'),
                'default' => '',
                'type' => 'text',
                'section' => 'webafra-store-header',
            ],
            'header-nav-menu-phone-numbers' => [
                'label' => __('Phone numbers', 'webafra-store'),
                'default' => '02188814075-7',
                'type' => 'textarea',
                'section' => 'webafra-store-header'
            ],
            'header-nav-menu-show-tracking-btn' => [
                'label' => __('Show tracking button on nav menu', 'webafra-store'),
                'default' => 0,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-nav-menu-full-width' => [
                'label' => __('Full width nav menu', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-nav-sticky' => [
                'label' => __('Sticky nav', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-header',
            ],
            'header-script' => [
                'label' => __('Header script', 'webafra-store'),
                'default' => '',
                'type' => 'code',
                'section' => 'webafra-store-header',
            ],

            'footer-mobile' => [
                'label' => __('Show mobile footer', 'webafra-store'),
                'default' => 1,
                'type' => 'checkbox',
                'section' => 'webafra-store-footer',
            ],

            'enable-mobile-megamenu' => [
                'label' => __('Enable mobile megamenu', 'webafra-store'),
                'default' => 0,
                'type' => 'checkbox',
                'section' => 'webafra-store-footer',
            ],

            // Footer Services:
            'footer-services-one-image' => [
                'label' => __('Footer services (One) - Image', 'webafra-store'),
                'default' => $footer_services_items_default['one']['image'],
                'type' => 'image',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-one-text' => [
                'label' => __('Footer services (One) - Text', 'webafra-store'),
                'default' => $footer_services_items_default['one']['text'],
                'type' => 'text',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-two-image' => [
                'label' => __('Footer services (Two) - Image', 'webafra-store'),
                'default' => $footer_services_items_default['two']['image'],
                'type' => 'image',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-two-text' => [
                'label' => __('Footer services (Two) - Text', 'webafra-store'),
                'default' => $footer_services_items_default['two']['text'],
                'type' => 'text',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-three-image' => [
                'label' => __('Footer services (Three) - Image', 'webafra-store'),
                'default' => $footer_services_items_default['three']['image'],
                'type' => 'image',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-three-text' => [
                'label' => __('Footer services (Three) - Text', 'webafra-store'),
                'default' => $footer_services_items_default['three']['text'],
                'type' => 'text',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-four-image' => [
                'label' => __('Footer services (Four) - Image', 'webafra-store'),
                'default' => $footer_services_items_default['four']['image'],
                'type' => 'image',
                'section' => 'webafra-store-footer',
            ],
            'footer-services-four-text' => [
                'label' => __('Footer services (Four) - Text', 'webafra-store'),
                'default' => $footer_services_items_default['four']['text'],
                'type' => 'text',
                'section' => 'webafra-store-footer',
            ],

            // Map:
            'footer-map' => [
                'label' => __('Map', 'webafra-store'),
                'default' => '',
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],

            // Namad:
            'footer-namad-one' => [
                'label' => __('Namad (One)', 'webafra-store'),
                'default' => '',
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],
            'footer-namad-two' => [
                'label' => __('Namad (Two)', 'webafra-store'),
                'default' => '',
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],
            'footer-namad-three' => [
                'label' => __('Namad (Three)', 'webafra-store'),
                'default' => '',
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],

            'footer-brands' => [
                'label' => __('Brands', 'webafra-store'),
                'default' => '',
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],

            // Copyright:
            'footer-copyright' => [
                'label' => __('Copyright', 'webafra-store'),
                'default' => ws_get_footer_copyright_default(),
                'type' => 'textarea',
                'section' => 'webafra-store-footer'
            ],

            'footer-script' => [
                'label' => __('Footer script', 'webafra-store'),
                'default' => '',
                'type' => 'code',
                'section' => 'webafra-store-footer',
            ],

            // Socials:
            'socials-one-image' => [
                'label' => __('Social (One) - Image', 'webafra-store'),
                'default' => $socials_items_default['one']['image'],
                'type' => 'image',
                'section' => 'webafra-store-socials',
            ],
            'socials-one-text' => [
                'label' => __('Social (One) - Text', 'webafra-store'),
                'default' => $socials_items_default['two']['text'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-one-link' => [
                'label' => __('Social (One) - Link', 'webafra-store'),
                'default' => $socials_items_default['two']['link'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-two-image' => [
                'label' => __('Social (Two) - Image', 'webafra-store'),
                'default' => $socials_items_default['two']['image'],
                'type' => 'image',
                'section' => 'webafra-store-socials',
            ],
            'socials-two-text' => [
                'label' => __('Social (Two) - Text', 'webafra-store'),
                'default' => $socials_items_default['two']['text'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-two-link' => [
                'label' => __('Social (Two) - Link', 'webafra-store'),
                'default' => $socials_items_default['two']['link'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-three-image' => [
                'label' => __('Social (Three) - Image', 'webafra-store'),
                'default' => $socials_items_default['three']['image'],
                'type' => 'image',
                'section' => 'webafra-store-socials',
            ],
            'socials-three-text' => [
                'label' => __('Social (Three) - Text', 'webafra-store'),
                'default' => $socials_items_default['three']['text'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-three-link' => [
                'label' => __('Social (Three) - Link', 'webafra-store'),
                'default' => $socials_items_default['three']['link'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
            'socials-four-image' => [
                'label' => __('Social (Four) - Image', 'webafra-store'),
                'default' => $socials_items_default['four']['image'],
                'type' => 'image',
                'section' => 'webafra-store-socials',
            ],
            'socials-four-text' => [
                'label' => __('Social (Four) - Text', 'webafra-store'),
                'default' => $socials_items_default['four']['text'],
                'type' => 'text',
                'section' => 'webafra-Four-socials',
            ],
            'socials-four-link' => [
                'label' => __('Social (Four) - Link', 'webafra-store'),
                'default' => $socials_items_default['four']['link'],
                'type' => 'text',
                'section' => 'webafra-store-socials',
            ],
        ];
    }

    public function customize_register($wp_customize)
    {
        foreach ($this->sections() as $key => $args) {
            $wp_customize->add_section($key, [
                'title' => $args['title'],
                'priority' => $args['priority']
            ]);
        }

        foreach ($this->settings() as $key => $args) {
            $wp_customize->add_setting($key, [
                'default' => $args['default']
            ]);

            switch ($args['type']) {
                case 'select':
                case 'radio':
                case 'checkbox':
                    $wp_customize->add_control(
                        new WP_Customize_Control($wp_customize, $key, [
                            'label' => $args['label'],
                            'description' => !empty($args['description']) ? $args['description'] : '',
                            'section' => $args['section'],
                            'type' => $args['type'],
                            'choices' => !empty($args['choices']) ? $args['choices'] : [],
                        ])
                    );
                    break;

                case 'text':
                case 'url':
                case 'range':
                    $wp_customize->add_control($key, [
                        'label' => $args['label'],
                        'description' => !empty($args['description']) ? $args['description'] : '',
                        'section' => $args['section']
                    ]);
                    break;

                case 'color':
                    $wp_customize->add_control(
                        new WP_Customize_Color_Control($wp_customize, $key, [
                            'label' => $args['label'],
                            'description' => !empty($args['description']) ? $args['description'] : '',
                            'section' => $args['section']
                        ])
                    );
                    break;

                case 'image':
                    $wp_customize->add_control(
                        new WP_Customize_Image_Control($wp_customize, $key, [
                            'label' => $args['label'],
                            'description' => !empty($args['description']) ? $args['description'] : '',
                            'section' => $args['section']
                        ])
                    );
                    break;

                case 'code':
                    $wp_customize->add_control(
                        new WP_Customize_Code_Editor_Control($wp_customize, $key, [
                            'label' => $args['label'],
                            'description' => !empty($args['description']) ? $args['description'] : '',
                            'section' => $args['section'],
                        ])
                    );
                    break;

                case 'textarea':
                    $wp_customize->add_control($key, [
                        'label' => $args['label'],
                        'description' => !empty($args['description']) ? $args['description'] : '',
                        'section' => $args['section'],
                        'type' => 'textarea'
                    ]);
                    break;
            }
        }
    }
}

Webafra_Store_Theme_Customize::ins();
