<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

if (!function_exists('ws_get_content_limit')) {
    function ws_get_content_limit($content, $limit, $strip_tags = false)
    {
        if ($strip_tags) {
            $content = strip_tags($content);
        }

        return mb_strlen($content) > $limit ? mb_substr($content, 0, $limit - 1) . '...' : $content;
    }
}

if (!function_exists('ws_wc_get_current_user_orders_count')) {
    function ws_wc_get_current_user_orders_count($status = '')
    {
        if (!$user_id = get_current_user_id()) {
            return false;
        }

        $args = [
            'customer' => $user_id
        ];

        if (!empty($status)) {
            $args['status'] = 'wc-' . $status;
        }

        $orders = wc_get_orders($args);

        return count($orders);
    }
}

if (!function_exists('ws_get_socials_items_default')) {
    function ws_get_socials_items_default(): array
    {
        return [
            'one' => [
                'image' => get_template_directory_uri() . '/assets/images/instagram.webp',
                'text' => 'اینستاگرام',
                'link' => 'https://www.instagram.com/kouroshsportt/',
            ],
            'two' => [
                'image' => get_template_directory_uri() . '/assets/images/aparat.png',
                'text' => 'آپارت',
                'link' => 'https://www.aparat.com/kouroshsport.com',
            ],
            'three' => [
                'image' => get_template_directory_uri() . '/assets/images/pinterest.webp',
                'text' => 'پیترست',
                'link' => 'https://www.pinterest.com/kouroshsportt/',
            ],
            'four' => [
                'image' => get_template_directory_uri() . '/assets/images/facebook.webp',
                'text' => 'فیسبوک',
                'link' => 'https://www.facebook.com/kouroshsportt/',
            ],
        ];
    }
}

if (!function_exists('ws_get_footer_services_items_default')) {
    function ws_get_footer_services_items_default(): array
    {
        return [
            'one' => [
                'image' => get_template_directory_uri() . '/assets/images/svgs/guaranty.svg',
                'text' => 'ضمانت نامه معتبر محصولات کورش اسپرت',
            ],
            'two' => [
                'image' => get_template_directory_uri() . '/assets/images/svgs/sale-sadvisor.svg',
                'text' => 'پاسخگویی و مشاوره تلفنی همه روزه 24 ساعته',
            ],
            'three' => [
                'image' => get_template_directory_uri() . '/assets/images/svgs/fast-and-free-delivery.svg',
                'text' => 'حمل، نصب، آموزش و تحویل رایگان',
            ],
            'four' => [
                'image' => get_template_directory_uri() . '/assets/images/svgs/easy-and-safe-pay.svg',
                'text' => 'پرداخت در زمان تحویل با کورش اسپرت',
            ],
        ];
    }
}

if (!function_exists('ws_get_footer_copyright_default')) {
    function ws_get_footer_copyright_default(): string
    {
        return '<a target="_blank" href="https://webafra.com">طراحی سایت</a> توسط: <a target="_blank" href="https://webafra.com">شرکت طراحی سایت وب افرا</a>';
    }
}

if (!function_exists('ws_get_shop_address_default')) {
    function ws_get_shop_address_default(): string
    {
        return 'آدرس فروشگاه: تهران، میدان هفت تیر، ابتدای خیابان قائم مقام، نبش کوچه سام، پلاک 17';
    }
}

if (!function_exists('ws_get_shop_phone_numbers_default')) {
    function ws_get_shop_phone_numbers_default(): string
    {
        return '02188814075-7|09126771344';
    }
}

if (!function_exists('ws_wc_display_product_loop_color_attributes')) {
    function ws_wc_display_product_loop_color_attributes($product, $taxonomy)
    {
        $colors = wc_get_product_terms($product->get_id(), $taxonomy);

        if (empty($colors)) {
            return false;
        }

        ob_start();

        echo '<ul class="product-colorAttrs">';

        foreach ($colors as $color) {
            $attribute_color = get_term_meta($color->term_id, 'product_attribute_color', true);

            vprintf(
                '<li><a title="%s" href="%s"><span style="background-color:%s;"></span></a></li>',
                [
                    $color->name,
                    get_term_link($color->term_id, $taxonomy),
                    $attribute_color,
                ]
            );
        }

        echo '</ul>';

        return ob_get_clean();
    }
}

if (!function_exists('ws_wc_order_get_link')) {
    function ws_wc_order_get_link($order_type)
    {
        $base_link = ws_wc_shop_page_link(true);
        $link = remove_query_arg('orderby', $base_link);

        if ($order_type != 'menu_order') {
            $link = add_query_arg('orderby', $order_type, $link);
            $link = str_replace('%2C', ',', $link);
        }

        return $link;
    }
}

if (!function_exists('ws_wc_shop_page_link')) {
    function ws_wc_shop_page_link($keep_query = false, $taxonomy = '')
    {
        // Base Link decided by current page
        $link = '';

        if (is_post_type_archive('product') || is_page(wc_get_page_id('shop')) || is_shop()) {
            $link = get_permalink(wc_get_page_id('shop'));
        } elseif (is_product_category()) {
            $link = get_term_link(get_query_var('product_cat'), 'product_cat');
        } elseif (is_product_tag()) {
            $link = get_term_link(get_query_var('product_tag'), 'product_tag');
        } elseif (get_queried_object()) {
            $queried_object = get_queried_object();

            if (property_exists($queried_object, 'taxonomy')) {
                $link = get_term_link($queried_object->slug, $queried_object->taxonomy);
            }
        }

        if ($keep_query) {

            // Min/Max
            if (isset($_GET['min_price'])) {
                $link = add_query_arg('min_price', wc_clean($_GET['min_price']), $link);
            }

            if (isset($_GET['max_price'])) {
                $link = add_query_arg('max_price', wc_clean($_GET['max_price']), $link);
            }

            // Orderby
            if (isset($_GET['orderby'])) {
                $link = add_query_arg('orderby', wc_clean($_GET['orderby']), $link);
            }

            if (isset($_GET['stock_status'])) {
                $link = add_query_arg('stock_status', wc_clean($_GET['stock_status']), $link);
            }

            if (isset($_GET['product_brand'])) {
                $link = add_query_arg('product_brand', wc_clean($_GET['product_brand']), $link);
            }

            if (isset($_GET['per_page'])) {
                $link = add_query_arg('per_page', wc_clean($_GET['per_page']), $link);
            }

            /**
             * Search Arg.
             * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
             */
            if (get_search_query()) {
                $link = add_query_arg('s', rawurlencode(wp_specialchars_decode(get_search_query())), $link);
            }

            // Post Type Arg
            if (isset($_GET['post_type'])) {
                $link = add_query_arg('post_type', wc_clean(wp_unslash($_GET['post_type'])), $link);

                // Prevent post type and page id when pretty permalinks are disabled.
                if (is_shop()) {
                    $link = remove_query_arg('page_id', $link);
                }
            }

            // Min Rating Arg
            if (isset($_GET['min_rating'])) {
                $link = add_query_arg('min_rating', wc_clean($_GET['min_rating']), $link);
            }

            // All current filters
            if ($_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes()) {
                foreach ($_chosen_attributes as $name => $data) {
                    if ($name === $taxonomy) {
                        continue;
                    }
                    $filter_name = sanitize_title(str_replace('pa_', '', $name));
                    if (! empty($data['terms'])) {
                        $link = add_query_arg('filter_' . $filter_name, implode(',', $data['terms']), $link);
                    }
                    if ('or' == $data['query_type']) {
                        $link = add_query_arg('query_type_' . $filter_name, 'or', $link);
                    }
                }
            }
        }

        if (is_string($link)) {
            return $link;
        } else {
            return '';
        }
    }
}

if (!function_exists('ws_theme_custom_breadcrumb')) {
    function ws_theme_custom_breadcrumb()
    {
        $separator = '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>';

        echo '<nav class="theme-breadcrumb" aria-label="Breadcrumb">';

        echo '<a title="' . __('Home', 'webafra-store') . '" href="' . home_url() . '" rel="nofollow">' . __('Home', 'webafra-store') . '</a>';

        if (is_category() || is_archive() || is_single()) {
            echo $separator;

            if (get_post_type() && get_post_type() == 'aiovg_videos') {
                echo '<a href="' . get_site_url() . '/ویدئو/" title="ویدئو">ویدئو</a>';
            } else {
                global $wp;
                echo '<a href="' . home_url($wp->request) . '" title="' . get_the_archive_title() . '">' . get_the_archive_title() . '</a>';
            }

            if (is_single()) {
                echo $separator;
                the_title();
            }
        } elseif (is_page()) {
            echo $separator;
            echo the_title();
        } elseif (is_search()) {
            echo the_search_query();
        }
        echo '</nav>';
    }
}

if (!function_exists('ws_theme_breadcrumb')) {
    function ws_theme_breadcrumb()
    {
        if (get_theme_mod('theme-breadcrumb', 'theme') == 'yoast' && function_exists('yoast_breadcrumb')) {
            add_filter('wpseo_breadcrumb_single_link', function ($link, $breadcrumb) {
                if (strpos($link, 'breadcrumb_last') !== false) {
                    if (is_single() || is_page()) {
                        global $post;
                        $link = '<a href="' . get_permalink($post) . '">' . get_the_title($post)  . '</a>';
                    } elseif (is_category() || is_archive() || (function_exists('is_shop') && is_shop())) {
                        global $wp;
                        $link = '<a href="' . home_url($wp->request) . '" title="' . get_the_archive_title() . '">' . get_the_archive_title() . '</a>';
                    }
                }
                return $link;
            }, 99, 2);

            add_filter('wpseo_breadcrumb_separator', function ($separator) {
                $separator = '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>';
                return $separator;
            }, 99);

            yoast_breadcrumb('<nav class="theme-breadcrumb yoast" aria-label="Breadcrumb">', '</nav>');
        } else {
            ws_theme_custom_breadcrumb();
        }
    }
}

if (!function_exists('ws_pagination')) {
    function ws_pagination($total = null)
    {
        global $wp_query;

        $page_total = !is_null($total) ? $total : $wp_query->max_num_pages;
        $big = 12345678;
        $page_format = paginate_links([
            'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $page_total,
            'type' => 'array',
            'prev_text' => '→',
            'next_text' => '←'
        ]);

        if (is_array($page_format)) {
            echo '<ul class="page-numbers">';

            foreach ($page_format as $page) {
                echo '<li class="item">' . $page . '</li>';
            }

            echo '</ul>';
        }
    }
}

if (!function_exists('ws_current_query_max_pages_count')) {
    function ws_current_query_max_pages_count()
    {
        global $wp_query;

        return $wp_query->max_num_pages;
    }
}

if (!function_exists('ws_get_on_sale_product_discount_percentage')) {
    function ws_get_on_sale_product_discount_percentage($product)
    {
        if ($product->is_type('variable')) {
            $percentages = array();

            // Get all variation prices
            $prices = $product->get_variation_prices();

            // Loop through variation prices
            foreach ($prices['price'] as $key => $price) {
                // Only on sale variations
                if ($prices['regular_price'][$key] !== $price) {
                    // Calculate and set in the array the percentage for each variation on sale
                    $percentages[] = round(100 - (floatval($prices['sale_price'][$key]) / floatval($prices['regular_price'][$key]) * 100));
                }
            }

            // We keep the highest value
            $percentage = max($percentages) . '%';
        } elseif ($product->is_type('grouped')) {
            $percentages = array();

            // Get all variation prices
            $children_ids = $product->get_children();

            // Loop through variation prices
            foreach ($children_ids as $child_id) {
                $child_product = wc_get_product($child_id);

                $regular_price = (float) $child_product->get_regular_price();
                $sale_price = (float) $child_product->get_sale_price();

                if ($sale_price != 0 || !empty($sale_price)) {
                    // Calculate and set in the array the percentage for each child on sale
                    $percentages[] = round(100 - ($sale_price / $regular_price * 100));
                }
            }

            // We keep the highest value
            $percentage = max($percentages) . '%';
        } else {
            $regular_price = (float) $product->get_regular_price();
            $sale_price = (float) $product->get_sale_price();

            if ($sale_price != 0 || !empty($sale_price)) {
                $percentage = round(100 - ($sale_price / $regular_price * 100)) . '%';
            } else {
                return false;
            }
        }

        return $percentage;
    }
}

if (!function_exists('ws_get_thumbnail_placeholder')) {
    function ws_get_thumbnail_placeholder(): string
    {
        return get_template_directory_uri() . '/assets/images/thumbnail-placeholder.jpg';
    }
}

if (!function_exists('ws_get_post_primary_cat')) {
    function ws_get_post_primary_cat(int $post_id, string $taxonomy = 'category')
    {
        if (class_exists('WPSEO_Options')) {
            $primary_id = get_post_meta($post_id, '_yoast_wpseo_primary_' . $taxonomy, true);

            if (!empty($primary_id)) {
                $term = get_term($primary_id);

                if (!$term || is_wp_error($term)) {
                    return false;
                }

                return $term;
            }
        }

        $terms = get_the_terms($post_id, $taxonomy);

        if (!$terms || is_wp_error($terms)) {
            return false;
        }

        return reset($terms);
    }
}

if (function_exists('wccm_add_button')) {
    function ws_wccm_add_button(int $product_id = null)
    {
        if (is_null($product_id)) {
            $product_id = get_the_ID();
        }

        echo '<button aria-label="' . __('Wishlist', 'webafra-store') . '" onclick="ws_wishlist_toggle(this, ' . $product_id . ');" class="wccm-button button2 compare' . ((in_array($product_id, wccm_get_compare_list())) ? ' added' : '') . '"><i class="fal fa-random" aria-hidden="true"></i></button>';

        /* $classes = array('button2', 'compare');

        if (in_array($product_id, wccm_get_compare_list())) {
            $url = wccm_get_compare_link($product_id, 'remove-from-list');
            echo '<a href="', esc_url($url), '" class="wccm-button added ', implode(' ', $classes), '">', '<i class="fal fa-random" aria-hidden="true"></i>', '</a>';
        } else {
            $url = wccm_get_compare_link($product_id, 'add-to-list');
            echo '<a href="', esc_url($url), '" class="wccm-button ', implode(' ', $classes), '">', '<i class="fal fa-random" aria-hidden="true"></i>', '</a>';
        } */
    }
}

if (!function_exists('ws_get_related_posts')) {
    function ws_get_related_posts(int $post_id)
    {
        $query = [
            'post_type' => 'post',
            'post_status' => 'publish',
            'post__not_in' => [$post_id],
            'posts_per_page' => 12,
            'orderby' => 'rand',
            'order' => 'desc',
            'tax_query' => [
                'relation' => 'OR',
                [
                    'taxonomy' => 'post_tag',
                    'field' => 'id',
                    'terms' => array_map('intval', (array) wp_get_post_tags($post_id, ['fields' => 'ids'])),
                    'operator' => 'IN'
                ],
                [
                    'taxonomy' => 'category',
                    'field' => 'id',
                    'terms' => array_map('intval', (array) wp_get_post_categories($post_id, ['fields' => 'ids'])),
                    'operator' => 'IN'
                ]
            ]
        ];

        return new \WP_Query($query);
    }
}

if (!function_exists('ws_image_lazy_load_attr')) {
    function ws_image_lazy_load_attr()
    {
        return 'loading="lazy"';
    }
}

if (!function_exists('ws_get_thumbnail_sizes')) {
    function ws_get_thumbnail_sizes()
    {
        $thumbnails = [];

        if (function_exists('get_intermediate_image_sizes')) {
            foreach (get_intermediate_image_sizes() as $thumbnail) {
                $thumbnails[$thumbnail] = $thumbnail;
            }
        }

        $thumbnails['full'] = esc_html__('Full', 'webafra-store');
        $thumbnails['custom'] = esc_html__('Custom', 'webafra-store');

        return $thumbnails;
    }
}

if (!function_exists('ws_get_product_categories_by_parent')) {
    function ws_get_product_categories_by_parent(int $parent)
    {
        $query = [
            'taxonomy' => 'product_cat',
            'hide_empty' => 0,
            'number' => 0,
            'parent' => $parent,
        ];

        $terms = new WP_Term_Query($query);

        return $terms->get_terms();
    }
}

if (!function_exists('ws_get_megamenu_categories')) {
    function ws_get_megamenu_categories()
    {
        $query = [
            'taxonomy' => 'product_cat',
            'hide_empty' => 0,
            'number' => 0,
            'parent' => 0,
        ];

        $terms = new WP_Term_Query($query);

        return $terms->get_terms();
    }
}

if (!function_exists('ws_get_term_thumbnail_src')) {
    function ws_get_term_thumbnail_src(int $term_id, string $thumbnail_size = 'thumbnail')
    {
        $thumbnail_src = ws_get_thumbnail_placeholder();

        if ($thumbnail_id = get_term_meta($term_id, 'thumbnail_id', true)) {
            if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, $thumbnail_size)) {
                $thumbnail_src = $thumbnail_image[0];
            }
        }

        return $thumbnail_src;
    }
}
