<?php

use Elementor\Controls_Manager;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Elementor_Widget_Services extends Widget_Base
{
    public function get_name()
    {
        return 'webafra_store_elementor_services';
    }

    public function get_title()
    {
        return esc_html__('Services', 'webafra-store');
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_script_depends()
    {
        return [];
    }

    public function get_style_depends()
    {
        return [
            'webafra-store-services',
        ];
    }

    public function get_categories()
    {
        return ['webafra-store-widgets'];
    }

    protected function register_controls()
    {
        $items_repeater = new Repeater();

        $items_repeater->add_control('tab_icon', [
            'label' => esc_html__('Icon', 'webafra-store'),
            'type' => Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-shopping-cart',
                'library' => 'fa-solid',
            ],
        ]);

        $items_repeater->add_control('tab_label', [
            'label' => esc_html__('Label', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Default label', 'webafra-store'),
        ]);

        $items_repeater->add_control('tab_description', [
            'label' => esc_html__('Description', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Default description', 'webafra-store'),
        ]);

        $this->start_controls_section('services', [
            'label' => esc_html__('Services', 'webafra-store'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('items', [
            'label' => esc_html__('Services', 'webafra-store'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $items_repeater->get_controls(),
            'default' => [
                [
                    'tab_icon' => [
                        'value' => 'fas fa-credit-card',
                        'library' => 'fa-solid',
                    ],
                    'tab_label' => esc_html__('Price guarantee', 'webafra-store'),
                    'tab_description' => esc_html__('The best market price', 'webafra-store'),
                ],
                [
                    'tab_icon' => [
                        'value' => 'fas fa-headset',
                        'library' => 'fa-solid',
                    ],
                    'tab_label' => esc_html__('Excellent support', 'webafra-store'),
                    'tab_description' => esc_html__('24 hours, 7 days a week', 'webafra-store'),
                ],
                [
                    'tab_icon' => [
                        'value' => 'fas fa-history',
                        'library' => 'fa-solid',
                    ],
                    'tab_label' => esc_html__('Refund', 'webafra-store'),
                    'tab_description' => esc_html__('If not satisfied', 'webafra-store'),
                ],
                [
                    'tab_icon' => [
                        'value' => 'far fa-file-alt',
                        'library' => 'fa-regular',
                    ],
                    'tab_label' => esc_html__('Authenticity of goods', 'webafra-store'),
                    'tab_description' => esc_html__('One of the top brands', 'webafra-store'),
                ],
                [
                    'tab_icon' => [
                        'value' => 'fas fa-shipping-fast',
                        'library' => 'fa-solid',
                    ],
                    'tab_label' => esc_html__('Fast delivery', 'webafra-store'),
                    'tab_description' => esc_html__('in the shortest possible time', 'webafra-store'),
                ],
            ],
            'title_field' => '{{{ tab_label }}}',
        ]);

        $this->add_responsive_control('columns', [
            'type' => Controls_Manager::NUMBER,
            'label' => esc_html__('Columns', 'webafra-store'),
            'selectors' => [
                '{{WRAPPER}} .ws-services .service-tab' => 'min-width: calc((100% / {{VALUE}}) - ((({{VALUE}} - 1) / {{VALUE}}) * 15px));'
            ]
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>

        <div class="ws-services">
            <?php if ($settings['items']) : ?>
                <?php foreach ($settings['items'] as $item) : ?>
                    <div class="service-tab">
                        <div class="tab-icon">
                            <?php Icons_Manager::render_icon($item['tab_icon'], ['aria-hidden' => 'true']); ?>
                        </div>
                        <div class="tab-text">
                            <span class="tab-label"><?= $item['tab_label']; ?></span>
                            <span class="tab-desc"><?= $item['tab_description']; ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
<?php
    }
}
