<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Elementor_Widget_Product_Categories extends Widget_Base
{
    public function get_name()
    {
        return 'webafra_store_elementor_product_categories';
    }

    public function get_title()
    {
        return esc_html__('Product categories', 'webafra-store');
    }

    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    public function get_script_depends()
    {
        return [];
    }

    public function get_style_depends()
    {
        return [
            'webafra-store-product-categories',
        ];
    }

    public function get_categories()
    {
        return ['webafra-store-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section('query', [
            'label' => esc_html__('Query', 'webafra-store'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $categories = new WP_Term_Query([
            'taxonomy' => 'product_cat',
            'hide_empty' => 0,
            'number' => 0,
        ]);

        $categories_new = [];

        if (count($categories->get_terms())) {
            foreach (array_values($categories->get_terms()) as $cat) {
                $categories_new[$cat->term_id] = $cat->name;
            }
        }

        $this->add_control('include_category', [
            'label' => esc_html__('Include', 'webafra-store'),
            'type' => Controls_Manager::SELECT2,
            'label_block' => true,
            'multiple' => true,
            'options' => $categories_new,
            'default' => [],
        ]);

        $this->add_control('limit', [
            'label' => esc_html__('Limit', 'webafra-store'),
            'type' => Controls_Manager::NUMBER,
            'default' => 8,
        ]);

        $this->add_control('thumbnail_size', [
            'type' => Controls_Manager::SELECT,
            'label' => esc_html__('Thumbnail size', 'webafra-store'),
            'multiple' => false,
            'options' => ws_get_thumbnail_sizes(),
            'default' => 'woocommerce_thumbnail',
        ]);

        $this->add_control('thumbnail_size_custom_width', [
            'label' => esc_html__('Width', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'condition' => [
                'thumbnail_size' => 'custom'
            ]
        ]);

        $this->add_control('thumbnail_size_custom_height', [
            'label' => esc_html__('Height', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'condition' => [
                'thumbnail_size' => 'custom'
            ]
        ]);

        $this->add_control('show_count', [
            'label' => esc_html__('Show count', 'webafra-store'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'no',
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style', [
            'label' => esc_html__('Section', 'webafra-store'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('section_background_color', [
            'label' => esc_html__('Background color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->add_responsive_control('height', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Height', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories' => 'height: {{SIZE}}{{UNIT}};'
            ]
        ]);

        $this->add_responsive_control('border_radius', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Border radius', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_responsive_control('section_padding', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Padding', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(), [
            'name' => 'section_shadow',
            'selector' => '{{WRAPPER}} .ws-product-categories',
        ]);

        $this->add_responsive_control('section_columns', [
            'label' => esc_html__('Columns', 'webafra-store'),
            'type' => Controls_Manager::NUMBER,
            'default' => 4,
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop' => 'width: calc((100% / {{VALUE}}) - ((({{VALUE}} - 1) / {{VALUE}}) * 0px));'
            ]
        ]);

        $this->add_responsive_control('section_columns_gap', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Columns gap', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories' => 'gap: {{SIZE}}{{UNIT}};'
            ]
        ]);
        $this->end_controls_section();

        $this->start_controls_section('category_style', [
            'label' => esc_html__('Category', 'webafra-store'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_responsive_control('section_box_direction', [
            'label' => esc_html__('Direction', 'webafra-store'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'column',
            'options' => [
                'row' => esc_html__('Horizontal', 'webafra-store'),
                'column'  => esc_html__('Vertical', 'webafra-store'),
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'flex-direction: {{VALUE}};',
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title', 'webafra-store'),
            'name' => 'category_title_typography',
            'selector' => '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-title'
        ]);

        $this->add_control('category_title_color', [
            'label' => esc_html__('Title color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-title a' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_responsive_control('category_title', [
            'label' => esc_html__('Title alignment', 'webafra-store'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__('Left', 'webafra-store'),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__('Center', 'webafra-store'),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__('Right', 'webafra-store'),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'right',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-title' => 'text-align: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Count', 'webafra-store'),
            'name' => 'category_count_typography',
            'selector' => '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-details .count',
            'condition' => [
                'show_count' => 'yes'
            ]
        ]);

        $this->add_control('category_count_color', [
            'label' => esc_html__('Count color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-details .count' => 'color: {{VALUE}}',
            ],
            'condition' => [
                'show_count' => 'yes'
            ]
        ]);

        $this->add_responsive_control('category_gap', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Gap', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'gap: {{SIZE}}{{UNIT}};'
            ],
        ]);

        $this->add_responsive_control('category_image_width_size', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Image width', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail a img' => 'width: {{SIZE}}{{UNIT}};'
            ],
        ]);

        $this->add_responsive_control('category_image_height_size', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Image height', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail a img' => 'height: {{SIZE}}{{UNIT}};'
            ],
        ]);

        $this->add_responsive_control('category_image_border', [
            'type' => Controls_Manager::SELECT,
            'label' => esc_html__('Image border', 'webafra-store'),
            'options' => [
                'none' => esc_html__('None', 'webafra-store'),
                'solid' => esc_html__('Solid', 'webafra-store'),
                'dashed' => esc_html__('Dashed', 'webafra-store')
            ],
            'default' => 'none',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail' => 'border-style: {{VALUE}};',
            ]
        ]);

        $this->add_control('category_image_border_color', [
            'label' => esc_html__('Image border color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail' => 'border-color: {{VALUE}}',
            ],
            'condition' => [
                'category_image_border!' => 'none'
            ]
        ]);

        $this->add_responsive_control('category_image_border_width', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Image border width', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail' => 'border-top-width: {{TOP}}{{UNIT}}; border-right-width: {{RIGHT}}{{UNIT}}; border-left-width: {{LEFT}}{{UNIT}}; border-bottom-width: {{BOTTOM}}{{UNIT}};'
            ],
            'condition' => [
                'category_image_border!' => 'none'
            ]
        ]);

        $this->add_responsive_control('category_image_border_radius', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Image border radius', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_responsive_control('category_image_padding', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Image padding', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body .category-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_control('category_background_color', [
            'label' => esc_html__('Background color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->add_responsive_control('category_border', [
            'type' => Controls_Manager::SELECT,
            'label' => esc_html__('Border', 'webafra-store'),
            'options' => [
                'none' => esc_html__('None', 'webafra-store'),
                'solid' => esc_html__('Solid', 'webafra-store'),
                'dashed' => esc_html__('Dashed', 'webafra-store')
            ],
            'default' => 'none',
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'border-style: {{VALUE}};',
            ]
        ]);

        $this->add_control('category_border_color', [
            'label' => esc_html__('Border color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'border-color: {{VALUE}}',
            ],
            'condition' => [
                'category_border!' => 'none'
            ]
        ]);

        $this->add_responsive_control('category_border_width', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Border width', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'border-top-width: {{TOP}}{{UNIT}}; border-right-width: {{RIGHT}}{{UNIT}}; border-left-width: {{LEFT}}{{UNIT}}; border-bottom-width: {{BOTTOM}}{{UNIT}};'
            ],
            'condition' => [
                'category_border!' => 'none'
            ]
        ]);

        $this->add_responsive_control('category_border_radius', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Border radius', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_responsive_control('category_main_layer_border_radius', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Main layer border radius', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_responsive_control('category_margin', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Margin', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_responsive_control('category_padding', [
            'type' => Controls_Manager::DIMENSIONS,
            'label' => esc_html__('Padding', 'webafra-store'),
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .ws-product-categories .category-loop .loop-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '',
                'right' => '',
                'bottom' => '',
                'left' => '',
                'unit' => 'px',
                'isLinked' => true,
            ],
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(), [
            'name' => 'category_shadow',
            'selector' => '{{WRAPPER}} .ws-product-categories .category-loop',
        ]);

        $this->end_controls_section();
    }

    private function get_thumbnail_src(int $term_id, string $thumbnail_size = 'thumbnail')
    {
        $thumbnail_src = ws_get_thumbnail_placeholder();
        if ($thumbnail_id = get_term_meta($term_id, 'thumbnail_id', true)) {
            if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, $thumbnail_size)) {
                $thumbnail_src = $thumbnail_image[0];
            }
        }
        return $thumbnail_src;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $thumbnail_size = $settings['thumbnail_size'];

        if ($settings['thumbnail_size'] == 'custom' && (!empty($settings['thumbnail_size_custom_width']) && !empty($settings['thumbnail_size_custom_height']))) {
            $thumbnail_size = [
                $settings['thumbnail_size_custom_width'],
                $settings['thumbnail_size_custom_height']
            ];
        }

        $query = [
            'taxonomy' => 'product_cat',
            'hide_empty' => 0,
            'number' => !empty($settings['limit']) ? $settings['limit'] : 8,
            'meta_key' => '_term_order',
            'orderby' => 'meta_value_num',
            'order' => 'DESC'
        ];

        if (!empty($settings['include_category']) && is_array($settings['include_category'])) {
            $query['include'] = $settings['include_category'];
        }

        $categories = new WP_Term_Query($query);

        if (!empty($categories->get_terms())) {
            echo '<div class="ws-product-categories">';

            foreach ($categories->get_terms() as $term) {
                echo '<div class="category-loop">';

                echo '<div class="loop-body">';

                echo '<span class="halo-light"></span>';

                echo '<div class="category-thumbnail">';
                echo '<a href="' . esc_url(get_term_link($term->term_id)) . '" title="' . $term->name . '"><img src="' . $this->get_thumbnail_src($term->term_id, $thumbnail_size) . '" alt="' . $term->name . '" /></a>';
                echo '</div>';

                echo '<div class="category-details">';

                echo '<h3 class="category-title">';

                echo '<a href="' . esc_url(get_term_link($term->term_id)) . '" title="' . $term->name . '">';
                echo !empty($settings['title_limit']) ? ws_get_content_limit($term->name, 80, true) : $term->name;
                echo '</a>';

                echo '</h3>';

                if ($settings['show_count'] == 'yes') {
                    echo '<div class="count">' . $term->count . ' ' . __('Product', 'webafra-store') . '</div>';
                }

                echo '</div>';

                echo '</div>';

                echo '</div>';
            }

            echo '</div>';
        }
    }
}
