<?php

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Elementor_Widget_Featured_Products_Slider extends Widget_Base
{
    public function get_name()
    {
        return 'webafra_store_elementor_featured_products_slider';
    }

    public function get_title()
    {
        return esc_html__('Featured products slider', 'webafra-store');
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_script_depends()
    {
        return [
            'webafra-store-owl.carousel.min',
            'webafra-store-featured-products-slider.min',
        ];
    }

    public function get_style_depends()
    {
        return [
            'webafra-store-owl.carousel.min',
            'webafra-store-owl.theme.default.min',
            'webafra-store-featured-products-slider',
        ];
    }

    public function get_categories()
    {
        return ['webafra-store-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section('settings', [
            'label' => esc_html__('Settings', 'webafra-store'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('limit', [
            'label' => esc_html__('Limit', 'webafra-store'),
            'type' => Controls_Manager::NUMBER,
            'default' => 8,
        ]);

        $this->end_controls_section();

        $this->start_controls_section('box_style', [
            'label' => esc_html__('Box', 'webafra-store'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('color', [
            'label' => esc_html__('Color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider' => 'color: {{VALUE}}',
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .product-description' => 'color: {{VALUE}}',
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .countDown-title' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('background_color', [
            'label' => esc_html__('Background color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->add_responsive_control('height', [
            'type' => Controls_Manager::SLIDER,
            'label' => esc_html__('Height', 'webafra-store'),
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 2000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'default' => [
                'unit' => 'px',
                'size' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider' => 'height: {{SIZE}}{{UNIT}};'
            ]
        ]);

        $this->end_controls_section();

        $this->start_controls_section('product_style', [
            'label' => esc_html__('Product', 'webafra-store'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('price', [
            'label' => esc_html__('Price', 'webafra-store'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);

        $this->add_control('regular_price_color', [
            'label' => esc_html__('Regular price color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .regular-price' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('onsale_price_color', [
            'label' => esc_html__('On sale price color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .sale-price' => 'color: {{VALUE}}',
            ],
        ]);

        $this->start_controls_tabs('colors_tabs');

        $this->start_controls_tab('colors_normal_tab', [
            'label' => esc_html__('Normal', 'webafra-store'),
        ]);

        $this->add_control('link_color', [
            'label' => esc_html__('Link color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .entry-title a' => 'color: {{VALUE}}',
            ],
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab('colors_hover_tab', [
            'label' => esc_html__('Hover', 'webafra-store'),
        ]);

        $this->add_control('link_hover_color', [
            'label' => esc_html__('Link color', 'webafra-store'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ws-featured-products-slider .slider-wrapper .featured-product .product-details .entry-title a:hover' => 'color: {{VALUE}}',
            ],
        ]);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $featured_args = [
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => !empty($settings['limit']) ? $settings['limit'] : 8,
            'tax_query' => [
                [
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => 'featured',
                ],
            ],
        ];

        $featured_query = new WP_Query($featured_args);

        if ($featured_query->have_posts()): ?>
            <div class="ws-featured-products-slider">
                <div id="webafra_store_elementor_featured_products_slider-<?= $this->get_id(); ?>" class="slider-wrapper owl-carousel owl-theme">
                    <?php while ($featured_query->have_posts()): $featured_query->the_post(); ?>
                        <?php $product = wc_get_product(get_the_ID()); ?>
                        <div class="featured-product product-type-<?= $product->get_type(); ?><?= $product->is_on_sale() ? ' on-sale' : ''; ?>">
                            <div class="product-details">
                                <h3 class="entry-title">
                                    <a title="<?= get_the_title(); ?>" href="<?= esc_url(get_permalink()); ?>" rel="bookmark"><?= get_the_title(); ?></a>
                                </h3>

                                <?php $regular_price = get_post_meta(get_the_ID(), '_regular_price', true); ?>
                                <p class="regular-price<?= $product->is_on_sale() ? ' on-sale' : ''; ?>"><?= wc_price($regular_price); ?></p>

                                <?php $sale_price = get_post_meta(get_the_ID(), '_sale_price', true); ?>
                                <?php if (!empty($sale_price)): ?>
                                    <p class="sale-price"><?= wc_price($sale_price); ?></p>
                                <?php endif; ?>

                                <div class="product-description"><?= ws_get_content_limit($featured_query->post->post_excerpt, 170, true); ?></div>

                                <?php $sale_price_dates_to = get_post_meta(get_the_ID(), get_theme_mod('shop-product-offer-end-date-key', '_woo_product_offerslider_timer'), true); ?>
                                <?php if (!empty($sale_price_dates_to)): ?>
                                    <div class="countDown-title"><?= __('Time remaining until order completion', 'webafra-store'); ?>:</div>

                                    <script>
                                        featured_slider_timer_init(
                                            '<?= $this->get_id(); ?>-<?= get_the_ID(); ?>',
                                            '<?= date('Y-m-d', $sale_price_dates_to); ?>',
                                            '<?= __('Offer is finished', 'webafra-store'); ?>',
                                            '<?= __('Seconds', 'webafra-store'); ?>',
                                            '<?= __('Minutes', 'webafra-store'); ?>',
                                            '<?= __('Hours', 'webafra-store'); ?>',
                                            '<?= __('Days', 'webafra-store'); ?>',
                                        );
                                    </script>

                                    <ul class="countDown-timer" id="display_timer_<?= $this->get_id(); ?>-<?= get_the_ID(); ?>"></ul>
                                <?php endif; ?>
                            </div>

                            <div class="product-thumbnail">
                                <?php
                                $thumbnail_src = wc_placeholder_img_src();
                                if ($thumbnail_id = get_post_thumbnail_id(get_the_ID())) {
                                    if ($thumbnail_image = wp_get_attachment_image_src($thumbnail_id, 'medium')) {
                                        $thumbnail_src = $thumbnail_image[0];
                                    }
                                }
                                ?>
                                <a href="<?= esc_url(get_permalink()); ?>" title="<?= get_the_title(); ?>"><img <?= ws_image_lazy_load_attr(); ?> src="<?= $thumbnail_src; ?>" alt="<?= get_the_title(); ?>" /></a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
                <div class="slider-controls">
                    <div id="custom-dots-<?= $this->get_id(); ?>" class="slider-dots"></div>
                    <div id="custom-nav-<?= $this->get_id(); ?>" class="slider-nav"></div>
                </div>
            </div>
            <script>
                (function($) {
                    featured_slider_init('<?= $this->get_id(); ?>');
                })(jQuery);
            </script>
        <?php endif; ?>
<?php }
}
