<?php

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Elementor_Widget_Brands extends Widget_Base
{
    public function get_name()
    {
        return 'webafra_store_elementor_brands';
    }

    public function get_title()
    {
        return esc_html__('Brands', 'webafra-store');
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_script_depends()
    {
        return [
            'webafra-store-owl.carousel.min',
        ];
    }

    public function get_style_depends()
    {
        return [
            'webafra-store-owl.carousel.min',
            'webafra-store-owl.theme.default.min',
            'webafra-store-brands',
        ];
    }

    public function get_categories()
    {
        return ['webafra-store-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section('settings', [
            'label' => esc_html__('Settings', 'webafra-store'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('title', [
            'label' => esc_html__('Title', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Title', 'webafra-store'),
        ]);

        $this->add_control('brand_taxonomy', [
            'label' => esc_html__('Brand taxonomy', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => get_theme_mod('shop-brand-taxonomy', 'pa_brand'),
        ]);

        $this->add_control('thumbnail_meta_key', [
            'label' => esc_html__('Thumbnail meta key', 'webafra-store'),
            'type' => Controls_Manager::TEXT,
            'default' => 'product_attribute_image',
        ]);

        $this->add_control('limit', [
            'label' => esc_html__('Limit', 'webafra-store'),
            'type' => Controls_Manager::NUMBER,
            'default' => 8,
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $args = [
            'taxonomy' => $settings['brand_taxonomy'],
            'number' => $settings['limit'],
            'hide_empty' => false,
            'depth' => 1,
        ];

        $terms = get_terms($args); ?>

        <?php if (!empty($terms)) : ?>
            <div class="ws-brands">
                <?php if (!empty($settings['title'])): ?>
                    <div class="brands-head">
                        <div class="head-title">
                            <h2><?= $settings['title']; ?></h2>
                        </div>
                    </div>
                <?php endif; ?>

                <div id="webafra_store_elementor_brands-<?= $this->get_id(); ?>" class="brands-wrapper owl-carousel owl-theme">
                    <?php foreach ($terms as $term) : ?>
                        <div class="brand-loop">
                            <?php
                            $brand_thumbnail_src = wc_placeholder_img_src();
                            if (!empty($settings['thumbnail_meta_key'])) {
                                if ($brand_thumbnail_id = get_term_meta($term->term_id, $settings['thumbnail_meta_key'], true)) {
                                    if ($brand_thumbnail_image = wp_get_attachment_image_src($brand_thumbnail_id, 'woocommerce_thumbnail')) {
                                        $brand_thumbnail_src = $brand_thumbnail_image[0];
                                    }
                                }
                            }
                            ?>
                            <a title="<?= $term->name; ?>" href="<?= get_term_link($term); ?>">
                                <figure>
                                    <img <?= ws_image_lazy_load_attr(); ?> alt="<?= $term->name; ?>" src="<?= $brand_thumbnail_src; ?>" />
                                </figure>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div id="custom-nav-<?= $this->get_id(); ?>" class="custom-nav"></div>
            </div>
            <script>
                jQuery(`#webafra_store_elementor_brands-<?= $this->get_id(); ?>`).owlCarousel({
                    items: 6,
                    margin: 20,
                    rtl: <?= (int) is_rtl(); ?>,
                    lazyLoad: 1,
                    responsive: {
                        0: {
                            items: 2
                        },
                        600: {
                            items: 4
                        },
                        1000: {
                            items: 6
                        }
                    },
                    nav: 1,
                    navContainer: '#custom-nav-<?= $this->get_id(); ?>',
                    navText: [
                        '<svg aria-label="Previous" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
                        '<svg aria-label="Next" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
                    ],
                    dots: 0,
                });
            </script>
<?php endif;
    }
}
