<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Elementor_Init
{
    public static $ins = null;

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }

        return self::$ins;
    }

    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('elementor/elements/categories_registered', [$this, 'categories_registered']);
        add_action('elementor/widgets/register', [$this, 'register_widgets']);

        add_filter('elementor/fonts/groups', [$this, 'register_fonts_group']);
        add_filter('elementor/fonts/additional_fonts', [$this, 'register_additional_fonts']);
    }

    public function enqueue_scripts()
    {
        $theme_version = wp_get_theme()->get('Version');

        $template_directory_uri = get_template_directory_uri();

        wp_register_style('webafra-store-owl.carousel.min', $template_directory_uri . '/assets/libs/owl-carousel2/owl.carousel.min.css', [], '2.3.4');
        wp_register_style('webafra-store-owl.theme.default.min', $template_directory_uri . '/assets/libs/owl-carousel2/owl.theme.default.min.css', [], '2.3.4');
        wp_register_script('webafra-store-owl.carousel.min', $template_directory_uri . '/assets/libs/owl-carousel2/owl.carousel.min.js', [], '2.3.4', [
            'in_footer' => 0
        ]);

        if (class_exists('WooCommerce')) {
            wp_register_style('webafra-store-featured-products-slider', $template_directory_uri . '/assets/elementor/css/featured-products-slider.min.css', [], $theme_version);
            wp_register_script('webafra-store-featured-products-slider.min', $template_directory_uri . '/assets/elementor/js/featured-products-slider.min.js', ['jquery'], $theme_version, [
                'in_footer' => 0
            ]);

            wp_register_style('webafra-store-products', $template_directory_uri . '/assets/elementor/css/products.min.css', [], $theme_version);
            wp_register_script('webafra-store-products', $template_directory_uri . '/assets/elementor/js/products.min.js', ['jquery'], $theme_version, [
                'in_footer' => 0
            ]);

            wp_register_style('webafra-store-products-grid', $template_directory_uri . '/assets/elementor/css/products-grid.min.css', [], $theme_version);

            wp_register_style('webafra-store-products-tabs', $template_directory_uri . '/assets/elementor/css/products-tabs.min.css', [], $theme_version);

            wp_register_style('webafra-store-product-categories', $template_directory_uri . '/assets/elementor/css/product-categories.min.css', [], $theme_version);

            wp_register_style('webafra-store-brands', $template_directory_uri . '/assets/elementor/css/brands.min.css', [], $theme_version);

            wp_register_style('webafra-store-mini-cart', $template_directory_uri . '/assets/elementor/css/mini-cart.min.css', [], $theme_version);

            wp_register_style('webafra-store-megamenu', $template_directory_uri . '/assets/elementor/css/megamenu.min.css', [], $theme_version);
        }

        wp_register_style('webafra-store-posts', $template_directory_uri . '/assets/elementor/css/posts.min.css', [], $theme_version);

        wp_register_style('webafra-store-services', $template_directory_uri . '/assets/elementor/css/services.min.css', [], $theme_version);
    }

    public function categories_registered($elements_manager)
    {
        $elements_manager->add_category('webafra-store-widgets', [
            'title' => esc_html__('Webafra Store', 'webafra-store'),
            'icon' => ''
        ]);
    }

    public function register_widgets($widgets_manager)
    {
        $template_directory = get_template_directory();

        if (class_exists('WooCommerce')) {
            include_once $template_directory . '/includes/elementor/widgets/featured-products-slider.php';
            include_once $template_directory . '/includes/elementor/widgets/products.php';
            include_once $template_directory . '/includes/elementor/widgets/products-grid.php';
            include_once $template_directory . '/includes/elementor/widgets/products-tabs.php';
            include_once $template_directory . '/includes/elementor/widgets/brands.php';
            include_once $template_directory . '/includes/elementor/widgets/product-categories.php';
            include_once $template_directory . '/includes/elementor/widgets/mini-cart.php';
            include_once $template_directory . '/includes/elementor/widgets/megamenu.php';

            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Featured_Products_Slider());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Products_Carousel());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Products_Grid());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Products_Tabs());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Brands());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Product_Categories());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Mini_Cart());
            $widgets_manager->register(new \Webafra_Store_Elementor_Widget_MegaMenu());
        }

        include_once $template_directory . '/includes/elementor/widgets/posts.php';
        include_once $template_directory . '/includes/elementor/widgets/services.php';

        $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Posts());
        $widgets_manager->register(new \Webafra_Store_Elementor_Widget_Services());
    }

    public function register_fonts_group($font_groups)
    {
        $new_group['ws-custom-fonts'] = __('Custom fonts', 'webafra-store');
        $font_groups = $new_group + $font_groups;
        return $font_groups;
    }

    public function register_additional_fonts($fonts)
    {
        $fonts['dana'] = 'ws-custom-fonts';
        $fonts['dana-fanum'] = 'ws-custom-fonts';
        $fonts['Kalameh'] = 'ws-custom-fonts';
        $fonts['IRANSansX'] = 'ws-custom-fonts';

        return $fonts;
    }
}

Webafra_Store_Elementor_Init::ins();
