<?php
if (!defined('ABSPATH')) {
    exit('No direct access allowed.');
}

class Webafra_Store_Admin
{
    public static $ins = null;

    public $theme_version = null;

    public $template_directory = null;

    public $template_directory_uri = null;

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }

        return self::$ins;
    }

    public function __construct()
    {
        $this->theme_version = wp_get_theme()->get('Version');

        $this->template_directory = get_template_directory();

        $this->template_directory_uri = get_template_directory_uri();

        add_action('admin_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('wp_nav_menu_item_custom_fields', [$this, 'add_mega_menu_options'], 10, 2);

        add_action('wp_update_nav_menu_item', [$this, 'save_mega_menu_options'], 10, 2);

        if (!function_exists('jdate')) {
            require_once $this->template_directory . '/includes/jdf.php';
        }
    }

    public function enqueue_scripts()
    {
        wp_enqueue_media();
        wp_enqueue_script('jquery');
        wp_enqueue_style('webafra-store-jalalidatepicker.min', $this->template_directory_uri . '/assets/libs/jalalidatepicker/jalalidatepicker.min.css', [], $this->theme_version);
        wp_enqueue_script('webafra-store-jalalidatepicker.min', $this->template_directory_uri . '/assets/libs/jalalidatepicker/jalalidatepicker.min.js', ['jquery'], $this->theme_version);
        wp_enqueue_script('theme.min', $this->template_directory_uri . '/assets/js/admin.min.js', ['jquery'], $this->theme_version);
    }

    public function add_mega_menu_options($item_id, $item)
    {
        $banner_id = get_post_meta($item_id, '_banner_id', true);
        $banner_src = '';

        if (!empty($banner_id)) {
            if ($attachment_image_src = wp_get_attachment_image_src($banner_id)) {
                $banner_src = $attachment_image_src[0];
            }
        }

        get_template_part('templates/admin/menu-options', null, [
            'item_id' => $item_id,
            'enable_show_styled_cat' => get_post_meta($item_id, '_enable_show_styled_cat', true),
            'enable_mega_menu' => get_post_meta($item_id, '_enable_mega_menu', true),
            'mega_menu_type' => get_post_meta($item_id, '_mega_menu_type', true),
            'banner_id' => $banner_id,
            'banner_src' => $banner_src,
            'menu_item_icon' => get_post_meta($item_id, '_menu_item_icon', true),
        ]);
    }

    public function save_mega_menu_options($menu_id, $menu_item_db_id)
    {
        if (isset($_POST['menu_item_enable_mega_menu'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, '_enable_mega_menu', 1);
        } else {
            delete_post_meta($menu_item_db_id, '_enable_mega_menu');
        }

        if (isset($_POST['menu_item_mega_menu_type'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, '_mega_menu_type', sanitize_text_field($_POST['menu_item_mega_menu_type'][$menu_item_db_id]));
        } else {
            delete_post_meta($menu_item_db_id, '_mega_menu_type');
        }

        if (!empty($_POST['menu_item_banner_id'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, '_banner_id', $_POST['menu_item_banner_id'][$menu_item_db_id]);
        } else {
            delete_post_meta($menu_item_db_id, '_banner_id');
        }

        if (!empty($_POST['menu_item_icon'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, '_menu_item_icon', sanitize_text_field($_POST['menu_item_icon'][$menu_item_db_id]));
        } else {
            delete_post_meta($menu_item_db_id, '_menu_item_icon');
        }
    }
}

if (is_admin()) {
    Webafra_Store_Admin::ins();
}
