<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?= get_bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <?php wp_head(); ?>
    <?php if ($header_script = get_theme_mod('header-script', '')): ?>
        <?= $header_script; ?>
    <?php endif; ?>
</head>

<body <?php body_class(); ?>>
    <?php if (get_theme_mod('enable-site-loading', 1)): ?>
        <div class="site-loading" id="site-loading">
            <?php if (get_theme_mod('site-loading-header', 'spinning_icon') == 'spinning_icon'): ?>
                <div class="site-loading-loader"></div>
            <?php elseif (get_theme_mod('site-loading-header', 'spinning_icon') == 'logo'): ?>
                <?php if ($custom_logo_id = get_theme_mod('custom_logo')): ?>
                    <?php if ($custom_logo = wp_get_attachment_image_src($custom_logo_id, 'medium_large')): ?>
                        <div class="site-loading-logo">
                            <img <?= ws_image_lazy_load_attr(); ?> width="<?= $custom_logo[1]; ?>" height="<?= $custom_logo[2]; ?>" src="<?= $custom_logo[0]; ?>" alt="<?= get_bloginfo('name'); ?>" />
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
            <?php if (!empty(get_theme_mod('site-loading-text', ''))): ?>
                <div class="site-loading-text"><?= get_theme_mod('site-loading-text', ''); ?></div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php
    $announcement_more_text = get_theme_mod('header-announcement-more-text', __('Read more', 'webafra-store'));
    $announcement_closeable = get_theme_mod('header-announcement-closeable', 1);
    ?>
    <?php if (get_theme_mod('header-announcement-enable', 1)): ?>
        <div class="header-announcement align-<?= get_theme_mod('header-announcement-text-align', 'right'); ?>" id="header-announcement">
            <div class="container">
                <div class="announcement-wrapper">
                    <div class="announcement-text">
                        <?php if (get_theme_mod('header-announcement-show-text-icon', 1)): ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M22 17H2a3 3 0 0 0 3-3V9a7 7 0 0 1 14 0v5a3 3 0 0 0 3 3zm-8.27 4a2 2 0 0 1-3.46 0"></path>
                            </svg>
                        <?php endif; ?>
                        <span>
                            <?= get_theme_mod('header-announcement-text', __('Enter the text of your announcement', 'webafra-store')); ?>
                        </span>
                    </div>
                    <?php if ($announcement_more_text || $announcement_closeable): ?>
                        <div class="announcement-btn">
                            <?php if ($announcement_more_text): ?>
                                <?php if (!empty($announcement_more_text)) : ?>
                                    <a class="announcement-more" title="<?= $announcement_more_text; ?>" href="<?= get_theme_mod('header-announcement-more-link', ''); ?>" target="_blank" rel="nofollow">
                                        <?= $announcement_more_text; ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M19 12H6M12 5l-7 7 7 7" />
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if ($announcement_closeable): ?>
                                <button class="announcement-close" title="<?= __('Close', 'webafra-store'); ?>" onclick="closeAnnouncement();">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <line x1="18" y1="6" x2="6" y2="18"></line>
                                        <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                </button>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="header-wrapper header-wrapper-<?= get_theme_mod('header-theme', 'one'); ?>">

        <?php if (get_theme_mod('header-top-enable', 1)): ?>
            <div class="header-top">
                <div class="container">
                    <div class="header-top-con">
                        <?= wp_nav_menu([
                            'theme_location' => 'header-top',
                            'depth' => 1,
                            'container' => 'nav',
                            'container_class' => 'header-top-menu',
                        ]); ?>
                        <div class="header-top-contact">
                            <?php if ($shop_phone_numbers = explode('|', get_theme_mod('shop-phone-numbers', ws_get_shop_phone_numbers_default()))): ?>
                                <ul>
                                    <?php foreach ($shop_phone_numbers as $number) : ?>
                                        <li><a href="tel:<?= $number; ?>"><?= $number; ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if (get_theme_mod('header-theme', 'one') == 'one'): ?>
            <?php include get_template_directory() . '/templates/headers/theme-one/main.php'; ?>
        <?php endif; ?>

        <?php if (get_theme_mod('header-theme', 'one') == 'two'): ?>
            <?php include get_template_directory() . '/templates/headers/theme-two/main.php'; ?>
        <?php endif; ?>
    </div>
    <?php if (get_theme_mod('header-theme', 'one') == 'one'): ?>
        <?php include get_template_directory() . '/templates/headers/theme-one/menu.php'; ?>
    <?php endif; ?>

    <?php if (get_theme_mod('header-theme', 'one') == 'two'): ?>
        <?php include get_template_directory() . '/templates/headers/theme-two/menu.php'; ?>
    <?php endif; ?>