<section class="footer-services">
    <div class="container">
        <div class="footer-services-items">
            <?php foreach (ws_get_footer_services_items_default() as $key => $service): $service_text = get_theme_mod('footer-services-' . $key . '-text', $service['text']); ?>
                <div class="footer-service">
                    <div class="service-image">
                        <?php if ($image = get_theme_mod('footer-services-' . $key . '-image', $service['image'])): ?>
                            <img <?= ws_image_lazy_load_attr(); ?> src="<?= $image; ?>" alt="<?= $service_text; ?>" />
                        <?php endif; ?>
                    </div>
                    <div class="service-text">
                        <?= $service_text; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<footer class="footer">
    <div class="footer-main">
        <div class="container">
            <div class="footer-main-columns">
                <div class="footer-main-column-right">
                    <?php if ($custom_logo_id = get_theme_mod('custom_logo')): ?>
                        <?php if ($custom_logo = wp_get_attachment_image_src($custom_logo_id, 'medium_large')): ?>
                            <div class="footer-logo">
                                <a href="<?= home_url(); ?>" title="<?= get_bloginfo('name'); ?>">
                                    <img <?= ws_image_lazy_load_attr(); ?> width="<?= $custom_logo[1]; ?>" height="<?= $custom_logo[2]; ?>" src="<?= $custom_logo[0]; ?>" alt="<?= get_bloginfo('name'); ?>" />
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <ul class="footer-socials">
                        <?php foreach (ws_get_socials_items_default() as $key => $social): ?>
                            <li class="footer-social">
                                <a title="<?= get_theme_mod('socials_' . $key . '_text', $social['text']); ?>" href="<?= get_theme_mod('socials_' . $key . '_link', $social['link']); ?>">
                                    <img width="24" height="24" <?= ws_image_lazy_load_attr(); ?> alt="<?= get_theme_mod('socials_' . $key . '_text', $social['text']); ?>" src="<?= get_theme_mod('socials_' . $key . '_image', $social['image']); ?>" />
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>

                    <div class="footer-shopAddress">
                        <span><?= get_theme_mod('shop-address', ws_get_shop_address_default()); ?></span>
                    </div>

                    <?php if ($shop_phone_numbers = explode('|', get_theme_mod('shop-phone-numbers', ws_get_shop_phone_numbers_default()))): ?>
                        <ul class="footer-callNumber">
                            <?php foreach ($shop_phone_numbers as $number) : ?>
                                <li><a href="tel:<?= $number; ?>"><?= $number; ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>


                    <?php if ($footer_map = get_theme_mod('footer-map')): ?>
                        <div class="footer-map">
                            <?= $footer_map; ?>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="footer-main-column-left">
                    <div class="main-column-left-menus">
                        <div class="footer-menu footer-menu-right">
                            <?= wp_nav_menu([
                                'theme_location' => 'footer-menu-right',
                                'depth' => 1,
                                'container' => '',
                                'echo' => 1,
                            ]); ?>
                        </div>
                        <div class="footer-menu footer-menu-left">
                            <?= wp_nav_menu([
                                'theme_location' => 'footer-menu-left',
                                'depth' => 1,
                                'container' => '',
                                'echo' => 1,
                            ]); ?>
                        </div>
                    </div>
                    <div class="main-column-left-enamad">
                        <?php if ($footer_namad_one = get_theme_mod('footer-namad-one')): ?>
                            <div class="footer-enamad footer-enamad-one">
                                <?= $footer_namad_one; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($footer_namad_two = get_theme_mod('footer-namad-two')): ?>
                            <div class="footer-enamad footer-enamad-two">
                                <?= $footer_namad_two; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($footer_namad_three = get_theme_mod('footer-namad-three')): ?>
                            <div class="footer-enamad footer-enamad-three">
                                <?= $footer_namad_three; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="main-column-left-four">
                        <?php if ($footer_namad_three = get_theme_mod('footer-brands')): ?>
                            <?= $footer_namad_three; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if ($footer_copyright = get_theme_mod('footer-copyright', ws_get_footer_copyright_default())): ?>
        <div class="footer-copyright">
            <div class="container"><?= $footer_copyright; ?></div>
        </div>
    <?php endif; ?>
</footer>

<?php wp_footer(); ?>

</body>

</html>