<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!post_type_supports(get_post_type(), 'comments')) {
    return;
}

if (!have_comments() && !comments_open()) {
    return;
}
?>
<section id="comments" class="comments-area">
    <?php
    function add_wrapper_comment_form_default_fields($fields)
    {
        $fields['author'] = '<div class="form-fields">' . $fields['author'];
        $fields['url'] = '</div>';

        return $fields;
    }
    add_filter('comment_form_default_fields', 'add_wrapper_comment_form_default_fields', 20);

    comment_form([
        'title_reply_before' => '<h2 id="reply-title" class="comment-reply-title">',
        'title_reply_after'  => '</h2>',
    ]);
    remove_filter('comment_form_default_fields', 'add_wrapper_comment_form_default_fields', 20);
    ?>
    <?php if (have_comments()) : ?>
        <h3 class="title-comments">
            <?php
            $comments_number = get_comments_number();
            if ('1' === $comments_number) {
                printf(esc_html_x('One Response', 'comments title', 'webafra-store'));
            } else {
                printf(
                    esc_html( /* translators: 1: number of comments */
                        _nx(
                            '%1$s Response',
                            '%1$s Responses',
                            $comments_number,
                            'comments title',
                            'webafra-store'
                        )
                    ),
                    esc_html(number_format_i18n($comments_number))
                );
            }
            ?>
        </h3>
        <?php the_comments_navigation(); ?>
        <ol class="comment-list">
            <?php
            wp_list_comments(
                [
                    'style' => 'li',
                    'short_ping' => true,
                    'avatar_size' => 62,
                    'walker' => new Comment_Walker()
                ]
            );
            ?>
        </ol>
        <?php the_comments_navigation(); ?>
    <?php endif;
    ?>
</section>