<?php

/**
 * Template Name: Brands
 */

get_header();
?>

<div class="container">
    <div style="margin-top: 20px;">
        <?php ws_theme_breadcrumb(); ?>
    </div>
    <article class="blog-single<?= get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true) ? ' no-sidebar' : ''; ?>">
        <main class="blog-singleMain">
            <?php while (have_posts()): the_post(); ?>
                <div id="page-<?= get_the_ID(); ?>" class="page-brands">
                    <?php
                    $taxonomy = get_theme_mod('shop-brand-taxonomy', 'pa_brand');

                    $brands_total = get_terms([
                        'taxonomy' => $taxonomy,
                        'depth' => 1,
                        'hide_empty' => false
                    ]);

                    $paged = get_query_var('paged') ? get_query_var('paged') : 1;

                    $per_page = get_option('posts_per_page');

                    $offset = (($paged - 1) * $per_page);

                    $brands = get_terms([
                        'taxonomy' => $taxonomy,
                        'depth' => 1,
                        'hide_empty' => false,
                        'number' => $per_page,
                        'offset' => $offset,
                    ]);

                    if (!empty($brands)) {
                        $current_brand_id = 0;

                        if ($queried_object = get_queried_object()) {
                            if ((!empty($queried_object->taxonomy) && $queried_object->taxonomy == $taxonomy)) {
                                $current_brand_id = $queried_object->term_id;
                            }
                        }

                        echo '<ul class="brand-list">';

                        foreach ($brands as $brand) {
                            get_template_part('templates/brand-loop/loop', null, [
                                'taxonomy' => $taxonomy,
                                'brand' => $brand,
                                'current_brand_id' => $current_brand_id,
                            ]);
                        }

                        echo '</ul>';

                        $total = ceil(count($brands_total) / $per_page);

                        if ($total > 1) {
                            $big = 99999; ?>
                            <div class="pagination-wrapper blog-pagination-wrapper" id="pagination-wrapper">
                                <nav class="woocommerce-pagination-theme" aria-label="<?php esc_attr_e('Blog Pagination', 'webafra-store'); ?>">
                                    <?php ws_pagination($total); ?>
                                </nav>
                            </div>

                            <div class="pagination-showButton" id="pagination-showButton">
                                <button onclick="showPagination();">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                    <span><?= __('Show more', 'webafra-store'); ?></span>
                                </button>
                            </div>
                    <?php }
                    }
                    ?>

                    <?php if (!empty(get_the_content())): ?>
                        <div class="archive-description" id="archive-description">
                            <?= get_the_content(); ?>
                            <div class="description-mask" id="archive-descriptionMask">
                                <span class="button" onclick="archiveDescriptionMoreButton();">
                                    <span><?= __('More', 'webafra-store'); ?></span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M6 9l6 6 6-6" />
                                    </svg>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endwhile; ?>
        </main>

        <?php if (!get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true)): ?>
            <aside class="blog-singleSidebar">
                <div class="sidebar-sticky">
                    <?php dynamic_sidebar('brands-page'); ?>
                </div>
            </aside>
        <?php endif; ?>
    </article>
</div>

<?php get_footer(); ?>