<?php

/**
 * Template Name: Blog
 */
get_header();
?>

<div class="container">
    <div style="margin-top: 20px;">
        <?php ws_theme_breadcrumb(); ?>
    </div>
    <article class="blog-single blog-archive<?= get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true) ? ' no-sidebar' : ''; ?>">
        <main class="blog-singleMain">
            <?php $theme_settings_hidden_title = get_post_meta(get_the_ID(), '_ws_theme_settings_hidden_title', true); ?>
            <?php if (empty($theme_settings_hidden_title) || $theme_settings_hidden_title == '0'): ?>
                <header class="archive-heading">
                    <h1><?= get_the_title(); ?></h1>
                </header>
            <?php endif; ?>

            <?php
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $post_args = [
                'paged' => $paged,
                'post_type' => 'post',
                'orderby' => 'ID',
                'order' => 'DESC'
            ];
            $post_query = new WP_Query($post_args);
            ?>
            <?php if ($post_query->have_posts()): ?>
                <div class="archive-posts">
                    <?php while ($post_query->have_posts()): $post_query->the_post(); ?>
                        <?php get_template_part('templates/post-loop/archive'); ?>
                    <?php endwhile; ?>
                </div>

                <?php if ($post_query->max_num_pages > 1): ?>
                    <div class="pagination-wrapper blog-pagination-wrapper" id="pagination-wrapper">
                        <nav class="woocommerce-pagination-theme" aria-label="<?php esc_attr_e('Blog Pagination', 'webafra-store'); ?>">
                            <?php ws_pagination($post_query->max_num_pages); ?>
                        </nav>
                    </div>

                    <div class="pagination-showButton" id="pagination-showButton">
                        <button onclick="showPagination();">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                <line x1="5" y1="12" x2="19" y2="12"></line>
                            </svg>
                            <span><?= __('Show more', 'webafra-store'); ?></span>
                        </button>
                    </div>
                <?php endif; ?>
            <?php else: ?>
            <?php endif; ?>
        </main>

        <?php if (!get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true)): ?>
            <aside class="blog-singleSidebar">
                <div class="sidebar-sticky">
                    <?php dynamic_sidebar('blog'); ?>
                </div>
            </aside>
        <?php endif; ?>
    </article>
</div>

<?php get_footer(); ?>