jQuery(document).ready(function ($) {
    $(document.body).on('added_to_cart', function () {
        sideCartToggle();
    });

    $('.single-product .entry-summary form.cart').on('submit', function (e) {
        e.preventDefault();

        let this_button = $('.single_add_to_cart_button');

        this_button.block({
            message: null,
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            }
        });

        let product_url = window.location, form = $(this);

        $.post(product_url, form.serialize() + '&_wp_http_referer=' + product_url, function (result) {
            let cart_dropdown = $('.widget_shopping_cart_content', result);

            $('.widget_shopping_cart_content').replaceWith(cart_dropdown);

            $.ajax({
                url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                type: 'POST',
                success: function (data) {
                    if (data.fragments) {
                        $.each(data.fragments, function (key, value) {
                            $(key).replaceWith(value);
                        });
                        
                        $(document.body).trigger('wc_fragments_refreshed');
                    }
                }
            });

            sideCartToggle();

            this_button.unblock();
        });
    });
});

function ws_wishlist_toggle(el, product_id) {
    jQuery(el).addClass('loading');

    jQuery.ajax({
        type: 'POST',
        url: '?wc-ajax=ws_toggle_add_product_compare',
        // url: ws_ajax_var.url,
        dataType: 'json',
        data: {
            // action: 'ws_toggle_add_product_compare',
            nonce: ws_ajax_var.nonce,
            product_id: product_id,
        },
        success: function (res) {
            if (res.status == 'ok') {
                if (res.added != null) {
                    if (res.added == '1') {
                        jQuery(el).addClass('added');
                    } else {
                        jQuery(el).removeClass('added');
                    }
                    jQuery('.compare-badge-selector').html(res.count);
                }
            }
            jQuery(el).removeClass('loading');
        },
    });
}