jQuery(document).ready(function ($) {
    $('body').click(function (event) {
        if (
            !$(event.target).is('#side-login') &&
            !$(event.target).is('#side-login *') &&
            !$(event.target).is('#side-login-toggle') &&
            !$(event.target).is('#side-login-toggle *')
        ) {
            $('#side-login').removeClass('opened');
            $('#overlay4').removeClass('opened');
        }

        if (
            !$(event.target).is('#side-user-info') &&
            !$(event.target).is('#side-user-info *') &&
            !$(event.target).is('#my-account-mobile-toggle') &&
            !$(event.target).is('#my-account-mobile-toggle *')
        ) {
            $('#side-user-info').removeClass('opened');
            $('#overlay5').removeClass('opened');
        }

        if (
            !$(event.target).is('#side-cart') &&
            !$(event.target).is('#side-cart *') &&
            !$(event.target).is('#mini-cart-toggle') &&
            !$(event.target).is('#mini-cart-toggle *')
        ) {
            $('#side-cart').removeClass('opened');
            $('#overlay1').removeClass('opened');
        }

        if (
            !$(event.target).is('#side-primaryMenu') &&
            !$(event.target).is('#side-primaryMenu *') &&
            !$(event.target).is('#mobile-nav-toggle') &&
            !$(event.target).is('#mobile-nav-toggle *')
        ) {
            $('#side-primaryMenu').removeClass('opened');
            $('#overlay2').removeClass('opened');
        }

        if (
            !$(event.target).is('#shop-sidebar') &&
            !$(event.target).is('#shop-sidebar *') &&
            !$(event.target).is('#shop-sideBarToggle') &&
            !$(event.target).is('#shop-sideBarToggle *')
        ) {
            $('#shop-sidebar').removeClass('opened');
            $('#overlay3').removeClass('opened');
        }
    });

    $('.primary-menu ul.menu > li').hover(
        function () {
            $('.overlay-blur').addClass('show');
        },
        function () {
            $('.overlay-blur').removeClass('show');
        }
    );

    $('.primary-menu ul.menu > li.mega-menu').hover(
        function () {
            $('.primary-menu ul.menu > li.mega-menu > ul.sub-menu > li.menu-item-has-children:first-child').addClass('is-active');
        },
        function () {
            $('.primary-menu ul.menu > li.mega-menu > ul.sub-menu > li.menu-item-has-children').removeClass('is-active');
        },
    );

    $('.primary-menu ul.menu > li.mega-menu > ul.sub-menu > li.menu-item-has-children').hover(
        function () {
            $('.primary-menu ul.menu > li.mega-menu > ul.sub-menu > li.menu-item-has-children').removeClass('is-active');
            $(this).addClass('is-active');
        },
    );

    if ($('.primary-menu').length) {
        var primary_sub_menu_width = $('.primary-menu').width();
        var primary_sub_menu_width_vertical = primary_sub_menu_width - 200;

        $('.primary-menu ul.menu > li.mega-menu-vertical > ul.sub-menu > li.menu-item-has-children > ul.sub-menu').css('width', `${primary_sub_menu_width_vertical}px`);
        $('.primary-menu ul.menu > li.mega-menu-horizontal > ul.sub-menu > li.menu-item-has-children > ul.sub-menu').css('width', `${primary_sub_menu_width}px`);
        $('.primary-menu ul.menu>li.mega-menu-horizontal>ul.sub-menu').css('width', `${primary_sub_menu_width}px`);
    }

    $(window).resize(function () {
        if ($('.primary-menu').length) {
            var primary_sub_menu_width = $('.primary-menu').width();
            var primary_sub_menu_width_vertical = primary_sub_menu_width - 200;

            $('.primary-menu ul.menu > li.mega-menu-vertical > ul.sub-menu > li.menu-item-has-children > ul.sub-menu').css('width', `${primary_sub_menu_width_vertical}px`);
            $('.primary-menu ul.menu > li.mega-menu-horizontal > ul.sub-menu > li.menu-item-has-children > ul.sub-menu').css('width', `${primary_sub_menu_width}px`);
        }
    });
});

function sideCartToggle() {
    jQuery('#side-cart').toggleClass('opened');
    jQuery('#overlay1').toggleClass('opened');
}

function sideLoginToggle() {
    jQuery('#side-login').toggleClass('opened');
    jQuery('#overlay4').toggleClass('opened');
}

function sideUserInfoToggle() {
    jQuery('#side-user-info').toggleClass('opened');
    jQuery('#overlay5').toggleClass('opened');
}

function shopSideBarToggle() {
    jQuery('#shop-sidebar').toggleClass('opened');
    jQuery('#overlay3').toggleClass('opened');
}

function postSocialSharingPopup(id) {
    jQuery('#post-sharePopup-' + id).toggleClass('opened');
    jQuery('#sharePopup-body-' + id).toggleClass('opened');
}

function mobileNavToggle() {
    jQuery('#side-primaryMenu').toggleClass('opened');
    jQuery('#overlay2').toggleClass('opened');
}

function navMenuDropdownToggle(id) {
    jQuery(`.side-primary-menu .menu-item-${id} > .nav-menuDropdown .nav-menuDropdownToggle`).toggleClass('active');
    jQuery(`.side-primary-menu .menu-item-${id} > ul.sub-menu`).toggleClass('opened');
}

function scrollToTop() {
    jQuery('html, body').animate({ scrollTop: 0 }, 'slow');
    return false;
}

function archiveDescriptionMoreButton() {
    jQuery('#archive-description').addClass('opened');
}

function showPagination() {
    jQuery('#pagination-wrapper').toggleClass('show');
    jQuery('#pagination-showButton').addClass('hide');
}

function closeAnnouncement() {
    jQuery('#header-announcement').fadeOut();
}

function featureShowMore(self) {
    jQuery(self).toggleClass('show-less');
    jQuery('#single-product-features').toggleClass('limited');
}

function quantityInput(id, type) {
    var qty = jQuery(id).val();

    if (qty == '') {
        qty == 1;
    }

    if (type == 'plus') {
        qty++;
    } else if (type == 'minus') {
        if (qty == 1) {
            return;
        }

        qty--;
    }

    jQuery(id).val(qty).trigger('change');
}

function textCopy(element) {
    var getElement = document.getElementById(element);
    navigator.clipboard.writeText(getElement.innerHTML);
}

function change_products_tab(wid, id) {
    jQuery(`#ws-products-tabs-${wid} .tabs li`).removeClass('active');
    jQuery(`#ws-products-tabs-${wid} .tabs li.tab-${id}`).addClass('active');

    jQuery(`#ws-products-tabs-${wid} .tab-content`).removeClass('active');
    jQuery(`#ws-products-tabs-${wid} .tab-content.tab-content-${id}`).addClass('active');
}

function megamenu_init(id) {
    jQuery(`#${id} .mega-menu-dropdown .main-category-tabs li`).hover(
        function () {
            jQuery(`#${id} .mega-menu-dropdown .main-category-tabs li`).removeClass('active');
            jQuery(this).addClass('active');

            var term_id = jQuery(this).attr('id');

            jQuery(`#${id} .mega-menu-dropdown .main-category-contents .main-category-content`).removeClass('active');
            jQuery(`#${id} .mega-menu-dropdown .main-category-contents .main-category-content#${term_id}`).addClass('active');
        },
    );
}

function megamenu_responsive(id) {
    megamenu_responsive_init(id);

    jQuery(window).resize(function () {
        megamenu_responsive_init(id);
    });
}

function megamenu_responsive_init(id) {
    if (jQuery('body .container').length) {
        var dropdown_width = jQuery('body .container').width();
        jQuery(`#${id} .mega-menu-dropdown`).css('width', `${dropdown_width}px`);
    }
}

function openMobileMegaMenu() {
    jQuery('#mobile-megamenu').toggleClass('open');
}