function product_timer_init(id, time, translate_finish) {
    var count_down_date = new Date(time).getTime();

    var timer_int = setInterval(function () {
        var now = new Date().getTime();
        var distance = count_down_date - now;
        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        var html = '';

        if (distance < 0) {
            clearInterval(timer_int);
            html = `<span class="finished">${translate_finish}!</span>`;

        } else {
            html = `<li class="time">${seconds}</li><li class="separator">:</li><li class="time">${minutes}</li><li class="separator">:</li><li class="time">${hours}</li><li class="separator">:</li><li class="time">${days}</li>`;
        }

        jQuery(id).html(html);
    }, 1000);
}

function products_carousel_init(args) {
    jQuery(args.id).owlCarousel({
        items: args.limit,
        margin: args.margin,
        rtl: args.rtl,
        lazyLoad: 1,
        responsive: {
            0: {
                items: args.limit_mobile,
            },
            768: {
                items: args.limit_tablet,
            },
            1024: {
                items: args.limit,
            },
            1440: {
                items: args.limit
            }
        },
        nav: args.show_nav,
        navContainer: args.nav_container,
        navText: [
            '<svg aria-label="Previous" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
            '<svg aria-label="Next" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
        ],
        dots: 0,
        autoplay: args.autoplay,
        autoplayTimeout: 10000,
        stagePadding: args.stage_padding,
        autoWidth: args.auto_width,
        onInitialized: function () {
            if (jQuery(args.slide_progress_id).length) {
                jQuery(args.slide_progress_id).css({
                    width: "100%",
                    transition: "width 10000ms"
                });
            }

        },
        onTranslate: function () {
            if (jQuery(args.slide_progress_id).length) {
                jQuery(args.slide_progress_id).css({
                    width: 0,
                    transition: "width 0s"
                });
            }
        },
        onTranslated: function () {
            if (jQuery(args.slide_progress_id).length) {
                jQuery(args.slide_progress_id).css({
                    width: "100%",
                    transition: "width 10000ms"
                });
            }
        }
    });
}