function featured_slider_init(id) {
    jQuery(`#webafra_store_elementor_featured_products_slider-${id}`).owlCarousel({
        items: 1,
        margin: 10,
        rtl: 1,
        lazyLoad: 1,
        autoplay: 1,
        responsive: {
            0: { items: 1 },
            600: { items: 1 },
            1000: { items: 1 }
        },
        nav: 1,
        navContainer: '#custom-nav-' + id,
        navText: [
            '<svg aria-label="Previous" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>',
            '<svg aria-label="Next" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#c8c8c8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
        ],
        dots: 1,
        dotsContainer: '#custom-dots-' + id,
        onInitialized: function (event) {
            // Add aria-labels to navigation dots
            jQuery('.owl-dot').each(function (index) {
                jQuery(this).attr('aria-label', (index + 1));
            });

            // Add aria-labels to navigation buttons
            jQuery('.owl-prev').attr('aria-label', 'Previous Slide');
            jQuery('.owl-next').attr('aria-label', 'Next Slide');
        }
    })
}

function featured_slider_timer_init(id, time, translate_finish, translate_sec, translate_min, translate_hours, translate_days) {
    var countDownDate = new Date(time).getTime();

    var timer_int = setInterval(function () {
        var now = new Date().getTime();
        var distance = countDownDate - now;
        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        var html = '';

        if (distance < 0) {
            clearInterval(timer_int);
            html = `<span class="finished">${translate_finish}!</span>`;

        } else {
            html = `<li><div class="unit-label">${translate_sec}</div><div class="unit-value">${seconds}</div></li><li><div class="unit-label">${translate_min}</div><div class="unit-value">${minutes}</div></li><li><div class="unit-label">${translate_hours}</div><div class="unit-value">${hours}</div></li><li><div class="unit-label">${translate_days}</div><div class="unit-value">${days}</div></li>`;
        }

        jQuery(`#display_timer_${id}`).html(html);
    }, 1000);
}