<?php get_header(); ?>

<div class="container">
    <div style="margin-top: 20px;">
        <?php ws_theme_breadcrumb(); ?>
    </div>
    <article class="blog-single blog-archive<?= get_post_meta(get_the_ID(), '_ws_theme_settings_disable_sidebar', true) ? ' no-sidebar' : ''; ?>">
        <main class="blog-singleMain">
            <header class="archive-heading">
                <h1>
                    <?php if (get_post_type() == 'aiovg_videos'): ?>
                        <?php _e('Videos', 'webafra-store'); ?>
                    <?php else: ?>
                        <?= get_the_archive_title(); ?>
                    <?php endif; ?>
                </h1>
            </header>

            <div class="archive-posts">
                <?php while (have_posts()): the_post(); ?>
                    <?php get_template_part('templates/post-loop/archive'); ?>
                <?php endwhile; ?>
            </div>

            <?php if (ws_current_query_max_pages_count() > 1): ?>
                <div class="pagination-wrapper blog-pagination-wrapper" id="pagination-wrapper">
                    <nav class="woocommerce-pagination-theme" aria-label="<?php esc_attr_e('Blog Pagination', 'webafra-store'); ?>">
                        <?php ws_pagination(); ?>
                    </nav>
                </div>

                <div class="pagination-showButton" id="pagination-showButton">
                    <button onclick="showPagination();">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <span><?= __('Show more', 'webafra-store'); ?></span>
                    </button>
                </div>
            <?php endif; ?>
        </main>

        <aside class="blog-singleSidebar">
            <div class="sidebar-sticky">
                <?php dynamic_sidebar('blog'); ?>
            </div>
        </aside>
    </article>
</div>

<?php get_footer(); ?>