<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

/**
 * Plugin Name: Webafra: Otp Login
 * Description: Login/Register to account via otp
 * Author: Webafra
 * Author URI: https://webafra.com/
 * Version: 1.0
 * Text Domain: webafra-otp-login
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

use Melipayamak\MelipayamakApi;

define('WOL_PF', plugin_dir_url(__FILE__));
define('WOL_PP', plugin_dir_path(__FILE__));

require WOL_PP . '/gateways/vendor/autoload.php';

class Webafra_OTP_Login
{
    public static $ins = null;

    public $user_phone_meta_key = 'phone_number';

    public $melipayamak_username = '9333430840';
    public $melipayamak_password = 'G7QTH';
    public $melipayamak_from = '50002710030840';

    public static function ins()
    {
        if (is_null(self::$ins)) {
            self::$ins = new self();
        }
        return self::$ins;
    }

    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

        // register admin ajax
        add_action('wp_ajax_nopriv_wol_send_verify_code', [$this, 'register_send_verify_code']);
        add_action('wp_ajax_nopriv_wol_check_verify_code', [$this, 'register_check_verify_code']);
        add_action('wp_ajax_nopriv_wol_register_user', [$this, 'register_user']);

        add_shortcode('wol_register_form', [$this, 'register_form_render_shortcode']);
    }

    public function enqueue_scripts()
    {
        $version = time();
        wp_enqueue_style('wol-front', WOL_PF . 'assets/css/front.css', [], $version);
        wp_enqueue_script('wol-front', WOL_PF . 'assets/js/front.js', ['jquery'], $version, true);
        wp_localize_script('wol-front', 'wol_ajax_var', [
            'url' => admin_url('admin-ajax.php'),
            'site_url' => get_site_url(),
            'nonce' => wp_create_nonce('wol-ajax-nonce'),
        ]);
    }

    public function register_send_verify_code()
    {
        if (!wp_verify_nonce($_POST['nonce'], 'wol-send-verify-nonce')) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'درخواست با خطا مواجه شد!',
            ]);
            exit;
        }

        if (!isset($_POST['phone_number']) || empty($_POST['phone_number'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'شماره موبایل خود را وارد کنید!',
            ]);
            exit;
        }

        $mobile = $_POST['phone_number'];

        if (!is_numeric($mobile) || mb_strlen($mobile) != 11) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'شماره موبایل باید 11 رقمی باشد!',
            ]);
            exit;
        }

        $code = rand(1000, 9999);

        $_SESSION['WOL_USER_REGISTER_MOBILE'] = $mobile;
        $_SESSION['WOL_USER_REGISTER_VERIFY_CODE'] = $code;

        try {
            $api = new MelipayamakApi($this->melipayamak_username, $this->melipayamak_password);

            $sms = $api->sms('soap');
            $sms->sendByBaseNumber($code, $mobile, '211933');

            // $json = json_decode($response);
            
            echo wp_json_encode([
                'status' => 'ok',
                // 'msg' => $json->Value,
                // 'code' => $code,
            ]);
        } catch (Exception $e) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => $e->getMessage()
            ]);
        }

        exit;
    }

    public function register_check_verify_code()
    {
        if (!wp_verify_nonce($_POST['nonce'], 'wol-check-verify-nonce')) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'درخواست با خطا مواجه شد!',
            ]);
            exit;
        }

        if (!isset($_POST['code']) || empty($_POST['code'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'کد دریافتی را وارد کنید!',
            ]);
            exit;
        }

        if (!isset($_SESSION['WOL_USER_REGISTER_VERIFY_CODE'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'درخواست با خطا مواجه شد!',
            ]);
            exit;
        }

        if ($_SESSION['WOL_USER_REGISTER_VERIFY_CODE'] != $_POST['code']) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'کد وارد شده صحیح نمی باشد!',
            ]);
            exit;
        }

        $check_user_by_phone = get_users([
            'meta_key' => $this->user_phone_meta_key,
            'meta_value' => $_SESSION['WOL_USER_REGISTER_MOBILE'],
            'number' => 1
        ]);

        if (count($check_user_by_phone)) {
            $user = reset($check_user_by_phone);

            wp_set_current_user($user->ID, $user->user_login);
            wp_set_auth_cookie($user->ID);
            do_action('wp_login', $user->user_login, $user);

            unset($_SESSION['WOL_USER_REGISTER_MOBILE']);
            unset($_SESSION['WOL_USER_REGISTER_VERIFY_CODE']);
            unset($_SESSION['WOL_USER_LOGIN_LOGIN_NAME']);

            echo wp_json_encode([
                'status' => 'do_login',
            ]);
            exit;
        }

        echo wp_json_encode([
            'status' => 'do_register',
        ]);
        exit;
    }

    public function register_user()
    {
        if (!wp_verify_nonce($_POST['nonce'], 'wol-register-nonce')) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'درخواست با خطا مواجه شد!',
            ]);
            exit;
        }

        if (!isset($_SESSION['WOL_USER_REGISTER_VERIFY_CODE'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'درخواست با خطا مواجه شد!',
            ]);
            exit;
        }

        if (!isset($_POST['un']) || empty($_POST['un'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'نام کاربری خود را وارد کنید!',
            ]);
            exit;
        }

        $un = $_POST['un'];
        $ue = '';

        if (filter_var($un, FILTER_VALIDATE_EMAIL)) {
            $check_user_by_email = get_user_by('email', $un);

            if (!empty($check_user_by_email)) {
                echo wp_json_encode([
                    'status' => 'error',
                    'message' => 'آدرس ایمیل قبلا ثبت شده است!',
                ]);
                exit;
            }

            $ue = $un;
            $un = explode('@', $un);
            $un = $un[0];
        }

        if (!isset($_POST['up']) || empty($_POST['up'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'عبور خود را وارد کنید!',
            ]);
            exit;
        }

        if (!isset($_POST['upr']) || empty($_POST['upr'])) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'تکرار رمز عبور خود را وارد کنید!',
            ]);
            exit;
        }

        if ($_POST['up'] != $_POST['upr']) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'رمز عبور و تکرار آن برابر نیستند!',
            ]);
            exit;
        }

        if (mb_strlen($_POST['up']) < 8) {
            echo wp_json_encode([
                'status' => 'error',
                'message' => 'رمز عبور باید بیشتر از 8 کاراکتر باشد!',
            ]);
            exit;
        }

        $new_user_id = wp_create_user($un, $_POST['up'], $ue);

        add_user_meta($new_user_id, $this->user_phone_meta_key, $_SESSION['WOL_USER_REGISTER_MOBILE']);

        wp_clear_auth_cookie();
        wp_set_current_user($new_user_id);
        wp_set_auth_cookie($new_user_id);

        unset($_SESSION['WOL_USER_REGISTER_MOBILE']);
        unset($_SESSION['WOL_USER_REGISTER_VERIFY_CODE']);
        unset($_SESSION['WOL_USER_LOGIN_LOGIN_NAME']);

        echo wp_json_encode([
            'status' => 'ok',
            'new_user_id' => $new_user_id,
        ]);
        exit;
    }

    public function register_form_render_shortcode()
    {
        if (get_current_user_id()) {
            return;
        }

        if (!get_option('users_can_register')) {
            return;
        }

        ob_start();

        include WOL_PP . 'templates/form-register.php';

        return ob_get_clean();
    }
}

Webafra_OTP_Login::ins();
