function wol_send_verify_code(prefix, nonce) {
	jQuery(prefix + ' #wol_popup_loading').css('display', 'flex');
	jQuery(prefix + ' #wol_popup_error').css('display', 'none');
	jQuery(prefix + ' #wol_popup_error').html('');

	jQuery.ajax({
		type: 'POST',
		url: wol_ajax_var.url,
		dataType: 'json',
		data: {
			action: 'wol_send_verify_code',
			nonce: nonce,
			phone_number: jQuery(prefix + ' #wol_form_input_phone_number').val(),
		},
		success: function (res) {
			if (res.status == 'ok') {
				jQuery(prefix + ' #wol_register_form_phone_number_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_verify_code_row').css('display', 'block');
			}
			else {
				if (res.message) {
					jQuery(prefix + ' #wol_popup_error').html(res.message);
					jQuery(prefix + ' #wol_popup_error').css('display', 'block');
				}
			}

			jQuery(prefix + ' #wol_popup_loading').css('display', 'none');
		},
	});
}

function wol_check_verify_code(prefix, nonce) {
	jQuery(prefix + ' #wol_popup_loading').css('display', 'flex');
	jQuery(prefix + ' #wol_popup_error').css('display', 'none');
	jQuery(prefix + ' #wol_popup_error').html('');

	jQuery.ajax({
		type: 'POST',
		url: wol_ajax_var.url,
		dataType: 'json',
		data: {
			action: 'wol_check_verify_code',
			nonce: nonce,
			code: jQuery(prefix + ' #wol_form_input_code').val(),
		},
		success: function (res) {
			if (res.status == 'do_register') {
				jQuery(prefix + ' #wol_register_form_phone_number_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_verify_code_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_fields_row').css('display', 'flex');
			}
			else if (res.status == 'do_login') {
				jQuery(prefix + ' #wol_register_form_phone_number_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_verify_code_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_fields_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_success_row').css('display', 'flex');

				setTimeout(() => {
					window.location.reload();
				}, 2500);
			}
			else {
				if (res.message) {
					jQuery(prefix + ' #wol_popup_error').html(res.message);
					jQuery(prefix + ' #wol_popup_error').css('display', 'block');
				}
			}

			jQuery(prefix + ' #wol_popup_loading').css('display', 'none');
		},
	});
}

function wol_register_user(prefix) {
	jQuery(prefix + ' #wol_popup_loading').css('display', 'flex');
	jQuery(prefix + ' #wol_popup_error').css('display', 'none');
	jQuery(prefix + ' #wol_popup_error').html('');

	jQuery.ajax({
		type: 'POST',
		url: wol_ajax_var.url,
		dataType: 'json',
		data: {
			action: 'wol_register_user',
			nonce: jQuery(prefix + ' #wol_register_nonce').val(),
			un: jQuery(prefix + ' #wol_form_input_un').val(),
			up: jQuery(prefix + ' #wol_form_input_up').val(),
			upr: jQuery(prefix + ' #wol_form_input_unr').val(),
		},
		success: function (res) {
			if (res.status == 'ok') {
				jQuery(prefix + ' #wol_register_form_phone_number_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_verify_code_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_fields_row').css('display', 'none');
				jQuery(prefix + ' #wol_login_form_fields_row').css('display', 'none');
				jQuery(prefix + ' #wol_register_form_success_row').css('display', 'flex');

				setTimeout(() => {
					window.location.reload();
				}, 2500);
			}
			else {
				if (res.message) {
					jQuery(prefix + ' #wol_popup_error').html(res.message);
					jQuery(prefix + ' #wol_popup_error').css('display', 'block');
				}
			}

			jQuery(prefix + ' #wol_popup_loading').css('display', 'none');
		},
	});
}