<?php

/**
 * Plugin Name: Webafra: Fara Search
 * Description: Create a ajax search form
 * Author: Webafra
 * Author URI: https://webafra.com/
 * Version: 0.0.26
 * Text Domain: webafra-fara-search
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

define('wfs_PF', plugin_dir_url(__FILE__));
define('wfs_PP', plugin_dir_path(__FILE__));

add_action('init', function () {
	load_plugin_textdomain('webafra-fara-search', false, dirname(plugin_basename(__FILE__)) . '/languages');
});

register_activation_hook(__FILE__, function () {
	// Do database tables migrate.
	include_once wfs_PP . '/includes/db-migrate.php';
});

if (function_exists('webafra_core')) {
	include_once wfs_PP . '/includes/functions.php';
	include_once wfs_PP . '/includes/db-queries.php';
	include_once wfs_PP . '/includes/admin-page.php';
	include_once wfs_PP . '/includes/ajax.php';

	if (!function_exists('is_plugin_active')) {
		include_once(ABSPATH . 'wp-admin/includes/plugin.php');
	}

	if (is_plugin_active('elementor/elementor.php')) {
		include_once wfs_PP . '/includes/elementor-init.php';
	}

	include_once wfs_PP . '/includes/widget.php';
	include_once wfs_PP . '/includes/render.php';
}

if (!function_exists('webafra_core')) {
	add_action('admin_notices', function () {
		echo '<div class="notice notice-warning is-dismissible"><p><b>' . __('Webafra: Fara Search', 'webafra-fara-search') . ':</b> ' . __('Webafra core plugin is required!', 'webafra-fara-search') . '</div></p>';
	});
}
