<?php
if (!defined('ABSPATH')) {
	exit;
}
?>
<div class="wfs-render-form wfs-render-form-<?= $form_data->id; ?>" id="wfs-render-form-<?= $tmp_id; ?>">
	<form id="wfs-render-form-form-<?= $tmp_id; ?>" class="search-form" action="<?= $form_action; ?>" method="get" role="search">
		<div class="search-form-container">
			<button type="submit" class="search-form-icon">
				<div id="search-form-icon-<?= $tmp_id; ?>" style="display:flex;">
					<?php if ($form_icon) : ?>
						<img src="<?= $form_icon; ?>" />
					<?php else : ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
							<circle cx="11" cy="11" r="8"></circle>
							<line x1="21" y1="21" x2="16.65" y2="16.65"></line>
						</svg>
					<?php endif; ?>
				</div>

				<div class="search-form-loading" id="search-form-loading-<?= $tmp_id; ?>">
					<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg" stroke="currentColor">
						<g fill="none" fill-rule="evenodd">
							<g transform="translate(1 1)" stroke-width="2">
								<circle stroke-opacity=".5" cx="18" cy="18" r="18" />
								<path d="M36 18c0-9.94-8.06-18-18-18">
									<animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite" />
								</path>
							</g>
						</g>
					</svg>
				</div>
			</button>

			<div class="search-form-inputs <?= (isset($form_data->form_options['post_type_select_location']) && $form_data->form_options['post_type_select_location'] == 'right') ? 'row-reverse' : ''; ?>">
				<div class="search-form-inputs-wrapper">
					<input id="wt-ew-sfa-i-<?= $tmp_id; ?>" placeholder="<?= wfs_get_form_translate($form_data->form_options, 'input_placeholder'); ?>" class="search-form-input" autocomplete="off" type="search" name="<?= $form_data->form_options['search_query_var']; ?>" value="<?= ((isset($_GET['form_id']) && $_GET['form_id'] == $form_data->id) && (isset($_GET[$form_data->form_options['search_query_var']]) && !empty($_GET[$form_data->form_options['search_query_var']]))) ? $_GET[$form_data->form_options['search_query_var']] : ''; ?>">

					<input id="wfs-input-autocomplete-<?= $tmp_id; ?>" type="text" class="search-form-input input-autocomplete" name="phrase" value="" aria-hidden="true" tabindex="-1" autocomplete="off" disabled="">
				</div>

				<?php if (isset($form_data->form_options['show_post_type_select']) && $form_data->form_options['show_post_type_select'] == '1') : ?>

					<?php if (isset($form_data->form_options['dropdown_source']) && $form_data->form_options['dropdown_source'] == 'post_type') : ?>

						<?php $search_result_post_types = explode(',', $form_data->form_options['search_result_post_types']); ?>
						<?php if (!empty($search_result_post_types)) : ?>
							<select id="wfs-search-form-select-post-type-<?= $tmp_id; ?>" name="<?= $form_data->form_options['post_type_query_var']; ?>">
								<?php foreach ($search_result_post_types as $post_type) : ?>
									<option <?= isset($form_data->form_options['default_post_type']) && $form_data->form_options['default_post_type'] == $post_type ? 'selected' : ''; ?> value="<?= $post_type; ?>"><?= get_post_type_object($post_type)->labels->singular_name; ?></option>
								<?php endforeach; ?>
							</select>
						<?php endif; ?>

					<?php elseif (isset($form_data->form_options['dropdown_source']) && $form_data->form_options['dropdown_source'] == 'taxonomy') : ?>

						<?php if (isset($form_data->form_options['taxonomy_dropdown']) && !empty($form_data->form_options['taxonomy_dropdown'])) : ?>
							<?php $tax_terms = get_terms(['taxonomy' => $form_data->form_options['taxonomy_dropdown'], 'hide_empty' => 1]); ?>
							<select id="wfs-search-form-select-category-<?= $tmp_id; ?>" name="<?= isset($form_general_options['category_query_var']) && !empty($form_general_options['category_query_var']) ? $form_general_options['category_query_var'] : 'category_id'; ?>">
								<option value=""><?= __('Select', 'webafra-fara-search'); ?>...</option>
								<?php foreach ($tax_terms as $term) : ?>
									<option value="<?= $term->term_id; ?>" <?= isset($_GET['category_id']) && $_GET['category_id'] == $term->term_id ? 'selected' : ''; ?>><?= $term->name; ?></option>
								<?php endforeach; ?>
							</select>
						<?php endif; ?>

					<?php endif; ?>
				<?php else : ?>
					<input type="hidden" name="<?= $form_data->form_options['post_type_query_var']; ?>" value="<?= $form_data->form_options['default_post_type']; ?>" style="display:none!important;" />
				<?php endif; ?>
			</div>

			<input type="hidden" name="form_id" value="<?= $form_data->id; ?>" style="display:none!important;" />
			<input type="hidden" name="tracking_code" value="<?= isset($_GET['tracking_code']) && !empty($_GET['tracking_code']) ? $_GET['tracking_code'] : ''; ?>" style="display:none!important;" id="wfs-render-form-tracking-code-input-<?= $tmp_id; ?>" />
			<input type="hidden" name="has_result" value="<?= isset($_GET['has_result']) && !empty($_GET['has_result']) ? $_GET['has_result'] : ''; ?>" style="display:none!important;" id="wfs-render-form-has-result-input-<?= $tmp_id; ?>" />
		</div>
	</form>
	<div class="search-wrapper position-absolute" id="wfs-search-wrapper-<?= $tmp_id; ?>">
		<div class="main-wrapper-scroll">
			<div class="results-wrapper" id="wt-ew-sfa-rswb-<?= $tmp_id; ?>">
				<div class="result-wrapper <?= isset($form_data->form_options['search_result_carousel']) && $form_data->form_options['search_result_carousel'] == '1' ? '' : 'result-list-wrapper'; ?>" id="wt-ew-sfa-rwb-<?= $tmp_id; ?>"></div>
				<div class="result-wrapper <?= isset($form_data->form_options['search_result_carousel']) && $form_data->form_options['search_result_carousel'] == '1' ? '' : 'result-list-wrapper'; ?>" id="wt-ew-sfa-rwb-loading-<?= $tmp_id; ?>">
					<?php if (isset($form_data->form_options['search_result_carousel']) && $form_data->form_options['search_result_carousel'] == '1') : ?>
						<div class="swiper-results results-skeleton-swiper">
							<?php for ($s = 1; $s <= 3; $s++) : ?>
								<div class="box-heading search-result search-result-swiper">
									<div class="bh-right">
										<div class="bh-thumbnail"></div>
										<div class="bh-text">
											<div class="bh-text-skeleton"></div>
										</div>
									</div>
									<div class="bh-left"></div>
								</div>
							<?php endfor; ?>
						</div>
					<?php else : ?>
						<?php for ($s = 1; $s <= 3; $s++) : ?>
							<div class="box-heading search-result results-skeleton-list">
								<div class="bh-right">
									<div class="bh-icon"></div>
									<div class="bh-text">
										<div class="bh-text-skeleton"></div>
									</div>
								</div>
								<div class="bh-left"></div>
							</div>
						<?php endfor; ?>
					<?php endif; ?>
				</div>
				<div class="result-wrapper <?= isset($form_data->form_options['search_result_carousel']) && $form_data->form_options['search_result_carousel'] == '1' ? '' : 'result-list-wrapper'; ?>" id="wt-ew-sfa-rwb-ulsr-<?= $tmp_id; ?>" style="display:none;">
				</div>

				<?php if ($form_data->form_options['search_in_post_type_categories']) : ?>
					<div class="result-wrapper related-wrapper category-results" id="wfs-terms-search-results-<?= $tmp_id; ?>"></div>
				<?php endif; ?>

				<div class="result-wrapper related-wrapper" id="wt-ew-sfa-related-wb-<?= $tmp_id; ?>"></div>
				<div class="result-wrapper related-wrapper" id="wt-ew-sfa-related-wb-loading-<?= $tmp_id; ?>">
					<?php for ($s = 1; $s <= 3; $s++) : ?>
						<div class="box-heading search-result results-skeleton-list">
							<div class="bh-right">
								<div class="bh-icon"></div>
								<div class="bh-text">
									<div class="bh-text-skeleton"></div>
								</div>
							</div>
							<div class="bh-left">
								<div class="bh-icon"></div>
							</div>
						</div>
					<?php endfor; ?>
				</div>
			</div>
			<div class="main-wrapper" id="wt-ew-sfa-mwb-<?= $form_data->id; ?>">
				<?php if ($form_data->form_options['search_banner_enable'] == '1') : ?>
					<div id="wt-ew-sfa-banner-section-<?= $tmp_id; ?>" class="main-banner">
						<?php if (!empty($form_data->form_options['search_banner_image'])) : ?>
							<?php $banner_image = wp_get_attachment_image_src($form_data->form_options['search_banner_image'], $form_data->form_options['search_banner_image_size']); ?>
							<?php $banner_image = $banner_image ? $banner_image[0] : null; ?>
							<?php if (!is_null($banner_image)) : ?>
								<a href="<?= $form_data->form_options['search_banner_url']; ?>">
									<img src="<?= $banner_image; ?>" />
								</a>
							<?php endif; ?>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<?php if (
					($form_data->form_options['user_last_searches_enable'] == '1' && get_current_user_id()) ||
					$form_data->form_options['suggested_categories_enable'] == '1' ||
					$form_data->form_options['papular_searches_enable'] == '1'
				) : ?>
					<div class="lists-wrapper" id="wfs-main-lists-wrapper-<?= $tmp_id; ?>" style="display:block;">
						<?php if ($form_data->form_options['suggested_categories_enable'] == '1') : ?>
							<?php $suggested_categories_ids = $form_data->form_options['suggested_categories_ids']; ?>
							<?php if (!empty($suggested_categories_ids)) : ?>
								<?php $suggested_categories_ids = explode(',', $suggested_categories_ids); ?>
								<?php
								$categories = new \WP_Term_Query([
									'hide_empty'   => 0,
									'number'       => 0,
									'include'      => (array) array_values($suggested_categories_ids)
								]);
								?>
								<?php if (count($categories->get_terms())) : ?>
									<div class="suggested-categories-box">
										<div class="box-heading suggested-categories">
											<div class="bh-right">
												<div class="bh-icon">
													<?php if ($suggested_categories_icon) : ?>
														<img src="<?= $suggested_categories_icon; ?>" />
													<?php else : ?>
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
															<path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path>
														</svg>
													<?php endif; ?>
												</div>
												<div class="bh-text">
													<?= wfs_get_form_translate($form_data->form_options, 'suggested_categories_title'); ?>
												</div>
											</div>
											<div class="bh-left"></div>
										</div>
										<div class="box-items suggested-categories owl-carousel owl-theme" id="wt-ew-sfa-suggested-categories-items-<?= $tmp_id; ?>">
											<?php foreach (array_values($categories->get_terms()) as $cat) : ?>
												<div class="box-item">
													<a href="<?= esc_url(get_category_link($cat->term_id)); ?>" title="<?= $cat->name; ?>">
														<span><?= $cat->name; ?></span>
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
															<path d="M15 18l-6-6 6-6" />
														</svg>
													</a>
												</div>
											<?php endforeach; ?>
										</div>
										<script>
											(function($) {
												$('#wt-ew-sfa-suggested-categories-items-<?= $tmp_id; ?>').owlCarousel({
													items: 5,
													margin: 10,
													responsiveClass: true,
													nav: 1,
													dots: 0,
													autoplay: 0,
													loop: 0,
													autoWidth: 1,
													<?= is_rtl() ? 'rtl: true' : 'rtl: false'; ?>,
												})
											})(jQuery);
										</script>
									</div>
								<?php endif; ?>
							<?php endif; ?>
						<?php endif; ?>

						<?php if ($form_data->form_options['user_last_searches_enable'] == '1') : ?>
							<div class="wt-ew-sfa-lus-section last-user-searches-box wfs-uls-wrapper wfs-uls-wrapper-<?= $tmp_id; ?>" style="display: none;">
								<div class="box-heading last-user-searches">
									<div class="bh-right">
										<div class="bh-icon">
											<?php if ($user_last_searches_icon) : ?>
												<img src="<?= $user_last_searches_icon; ?>" />
											<?php else : ?>
												<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
													<circle cx="12" cy="12" r="10"></circle>
													<polyline points="12 6 12 12 16 14"></polyline>
												</svg>
											<?php endif; ?>
										</div>
										<div class="bh-text">
											<?= wfs_get_form_translate($form_data->form_options, 'user_last_searches_title'); ?>
										</div>
									</div>
									<div class="bh-left">
										<div class="bh-icon clear" onclick="wfs_clear_uls();">
											<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
												<polyline points="3 6 5 6 21 6"></polyline>
												<path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
												<line x1="10" y1="11" x2="10" y2="17"></line>
												<line x1="14" y1="11" x2="14" y2="17"></line>
											</svg>
										</div>
									</div>
								</div>
								<div class="box-items wfs-uls-carousel-<?= $tmp_id; ?> owl-carousel owl-theme">

								</div>
							</div>
							<script>
								setTimeout(() => {
									wfs_get_uls_html(
										'.wfs-uls-carousel-<?= $tmp_id; ?>',
										'.wfs-uls-wrapper-<?= $tmp_id; ?>',
										'<?= $form_data->id; ?>',
										'<?= $form_action; ?>',
										'<?= $form_data->form_options['default_post_type']; ?>',
										'<?= $form_data->form_options['search_query_var']; ?>',
										'<?= $form_data->form_options['post_type_query_var']; ?>',
									);
								}, 1000);
							</script>
						<?php endif; ?>

						<?php if ($form_data->form_options['papular_searches_enable'] == '1') : ?>
							<?php $popular_searches = WFS_DB_Queries::get_popular_searches((int) $form_data->id, $form_data->form_options['papular_searches_range_start']); ?>
							<?php if ($popular_searches !== false && (is_array($popular_searches) && count($popular_searches))) : ?>
								<div class="popular-searches-box">
									<div class="box-heading popular-searches">
										<div class="bh-right">
											<div class="bh-icon">
												<?php if ($papular_searches_icon) : ?>
													<img src="<?= $papular_searches_icon; ?>" />
												<?php else : ?>
													<svg width="24" height="24" viewBox="0 0 24 24" fill="" xmlns="http://www.w3.org/2000/svg" stroke="">
														<path fill-rule="evenodd" clip-rule="evenodd" d="M11.8202 1.17444L12.7809 2.37532C13.9186 3.7975 14.3379 5.20075 14.299 6.54704C14.2612 7.85605 13.7915 9.02304 13.3225 9.98619C13.1649 10.3098 12.9946 10.6349 12.8386 10.9327C12.7663 11.0708 12.697 11.203 12.6335 11.3265C12.4214 11.739 12.2593 12.0804 12.1563 12.3799C12.0528 12.6806 12.0336 12.8708 12.0468 12.991C12.0567 13.0817 12.0872 13.173 12.2071 13.2929C12.4054 13.4912 12.5517 13.5469 12.6404 13.5639C12.731 13.5814 12.8515 13.5757 13.0239 13.5049C13.4095 13.3463 13.8803 12.9334 14.3743 12.314C14.8488 11.719 15.2631 11.0384 15.5634 10.4938C15.712 10.2242 15.8295 9.99387 15.9091 9.83234C15.9488 9.75168 15.979 9.6885 15.9988 9.64651L16.0205 9.59999L16.0252 9.58959L16.0259 9.58824L16.026 9.5879L16.0261 9.58776L16.0261 9.58771L16.6117 8.29169L17.6332 9.28206C19.946 11.5244 20.6617 14.7623 19.1415 17.7019C17.8195 20.2583 15.1123 22 12 22C7.60499 22 4 18.5172 4 14.1697C4 11.8793 5.26687 10.2404 6.64671 8.62914C6.82673 8.41894 7.0107 8.20711 7.19757 7.99194C8.47882 6.5167 9.89649 4.88437 11.1122 2.5397L11.8202 1.17444ZM17.1269 11.7924C16.8148 12.3321 16.4089 12.9705 15.9379 13.561C15.3851 14.2542 14.6528 14.9975 13.7846 15.3546C13.33 15.5415 12.8109 15.6335 12.2624 15.5279C11.7119 15.4219 11.2196 15.1338 10.7929 14.7071C10.3617 14.2759 10.1196 13.7664 10.0586 13.2082C10.0008 12.6794 10.1126 12.1723 10.2651 11.729C10.4181 11.2846 10.6372 10.8353 10.8549 10.412C10.9327 10.2606 11.0095 10.114 11.0856 9.96886C11.2338 9.68618 11.3792 9.40866 11.5243 9.11064C11.9559 8.22433 12.2745 7.36712 12.2998 6.48929C12.3134 6.01847 12.2432 5.51449 12.0273 4.9728C10.9109 6.77097 9.71215 8.14915 8.69763 9.31555C8.51377 9.52693 8.33596 9.73135 8.16579 9.93006C6.7748 11.5543 6 12.6877 6 14.1697C6 17.3667 8.66302 20 12 20C14.3543 20 16.3818 18.6846 17.365 16.7832C18.2267 15.1169 18.1049 13.3127 17.1269 11.7924Z" fill="" />
													</svg>
												<?php endif; ?>
											</div>
											<div class="bh-text">
												<?= wfs_get_form_translate($form_data->form_options, 'papular_searches_title'); ?>
											</div>
										</div>
										<div class="bh-left"></div>
									</div>
									<div class="box-items popular-searches last owl-carousel owl-theme" id="wt-ew-sfa-popular-searches-items-<?= $tmp_id; ?>">
										<?php foreach ($popular_searches as $popular_search) : ?>
											<div class="box-item">
												<a href="<?= $form_action; ?>?<?= $form_data->form_options['search_query_var']; ?>=<?= str_replace(' ', '+', $popular_search->text); ?>&form_id=<?= $form_data->id; ?><?= !empty($form_data->form_options['default_post_type']) ? '&' . $form_data->form_options['post_type_query_var'] . '=' . $form_data->form_options['default_post_type'] : ''; ?>" title="<?= $popular_search->text; ?>">
													<span><?= $popular_search->text; ?></span>
													<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
														<path d="M15 18l-6-6 6-6" />
													</svg>
												</a>
											</div>
										<?php endforeach; ?>
									</div>
									<script>
										(function($) {
											$('#wt-ew-sfa-popular-searches-items-<?= $tmp_id; ?>').owlCarousel({
												items: 5,
												margin: 10,
												responsiveClass: true,
												nav: 1,
												dots: 0,
												autoplay: 0,
												loop: 0,
												autoWidth: 1,
												<?= is_rtl() ? 'rtl: true' : 'rtl: false'; ?>,
											})
										})(jQuery);
									</script>
								</div>
							<?php endif; ?>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>