<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
   die;
}
?>
<div class="wfs-main">
   <form action="<?= $this->request_uri; ?>" method="POST">
      <div class="wfs-heading form sticky-top">
         <ul>
            <li class="<?= $current_tab == 'general' ? 'active' : ''; ?>">
               <a href="admin.php?page=wfs-settings&tab=general"><?php _e('General', 'webafra-fara-search'); ?></a>
            </li>
         </ul>
         <div style="display:flex;gap:1rem;">
            <button type="submit" name="settings_submit" class="wfs-button svg-medium">
               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                  <polyline points="17 21 17 13 7 13 7 21"></polyline>
                  <polyline points="7 3 7 8 15 8"></polyline>
               </svg>
               <?php _e('Update', 'webafra-fara-search'); ?>
            </button>
         </div>
      </div>
      <div class="wfs-content">
         <?php if (isset($_GET['success']) && $_GET['success'] == '1') : ?>
            <div class="wfs-alert success"><?= __('Settings saved.', 'webafra-fara-search'); ?></div>
         <?php endif; ?>
         <?php if ($current_tab == 'general') : ?>
            <div class="wfs-rows nbb">
               <div class="wfs-columns w-25">
                  <label for="wfs_settings_calendar"><?php _e('Calendars', 'webafra-fara-search'); ?></label>
               </div>
               <div class="wfs-columns w-75">
                  <select name="wfs_settings_calendar" id="wfs_settings_calendar" class="wfs-input wfs-select">
                     <option <?= get_option('wfs_settings_calendar', 'gregorian') == 'gregorian' ? 'selected' : ''; ?> value="gregorian"><?= __('Gregorian', 'webafra-fara-search'); ?></option>
                     <option <?= get_option('wfs_settings_calendar', 'gregorian') == 'shamsi_calendar' ? 'selected' : ''; ?> value="shamsi_calendar"><?= __('Shamsi', 'webafra-fara-search'); ?></option>
                     <option <?= get_option('wfs_settings_calendar', 'gregorian') == 'hijri_calendar' ? 'selected' : ''; ?> value="hijri_calendar"><?= __('Hijri', 'webafra-fara-search'); ?></option>
                  </select>
               </div>
            </div>
         <?php endif; ?>
      </div>
   </form>
</div>